// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudwatchlogs

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns detailed information about a specified scheduled query, including its
// configuration, current state, and execution history.
func (c *Client) GetScheduledQuery(ctx context.Context, params *GetScheduledQueryInput, optFns ...func(*Options)) (*GetScheduledQueryOutput, error) {
	if params == nil {
		params = &GetScheduledQueryInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetScheduledQuery", params, optFns, c.addOperationGetScheduledQueryMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetScheduledQueryOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetScheduledQueryInput struct {

	// The name or ARN of the scheduled query to retrieve.
	//
	// This member is required.
	Identifier *string

	noSmithyDocumentSerde
}

type GetScheduledQueryOutput struct {

	// The time when the scheduled query was created, in Unix epoch time.
	CreationTime *int64

	// The description of the scheduled query.
	Description *string

	// Configuration for destinations where the query results are delivered.
	DestinationConfiguration *types.DestinationConfiguration

	// The ARN of the IAM role used to execute the scheduled query.
	ExecutionRoleArn *string

	// The status of the last executed query (Running, Complete, Failed, Timeout, or
	// InvalidQuery).
	LastExecutionStatus types.ExecutionStatus

	// The time when the scheduled query was last executed, in Unix epoch time.
	LastTriggeredTime *int64

	// The time when the scheduled query was last updated, in Unix epoch time.
	LastUpdatedTime *int64

	// The log group identifiers being queried by the scheduled query.
	LogGroupIdentifiers []string

	// The name of the scheduled query.
	Name *string

	// The query language used by the scheduled query (LogsQL, PPL, or SQL).
	QueryLanguage types.QueryLanguage

	// The CloudWatch Logs Insights query string being executed.
	QueryString *string

	// The end time for the query schedule in Unix epoch time.
	ScheduleEndTime *int64

	// The cron expression that defines when the scheduled query runs.
	ScheduleExpression *string

	// The start time for the query schedule in Unix epoch time.
	ScheduleStartTime *int64

	// The Amazon Resource Name (ARN) of the scheduled query.
	ScheduledQueryArn *string

	// Time offset in seconds from the execution time for the start of the query time
	// range.
	StartTimeOffset *int64

	// The current state of the scheduled query (ENABLED or DISABLED).
	State types.ScheduledQueryState

	// The timezone in which the schedule expression is evaluated.
	Timezone *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetScheduledQueryMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetScheduledQuery{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetScheduledQuery{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetScheduledQuery"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetScheduledQueryValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetScheduledQuery(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetScheduledQuery(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetScheduledQuery",
	}
}
