/* Autogenerated file, do not edit */
/*
 * Copyright 2024 Collabora Ltd.
 * SPDX-License-Identifier: MIT
 */

#ifndef PAN_PACK_H
#define PAN_PACK_H

#include "genxml/pan_pack_helpers.h"


#define mali_pixel_format_print(fp, format) \
    fprintf(fp, "%*sFormat (v6): %s%s%s %s%s%s%s\n", indent, "", \
        mali_format_as_str((enum mali_format)((format >> 12) & 0xFF)), \
        (format & (1 << 20)) ? " sRGB" : "", \
        (format & (1 << 21)) ? " big-endian" : "", \
        mali_channel_as_str((enum mali_channel)((format >> 0) & 0x7)), \
        mali_channel_as_str((enum mali_channel)((format >> 3) & 0x7)), \
        mali_channel_as_str((enum mali_channel)((format >> 6) & 0x7)), \
        mali_channel_as_str((enum mali_channel)((format >> 9) & 0x7)));

enum mali_attribute_type {
        MALI_ATTRIBUTE_TYPE_1D               =      1,
        MALI_ATTRIBUTE_TYPE_1D_POT_DIVISOR   =      2,
        MALI_ATTRIBUTE_TYPE_1D_MODULUS       =      3,
        MALI_ATTRIBUTE_TYPE_1D_NPOT_DIVISOR  =      4,
        MALI_ATTRIBUTE_TYPE_3D_LINEAR        =      5,
        MALI_ATTRIBUTE_TYPE_3D_INTERLEAVED   =      6,
        MALI_ATTRIBUTE_TYPE_1D_PRIMITIVE_INDEX_BUFFER =      7,
        MALI_ATTRIBUTE_TYPE_1D_POT_DIVISOR_WRITE_REDUCTION =     10,
        MALI_ATTRIBUTE_TYPE_1D_MODULUS_WRITE_REDUCTION =     11,
        MALI_ATTRIBUTE_TYPE_1D_NPOT_DIVISOR_WRITE_REDUCTION =     12,
        MALI_ATTRIBUTE_TYPE_CONTINUATION     =     32,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_attribute_type_as_str(enum mali_attribute_type imm)
{
    switch (imm) {
    case MALI_ATTRIBUTE_TYPE_1D: return "1D";
    case MALI_ATTRIBUTE_TYPE_1D_POT_DIVISOR: return "1D POT Divisor";
    case MALI_ATTRIBUTE_TYPE_1D_MODULUS: return "1D Modulus";
    case MALI_ATTRIBUTE_TYPE_1D_NPOT_DIVISOR: return "1D NPOT Divisor";
    case MALI_ATTRIBUTE_TYPE_3D_LINEAR: return "3D Linear";
    case MALI_ATTRIBUTE_TYPE_3D_INTERLEAVED: return "3D Interleaved";
    case MALI_ATTRIBUTE_TYPE_1D_PRIMITIVE_INDEX_BUFFER: return "1D Primitive Index Buffer";
    case MALI_ATTRIBUTE_TYPE_1D_POT_DIVISOR_WRITE_REDUCTION: return "1D POT Divisor Write Reduction";
    case MALI_ATTRIBUTE_TYPE_1D_MODULUS_WRITE_REDUCTION: return "1D Modulus Write Reduction";
    case MALI_ATTRIBUTE_TYPE_1D_NPOT_DIVISOR_WRITE_REDUCTION: return "1D NPOT Divisor Write Reduction";
    case MALI_ATTRIBUTE_TYPE_CONTINUATION: return "Continuation";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_attribute_special {
        MALI_ATTRIBUTE_SPECIAL_POINT_COORD_MIN_Y =     33,
        MALI_ATTRIBUTE_SPECIAL_VERTEX_ID     =     34,
        MALI_ATTRIBUTE_SPECIAL_INSTANCE_ID   =     36,
        MALI_ATTRIBUTE_SPECIAL_FRAG_COORD    =     37,
        MALI_ATTRIBUTE_SPECIAL_FRONT_FACING  =     38,
        MALI_ATTRIBUTE_SPECIAL_POINT_COORD_MAX_Y =     97,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_attribute_special_as_str(enum mali_attribute_special imm)
{
    switch (imm) {
    case MALI_ATTRIBUTE_SPECIAL_POINT_COORD_MIN_Y: return "Point Coord Min Y";
    case MALI_ATTRIBUTE_SPECIAL_VERTEX_ID: return "Vertex ID";
    case MALI_ATTRIBUTE_SPECIAL_INSTANCE_ID: return "Instance ID";
    case MALI_ATTRIBUTE_SPECIAL_FRAG_COORD: return "Frag Coord";
    case MALI_ATTRIBUTE_SPECIAL_FRONT_FACING: return "Front Facing";
    case MALI_ATTRIBUTE_SPECIAL_POINT_COORD_MAX_Y: return "Point Coord Max Y";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_channel {
        MALI_CHANNEL_R                       =      0,
        MALI_CHANNEL_G                       =      1,
        MALI_CHANNEL_B                       =      2,
        MALI_CHANNEL_A                       =      3,
        MALI_CHANNEL_0                       =      4,
        MALI_CHANNEL_1                       =      5,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_channel_as_str(enum mali_channel imm)
{
    switch (imm) {
    case MALI_CHANNEL_R: return "R";
    case MALI_CHANNEL_G: return "G";
    case MALI_CHANNEL_B: return "B";
    case MALI_CHANNEL_A: return "A";
    case MALI_CHANNEL_0: return "0";
    case MALI_CHANNEL_1: return "1";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_depth_source {
        MALI_DEPTH_SOURCE_MINIMUM            =      0,
        MALI_DEPTH_SOURCE_MAXIMUM            =      1,
        MALI_DEPTH_SOURCE_FIXED_FUNCTION     =      2,
        MALI_DEPTH_SOURCE_SHADER             =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_depth_source_as_str(enum mali_depth_source imm)
{
    switch (imm) {
    case MALI_DEPTH_SOURCE_MINIMUM: return "Minimum";
    case MALI_DEPTH_SOURCE_MAXIMUM: return "Maximum";
    case MALI_DEPTH_SOURCE_FIXED_FUNCTION: return "Fixed function";
    case MALI_DEPTH_SOURCE_SHADER: return "Shader";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_job_type {
        MALI_JOB_TYPE_NOT_STARTED            =      0,
        MALI_JOB_TYPE_NULL                   =      1,
        MALI_JOB_TYPE_WRITE_VALUE            =      2,
        MALI_JOB_TYPE_CACHE_FLUSH            =      3,
        MALI_JOB_TYPE_COMPUTE                =      4,
        MALI_JOB_TYPE_VERTEX                 =      5,
        MALI_JOB_TYPE_GEOMETRY               =      6,
        MALI_JOB_TYPE_TILER                  =      7,
        MALI_JOB_TYPE_FUSED                  =      8,
        MALI_JOB_TYPE_FRAGMENT               =      9,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_job_type_as_str(enum mali_job_type imm)
{
    switch (imm) {
    case MALI_JOB_TYPE_NOT_STARTED: return "Not started";
    case MALI_JOB_TYPE_NULL: return "Null";
    case MALI_JOB_TYPE_WRITE_VALUE: return "Write value";
    case MALI_JOB_TYPE_CACHE_FLUSH: return "Cache flush";
    case MALI_JOB_TYPE_COMPUTE: return "Compute";
    case MALI_JOB_TYPE_VERTEX: return "Vertex";
    case MALI_JOB_TYPE_GEOMETRY: return "Geometry";
    case MALI_JOB_TYPE_TILER: return "Tiler";
    case MALI_JOB_TYPE_FUSED: return "Fused";
    case MALI_JOB_TYPE_FRAGMENT: return "Fragment";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_draw_mode {
        MALI_DRAW_MODE_POINTS                =      1,
        MALI_DRAW_MODE_LINES                 =      2,
        MALI_DRAW_MODE_LINES_WITH_ADJACENCY  =      3,
        MALI_DRAW_MODE_LINE_STRIP            =      4,
        MALI_DRAW_MODE_LINE_STRIP_WITH_ADJACENCY =      5,
        MALI_DRAW_MODE_LINE_LOOP             =      6,
        MALI_DRAW_MODE_TRIANGLES             =      8,
        MALI_DRAW_MODE_TRIANGLES_WITH_ADJACENCY =      9,
        MALI_DRAW_MODE_TRIANGLE_STRIP        =     10,
        MALI_DRAW_MODE_TRIANGLE_STRIP_WITH_ADJACENCY =     11,
        MALI_DRAW_MODE_TRIANGLE_FAN          =     12,
        MALI_DRAW_MODE_POLYGON               =     13,
        MALI_DRAW_MODE_QUADS                 =     14,
        MALI_DRAW_MODE_QUAD_STRIP            =     15,
        MALI_DRAW_MODE_PARALLELOGRAM         =     16,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_draw_mode_as_str(enum mali_draw_mode imm)
{
    switch (imm) {
    case MALI_DRAW_MODE_POINTS: return "Points";
    case MALI_DRAW_MODE_LINES: return "Lines";
    case MALI_DRAW_MODE_LINES_WITH_ADJACENCY: return "Lines with adjacency";
    case MALI_DRAW_MODE_LINE_STRIP: return "Line strip";
    case MALI_DRAW_MODE_LINE_STRIP_WITH_ADJACENCY: return "Line strip with adjacency";
    case MALI_DRAW_MODE_LINE_LOOP: return "Line loop";
    case MALI_DRAW_MODE_TRIANGLES: return "Triangles";
    case MALI_DRAW_MODE_TRIANGLES_WITH_ADJACENCY: return "Triangles with adjacency";
    case MALI_DRAW_MODE_TRIANGLE_STRIP: return "Triangle strip";
    case MALI_DRAW_MODE_TRIANGLE_STRIP_WITH_ADJACENCY: return "Triangle strip with adjacency";
    case MALI_DRAW_MODE_TRIANGLE_FAN: return "Triangle fan";
    case MALI_DRAW_MODE_POLYGON: return "Polygon";
    case MALI_DRAW_MODE_QUADS: return "Quads";
    case MALI_DRAW_MODE_QUAD_STRIP: return "Quad strip";
    case MALI_DRAW_MODE_PARALLELOGRAM: return "Parallelogram";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_exception_access {
        MALI_EXCEPTION_ACCESS_NONE           =      0,
        MALI_EXCEPTION_ACCESS_EXECUTE        =      2,
        MALI_EXCEPTION_ACCESS_READ           =      1,
        MALI_EXCEPTION_ACCESS_WRITE          =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_exception_access_as_str(enum mali_exception_access imm)
{
    switch (imm) {
    case MALI_EXCEPTION_ACCESS_NONE: return "None";
    case MALI_EXCEPTION_ACCESS_EXECUTE: return "Execute";
    case MALI_EXCEPTION_ACCESS_READ: return "Read";
    case MALI_EXCEPTION_ACCESS_WRITE: return "Write";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_func {
        MALI_FUNC_NEVER                      =      0,
        MALI_FUNC_LESS                       =      1,
        MALI_FUNC_EQUAL                      =      2,
        MALI_FUNC_LEQUAL                     =      3,
        MALI_FUNC_GREATER                    =      4,
        MALI_FUNC_NOT_EQUAL                  =      5,
        MALI_FUNC_GEQUAL                     =      6,
        MALI_FUNC_ALWAYS                     =      7,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_func_as_str(enum mali_func imm)
{
    switch (imm) {
    case MALI_FUNC_NEVER: return "Never";
    case MALI_FUNC_LESS: return "Less";
    case MALI_FUNC_EQUAL: return "Equal";
    case MALI_FUNC_LEQUAL: return "Lequal";
    case MALI_FUNC_GREATER: return "Greater";
    case MALI_FUNC_NOT_EQUAL: return "Not Equal";
    case MALI_FUNC_GEQUAL: return "Gequal";
    case MALI_FUNC_ALWAYS: return "Always";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_format {
        MALI_ETC2_RGB8                       =      1,
        MALI_ETC2_R11_UNORM                  =      2,
        MALI_ETC2_RGBA8                      =      3,
        MALI_ETC2_RG11_UNORM                 =      4,
        MALI_NXR                             =      6,
        MALI_BC1_UNORM                       =      7,
        MALI_BC2_UNORM                       =      8,
        MALI_BC3_UNORM                       =      9,
        MALI_BC4_UNORM                       =     10,
        MALI_BC4_SNORM                       =     11,
        MALI_BC5_UNORM                       =     12,
        MALI_BC5_SNORM                       =     13,
        MALI_BC6H_UF16                       =     14,
        MALI_BC6H_SF16                       =     15,
        MALI_BC7_UNORM                       =     16,
        MALI_ETC2_R11_SNORM                  =     17,
        MALI_ETC2_RG11_SNORM                 =     18,
        MALI_ETC2_RGB8A1                     =     19,
        MALI_RGB565                          =     64,
        MALI_RGB5_A1_UNORM                   =     65,
        MALI_A1_BGR5_UNORM                   =     66,
        MALI_RGB10_A2_UNORM                  =     67,
        MALI_A2_BGR10_UNORM                  =     68,
        MALI_RGB10_A2_SNORM                  =     69,
        MALI_A2_BGR10_SNORM                  =     70,
        MALI_RGB10_A2UI                      =     71,
        MALI_A2_BGR10UI                      =     72,
        MALI_RGB10_A2I                       =     73,
        MALI_A2_BGR10I                       =     74,
        MALI_RGB332_UNORM                    =     75,
        MALI_BGR233_UNORM                    =     76,
        MALI_Z24X8_UNORM                     =     77,
        MALI_X8Z24                           =     78,
        MALI_X32_S8X24                       =     79,
        MALI_X24S8_X32                       =     80,
        MALI_R32_FIXED                       =     81,
        MALI_RG32_FIXED                      =     82,
        MALI_RGB32_FIXED                     =     83,
        MALI_RGBA32_FIXED                    =     84,
        MALI_TILEBUFFER_NATIVE               =     85,
        MALI_R11F_G11F_B10F                  =     89,
        MALI_B10F_G11F_R11F                  =     90,
        MALI_R9F_G9F_B9F_E5F                 =     91,
        MALI_E5F_B9F_G9F_R9F                 =     92,
        MALI_SNAP_2                          =     93,
        MALI_SNAP_4                          =     94,
        MALI_CONSTANT                        =     95,
        MALI_R1_SNORM                        =     96,
        MALI_R2_SNORM                        =     97,
        MALI_R4_SNORM                        =     98,
        MALI_R8_SNORM                        =     99,
        MALI_R16_SNORM                       =    100,
        MALI_R32_SNORM                       =    101,
        MALI_R64_SNORM                       =    102,
        MALI_RG1_SNORM                       =    104,
        MALI_RG2_SNORM                       =    105,
        MALI_RG4_SNORM                       =    106,
        MALI_RG8_SNORM                       =    107,
        MALI_RG16_SNORM                      =    108,
        MALI_RG32_SNORM                      =    109,
        MALI_RG64_SNORM                      =    110,
        MALI_RGB1_SNORM                      =    112,
        MALI_RGB2_SNORM                      =    113,
        MALI_RGB4_SNORM                      =    114,
        MALI_RGB8_SNORM                      =    115,
        MALI_RGB16_SNORM                     =    116,
        MALI_RGB32_SNORM                     =    117,
        MALI_RGB64_SNORM                     =    118,
        MALI_RGBA1_SNORM                     =    120,
        MALI_RGBA2_SNORM                     =    121,
        MALI_RGBA4_SNORM                     =    122,
        MALI_RGBA8_SNORM                     =    123,
        MALI_RGBA16_SNORM                    =    124,
        MALI_RGBA32_SNORM                    =    125,
        MALI_RGBA64_SNORM                    =    126,
        MALI_R1UI                            =    128,
        MALI_R2UI                            =    129,
        MALI_R4UI                            =    130,
        MALI_R8UI                            =    131,
        MALI_R16UI                           =    132,
        MALI_R32UI                           =    133,
        MALI_R64UI                           =    134,
        MALI_R64F                            =    135,
        MALI_RG1UI                           =    136,
        MALI_RG2UI                           =    137,
        MALI_RG4UI                           =    138,
        MALI_RG8UI                           =    139,
        MALI_RG16UI                          =    140,
        MALI_RG32UI                          =    141,
        MALI_RG64UI                          =    142,
        MALI_RG64F                           =    143,
        MALI_RGB1UI                          =    144,
        MALI_RGB2UI                          =    145,
        MALI_RGB4UI                          =    146,
        MALI_RGB8UI                          =    147,
        MALI_RGB16UI                         =    148,
        MALI_RGB32UI                         =    149,
        MALI_RGB64UI                         =    150,
        MALI_RGB64F                          =    151,
        MALI_RGBA1UI                         =    152,
        MALI_RGBA2UI                         =    153,
        MALI_RGBA4UI                         =    154,
        MALI_RGBA8UI                         =    155,
        MALI_RGBA16UI                        =    156,
        MALI_RGBA32UI                        =    157,
        MALI_RGBA64UI                        =    158,
        MALI_RGBA64F                         =    159,
        MALI_R1_UNORM                        =    160,
        MALI_R2_UNORM                        =    161,
        MALI_R4_UNORM                        =    162,
        MALI_R8_UNORM                        =    163,
        MALI_R16_UNORM                       =    164,
        MALI_R32_UNORM                       =    165,
        MALI_R64_UNORM                       =    166,
        MALI_R32F                            =    167,
        MALI_RG1_UNORM                       =    168,
        MALI_RG2_UNORM                       =    169,
        MALI_RG4_UNORM                       =    170,
        MALI_RG8_UNORM                       =    171,
        MALI_RG16_UNORM                      =    172,
        MALI_RG32_UNORM                      =    173,
        MALI_RG64_UNORM                      =    174,
        MALI_RG32F                           =    175,
        MALI_RGB1_UNORM                      =    176,
        MALI_RGB2_UNORM                      =    177,
        MALI_RGB4_UNORM                      =    178,
        MALI_RGB8_UNORM                      =    179,
        MALI_RGB16_UNORM                     =    180,
        MALI_RGB32_UNORM                     =    181,
        MALI_RGB64_UNORM                     =    182,
        MALI_RGB32F                          =    183,
        MALI_RGBA1_UNORM                     =    184,
        MALI_RGBA2_UNORM                     =    185,
        MALI_RGBA4_UNORM                     =    186,
        MALI_RGBA8_UNORM                     =    187,
        MALI_RGBA16_UNORM                    =    188,
        MALI_RGBA32_UNORM                    =    189,
        MALI_RGBA64_UNORM                    =    190,
        MALI_RGBA32F                         =    191,
        MALI_R1I                             =    192,
        MALI_R2I                             =    193,
        MALI_R4I                             =    194,
        MALI_R8I                             =    195,
        MALI_R16I                            =    196,
        MALI_R32I                            =    197,
        MALI_R64I                            =    198,
        MALI_R16F                            =    199,
        MALI_RG1I                            =    200,
        MALI_RG2I                            =    201,
        MALI_RG4I                            =    202,
        MALI_RG8I                            =    203,
        MALI_RG16I                           =    204,
        MALI_RG32I                           =    205,
        MALI_RG64I                           =    206,
        MALI_RG16F                           =    207,
        MALI_RGB1I                           =    208,
        MALI_RGB2I                           =    209,
        MALI_RGB4I                           =    210,
        MALI_RGB8I                           =    211,
        MALI_RGB16I                          =    212,
        MALI_RGB32I                          =    213,
        MALI_RGB64I                          =    214,
        MALI_RGB16F                          =    215,
        MALI_RGBA1I                          =    216,
        MALI_RGBA2I                          =    217,
        MALI_RGBA4I                          =    218,
        MALI_RGBA8I                          =    219,
        MALI_RGBA16I                         =    220,
        MALI_RGBA32I                         =    221,
        MALI_RGBA64I                         =    222,
        MALI_RGBA16F                         =    223,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_format_as_str(enum mali_format imm)
{
    switch (imm) {
    case MALI_ETC2_RGB8: return "ETC2 RGB8";
    case MALI_ETC2_R11_UNORM: return "ETC2 R11 UNORM";
    case MALI_ETC2_RGBA8: return "ETC2 RGBA8";
    case MALI_ETC2_RG11_UNORM: return "ETC2 RG11 UNORM";
    case MALI_NXR: return "NXR";
    case MALI_BC1_UNORM: return "BC1 UNORM";
    case MALI_BC2_UNORM: return "BC2 UNORM";
    case MALI_BC3_UNORM: return "BC3 UNORM";
    case MALI_BC4_UNORM: return "BC4 UNORM";
    case MALI_BC4_SNORM: return "BC4 SNORM";
    case MALI_BC5_UNORM: return "BC5 UNORM";
    case MALI_BC5_SNORM: return "BC5 SNORM";
    case MALI_BC6H_UF16: return "BC6H UF16";
    case MALI_BC6H_SF16: return "BC6H SF16";
    case MALI_BC7_UNORM: return "BC7 UNORM";
    case MALI_ETC2_R11_SNORM: return "ETC2 R11 SNORM";
    case MALI_ETC2_RG11_SNORM: return "ETC2 RG11 SNORM";
    case MALI_ETC2_RGB8A1: return "ETC2 RGB8A1";
    case MALI_RGB565: return "RGB565";
    case MALI_RGB5_A1_UNORM: return "RGB5 A1 UNORM";
    case MALI_A1_BGR5_UNORM: return "A1 BGR5 UNORM";
    case MALI_RGB10_A2_UNORM: return "RGB10 A2 UNORM";
    case MALI_A2_BGR10_UNORM: return "A2 BGR10 UNORM";
    case MALI_RGB10_A2_SNORM: return "RGB10 A2 SNORM";
    case MALI_A2_BGR10_SNORM: return "A2 BGR10 SNORM";
    case MALI_RGB10_A2UI: return "RGB10 A2UI";
    case MALI_A2_BGR10UI: return "A2 BGR10UI";
    case MALI_RGB10_A2I: return "RGB10 A2I";
    case MALI_A2_BGR10I: return "A2 BGR10I";
    case MALI_RGB332_UNORM: return "RGB332 UNORM";
    case MALI_BGR233_UNORM: return "BGR233 UNORM";
    case MALI_Z24X8_UNORM: return "Z24X8 UNORM";
    case MALI_X8Z24: return "X8Z24";
    case MALI_X32_S8X24: return "X32 S8X24";
    case MALI_X24S8_X32: return "X24S8 X32";
    case MALI_R32_FIXED: return "R32 FIXED";
    case MALI_RG32_FIXED: return "RG32 FIXED";
    case MALI_RGB32_FIXED: return "RGB32 FIXED";
    case MALI_RGBA32_FIXED: return "RGBA32 FIXED";
    case MALI_TILEBUFFER_NATIVE: return "Tilebuffer Native";
    case MALI_R11F_G11F_B10F: return "R11F G11F B10F";
    case MALI_B10F_G11F_R11F: return "B10F G11F R11F";
    case MALI_R9F_G9F_B9F_E5F: return "R9F G9F B9F E5F";
    case MALI_E5F_B9F_G9F_R9F: return "E5F B9F G9F R9F";
    case MALI_SNAP_2: return "Snap 2";
    case MALI_SNAP_4: return "Snap 4";
    case MALI_CONSTANT: return "Constant";
    case MALI_R1_SNORM: return "R1 SNORM";
    case MALI_R2_SNORM: return "R2 SNORM";
    case MALI_R4_SNORM: return "R4 SNORM";
    case MALI_R8_SNORM: return "R8 SNORM";
    case MALI_R16_SNORM: return "R16 SNORM";
    case MALI_R32_SNORM: return "R32 SNORM";
    case MALI_R64_SNORM: return "R64 SNORM";
    case MALI_RG1_SNORM: return "RG1 SNORM";
    case MALI_RG2_SNORM: return "RG2 SNORM";
    case MALI_RG4_SNORM: return "RG4 SNORM";
    case MALI_RG8_SNORM: return "RG8 SNORM";
    case MALI_RG16_SNORM: return "RG16 SNORM";
    case MALI_RG32_SNORM: return "RG32 SNORM";
    case MALI_RG64_SNORM: return "RG64 SNORM";
    case MALI_RGB1_SNORM: return "RGB1 SNORM";
    case MALI_RGB2_SNORM: return "RGB2 SNORM";
    case MALI_RGB4_SNORM: return "RGB4 SNORM";
    case MALI_RGB8_SNORM: return "RGB8 SNORM";
    case MALI_RGB16_SNORM: return "RGB16 SNORM";
    case MALI_RGB32_SNORM: return "RGB32 SNORM";
    case MALI_RGB64_SNORM: return "RGB64 SNORM";
    case MALI_RGBA1_SNORM: return "RGBA1 SNORM";
    case MALI_RGBA2_SNORM: return "RGBA2 SNORM";
    case MALI_RGBA4_SNORM: return "RGBA4 SNORM";
    case MALI_RGBA8_SNORM: return "RGBA8 SNORM";
    case MALI_RGBA16_SNORM: return "RGBA16 SNORM";
    case MALI_RGBA32_SNORM: return "RGBA32 SNORM";
    case MALI_RGBA64_SNORM: return "RGBA64 SNORM";
    case MALI_R1UI: return "R1UI";
    case MALI_R2UI: return "R2UI";
    case MALI_R4UI: return "R4UI";
    case MALI_R8UI: return "R8UI";
    case MALI_R16UI: return "R16UI";
    case MALI_R32UI: return "R32UI";
    case MALI_R64UI: return "R64UI";
    case MALI_R64F: return "R64F";
    case MALI_RG1UI: return "RG1UI";
    case MALI_RG2UI: return "RG2UI";
    case MALI_RG4UI: return "RG4UI";
    case MALI_RG8UI: return "RG8UI";
    case MALI_RG16UI: return "RG16UI";
    case MALI_RG32UI: return "RG32UI";
    case MALI_RG64UI: return "RG64UI";
    case MALI_RG64F: return "RG64F";
    case MALI_RGB1UI: return "RGB1UI";
    case MALI_RGB2UI: return "RGB2UI";
    case MALI_RGB4UI: return "RGB4UI";
    case MALI_RGB8UI: return "RGB8UI";
    case MALI_RGB16UI: return "RGB16UI";
    case MALI_RGB32UI: return "RGB32UI";
    case MALI_RGB64UI: return "RGB64UI";
    case MALI_RGB64F: return "RGB64F";
    case MALI_RGBA1UI: return "RGBA1UI";
    case MALI_RGBA2UI: return "RGBA2UI";
    case MALI_RGBA4UI: return "RGBA4UI";
    case MALI_RGBA8UI: return "RGBA8UI";
    case MALI_RGBA16UI: return "RGBA16UI";
    case MALI_RGBA32UI: return "RGBA32UI";
    case MALI_RGBA64UI: return "RGBA64UI";
    case MALI_RGBA64F: return "RGBA64F";
    case MALI_R1_UNORM: return "R1 UNORM";
    case MALI_R2_UNORM: return "R2 UNORM";
    case MALI_R4_UNORM: return "R4 UNORM";
    case MALI_R8_UNORM: return "R8 UNORM";
    case MALI_R16_UNORM: return "R16 UNORM";
    case MALI_R32_UNORM: return "R32 UNORM";
    case MALI_R64_UNORM: return "R64 UNORM";
    case MALI_R32F: return "R32F";
    case MALI_RG1_UNORM: return "RG1 UNORM";
    case MALI_RG2_UNORM: return "RG2 UNORM";
    case MALI_RG4_UNORM: return "RG4 UNORM";
    case MALI_RG8_UNORM: return "RG8 UNORM";
    case MALI_RG16_UNORM: return "RG16 UNORM";
    case MALI_RG32_UNORM: return "RG32 UNORM";
    case MALI_RG64_UNORM: return "RG64 UNORM";
    case MALI_RG32F: return "RG32F";
    case MALI_RGB1_UNORM: return "RGB1 UNORM";
    case MALI_RGB2_UNORM: return "RGB2 UNORM";
    case MALI_RGB4_UNORM: return "RGB4 UNORM";
    case MALI_RGB8_UNORM: return "RGB8 UNORM";
    case MALI_RGB16_UNORM: return "RGB16 UNORM";
    case MALI_RGB32_UNORM: return "RGB32 UNORM";
    case MALI_RGB64_UNORM: return "RGB64 UNORM";
    case MALI_RGB32F: return "RGB32F";
    case MALI_RGBA1_UNORM: return "RGBA1 UNORM";
    case MALI_RGBA2_UNORM: return "RGBA2 UNORM";
    case MALI_RGBA4_UNORM: return "RGBA4 UNORM";
    case MALI_RGBA8_UNORM: return "RGBA8 UNORM";
    case MALI_RGBA16_UNORM: return "RGBA16 UNORM";
    case MALI_RGBA32_UNORM: return "RGBA32 UNORM";
    case MALI_RGBA64_UNORM: return "RGBA64 UNORM";
    case MALI_RGBA32F: return "RGBA32F";
    case MALI_R1I: return "R1I";
    case MALI_R2I: return "R2I";
    case MALI_R4I: return "R4I";
    case MALI_R8I: return "R8I";
    case MALI_R16I: return "R16I";
    case MALI_R32I: return "R32I";
    case MALI_R64I: return "R64I";
    case MALI_R16F: return "R16F";
    case MALI_RG1I: return "RG1I";
    case MALI_RG2I: return "RG2I";
    case MALI_RG4I: return "RG4I";
    case MALI_RG8I: return "RG8I";
    case MALI_RG16I: return "RG16I";
    case MALI_RG32I: return "RG32I";
    case MALI_RG64I: return "RG64I";
    case MALI_RG16F: return "RG16F";
    case MALI_RGB1I: return "RGB1I";
    case MALI_RGB2I: return "RGB2I";
    case MALI_RGB4I: return "RGB4I";
    case MALI_RGB8I: return "RGB8I";
    case MALI_RGB16I: return "RGB16I";
    case MALI_RGB32I: return "RGB32I";
    case MALI_RGB64I: return "RGB64I";
    case MALI_RGB16F: return "RGB16F";
    case MALI_RGBA1I: return "RGBA1I";
    case MALI_RGBA2I: return "RGBA2I";
    case MALI_RGBA4I: return "RGBA4I";
    case MALI_RGBA8I: return "RGBA8I";
    case MALI_RGBA16I: return "RGBA16I";
    case MALI_RGBA32I: return "RGBA32I";
    case MALI_RGBA64I: return "RGBA64I";
    case MALI_RGBA16F: return "RGBA16F";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_yuv_swizzle {
        MALI_YUV_SWIZZLE_YUVA                =      0,
        MALI_YUV_SWIZZLE_YVUA                =      1,
        MALI_YUV_SWIZZLE_UYVA                =      2,
        MALI_YUV_SWIZZLE_UVYA                =      3,
        MALI_YUV_SWIZZLE_VUYA                =      4,
        MALI_YUV_SWIZZLE_VYUA                =      5,
        MALI_YUV_SWIZZLE_Y00A                =      6,
        MALI_YUV_SWIZZLE_YXXA                =      7,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_yuv_swizzle_as_str(enum mali_yuv_swizzle imm)
{
    switch (imm) {
    case MALI_YUV_SWIZZLE_YUVA: return "YUVA";
    case MALI_YUV_SWIZZLE_YVUA: return "YVUA";
    case MALI_YUV_SWIZZLE_UYVA: return "UYVA";
    case MALI_YUV_SWIZZLE_UVYA: return "UVYA";
    case MALI_YUV_SWIZZLE_VUYA: return "VUYA";
    case MALI_YUV_SWIZZLE_VYUA: return "VYUA";
    case MALI_YUV_SWIZZLE_Y00A: return "Y00A";
    case MALI_YUV_SWIZZLE_YXXA: return "YXXA";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_yuv_conversion_mode {
        MALI_YUV_CONVERSION_MODE_NO_CONVERSION =      0,
        MALI_YUV_CONVERSION_MODE_BT_601      =      3,
        MALI_YUV_CONVERSION_MODE_BT_709      =      4,
        MALI_YUV_CONVERSION_MODE_BT_2020     =      6,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_yuv_conversion_mode_as_str(enum mali_yuv_conversion_mode imm)
{
    switch (imm) {
    case MALI_YUV_CONVERSION_MODE_NO_CONVERSION: return "No Conversion";
    case MALI_YUV_CONVERSION_MODE_BT_601: return "BT 601";
    case MALI_YUV_CONVERSION_MODE_BT_709: return "BT 709";
    case MALI_YUV_CONVERSION_MODE_BT_2020: return "BT 2020";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_yuv_cr_siting {
        MALI_YUV_CR_SITING_CO_SITED          =      0,
        MALI_YUV_CR_SITING_CENTER_Y          =      1,
        MALI_YUV_CR_SITING_CENTER_X          =      2,
        MALI_YUV_CR_SITING_CENTER            =      3,
        MALI_YUV_CR_SITING_ONE_QUARTER       =      4,
        MALI_YUV_CR_SITING_THREE_QUARTERS    =      5,
        MALI_YUV_CR_SITING_REPLICATED        =      7,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_yuv_cr_siting_as_str(enum mali_yuv_cr_siting imm)
{
    switch (imm) {
    case MALI_YUV_CR_SITING_CO_SITED: return "Co-Sited";
    case MALI_YUV_CR_SITING_CENTER_Y: return "Center Y";
    case MALI_YUV_CR_SITING_CENTER_X: return "Center X";
    case MALI_YUV_CR_SITING_CENTER: return "Center";
    case MALI_YUV_CR_SITING_ONE_QUARTER: return "One Quarter";
    case MALI_YUV_CR_SITING_THREE_QUARTERS: return "Three Quarters";
    case MALI_YUV_CR_SITING_REPLICATED: return "Replicated";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_block_format {
        MALI_BLOCK_FORMAT_TILED_U_INTERLEAVED =      0,
        MALI_BLOCK_FORMAT_TILED_LINEAR       =      1,
        MALI_BLOCK_FORMAT_LINEAR             =      2,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_block_format_as_str(enum mali_block_format imm)
{
    switch (imm) {
    case MALI_BLOCK_FORMAT_TILED_U_INTERLEAVED: return "Tiled U-Interleaved";
    case MALI_BLOCK_FORMAT_TILED_LINEAR: return "Tiled Linear";
    case MALI_BLOCK_FORMAT_LINEAR: return "Linear";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_mipmap_mode {
        MALI_MIPMAP_MODE_NEAREST             =      0,
        MALI_MIPMAP_MODE_PERFORMANCE_TRILINEAR =      2,
        MALI_MIPMAP_MODE_TRILINEAR           =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_mipmap_mode_as_str(enum mali_mipmap_mode imm)
{
    switch (imm) {
    case MALI_MIPMAP_MODE_NEAREST: return "Nearest";
    case MALI_MIPMAP_MODE_PERFORMANCE_TRILINEAR: return "Performance Trilinear";
    case MALI_MIPMAP_MODE_TRILINEAR: return "Trilinear";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_msaa {
        MALI_MSAA_SINGLE                     =      0,
        MALI_MSAA_AVERAGE                    =      1,
        MALI_MSAA_MULTIPLE                   =      2,
        MALI_MSAA_LAYERED                    =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_msaa_as_str(enum mali_msaa imm)
{
    switch (imm) {
    case MALI_MSAA_SINGLE: return "Single";
    case MALI_MSAA_AVERAGE: return "Average";
    case MALI_MSAA_MULTIPLE: return "Multiple";
    case MALI_MSAA_LAYERED: return "Layered";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_index_type {
        MALI_INDEX_TYPE_NONE                 =      0,
        MALI_INDEX_TYPE_UINT8                =      1,
        MALI_INDEX_TYPE_UINT16               =      2,
        MALI_INDEX_TYPE_UINT32               =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_index_type_as_str(enum mali_index_type imm)
{
    switch (imm) {
    case MALI_INDEX_TYPE_NONE: return "None";
    case MALI_INDEX_TYPE_UINT8: return "UINT8";
    case MALI_INDEX_TYPE_UINT16: return "UINT16";
    case MALI_INDEX_TYPE_UINT32: return "UINT32";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_occlusion_mode {
        MALI_OCCLUSION_MODE_DISABLED         =      0,
        MALI_OCCLUSION_MODE_PREDICATE        =      1,
        MALI_OCCLUSION_MODE_COUNTER          =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_occlusion_mode_as_str(enum mali_occlusion_mode imm)
{
    switch (imm) {
    case MALI_OCCLUSION_MODE_DISABLED: return "Disabled";
    case MALI_OCCLUSION_MODE_PREDICATE: return "Predicate";
    case MALI_OCCLUSION_MODE_COUNTER: return "Counter";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_stencil_op {
        MALI_STENCIL_OP_KEEP                 =      0,
        MALI_STENCIL_OP_REPLACE              =      1,
        MALI_STENCIL_OP_ZERO                 =      2,
        MALI_STENCIL_OP_INVERT               =      3,
        MALI_STENCIL_OP_INCR_WRAP            =      4,
        MALI_STENCIL_OP_DECR_WRAP            =      5,
        MALI_STENCIL_OP_INCR_SAT             =      6,
        MALI_STENCIL_OP_DECR_SAT             =      7,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_stencil_op_as_str(enum mali_stencil_op imm)
{
    switch (imm) {
    case MALI_STENCIL_OP_KEEP: return "Keep";
    case MALI_STENCIL_OP_REPLACE: return "Replace";
    case MALI_STENCIL_OP_ZERO: return "Zero";
    case MALI_STENCIL_OP_INVERT: return "Invert";
    case MALI_STENCIL_OP_INCR_WRAP: return "Incr Wrap";
    case MALI_STENCIL_OP_DECR_WRAP: return "Decr Wrap";
    case MALI_STENCIL_OP_INCR_SAT: return "Incr Sat";
    case MALI_STENCIL_OP_DECR_SAT: return "Decr Sat";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_texture_dimension {
        MALI_TEXTURE_DIMENSION_CUBE          =      0,
        MALI_TEXTURE_DIMENSION_1D            =      1,
        MALI_TEXTURE_DIMENSION_2D            =      2,
        MALI_TEXTURE_DIMENSION_3D            =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_texture_dimension_as_str(enum mali_texture_dimension imm)
{
    switch (imm) {
    case MALI_TEXTURE_DIMENSION_CUBE: return "Cube";
    case MALI_TEXTURE_DIMENSION_1D: return "1D";
    case MALI_TEXTURE_DIMENSION_2D: return "2D";
    case MALI_TEXTURE_DIMENSION_3D: return "3D";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_texture_layout {
        MALI_TEXTURE_LAYOUT_TILED            =      1,
        MALI_TEXTURE_LAYOUT_LINEAR           =      2,
        MALI_TEXTURE_LAYOUT_AFBC             =     12,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_texture_layout_as_str(enum mali_texture_layout imm)
{
    switch (imm) {
    case MALI_TEXTURE_LAYOUT_TILED: return "Tiled";
    case MALI_TEXTURE_LAYOUT_LINEAR: return "Linear";
    case MALI_TEXTURE_LAYOUT_AFBC: return "AFBC";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_afbc_surface_flag {
        MALI_AFBC_SURFACE_FLAG_YTR           =      1,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_afbc_surface_flag_as_str(enum mali_afbc_surface_flag imm)
{
    switch (imm) {
    case MALI_AFBC_SURFACE_FLAG_YTR: return "YTR";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_wrap_mode {
        MALI_WRAP_MODE_REPEAT                =      8,
        MALI_WRAP_MODE_CLAMP_TO_EDGE         =      9,
        MALI_WRAP_MODE_CLAMP                 =     10,
        MALI_WRAP_MODE_CLAMP_TO_BORDER       =     11,
        MALI_WRAP_MODE_MIRRORED_REPEAT       =     12,
        MALI_WRAP_MODE_MIRRORED_CLAMP_TO_EDGE =     13,
        MALI_WRAP_MODE_MIRRORED_CLAMP        =     14,
        MALI_WRAP_MODE_MIRRORED_CLAMP_TO_BORDER =     15,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_wrap_mode_as_str(enum mali_wrap_mode imm)
{
    switch (imm) {
    case MALI_WRAP_MODE_REPEAT: return "Repeat";
    case MALI_WRAP_MODE_CLAMP_TO_EDGE: return "Clamp to Edge";
    case MALI_WRAP_MODE_CLAMP: return "Clamp";
    case MALI_WRAP_MODE_CLAMP_TO_BORDER: return "Clamp to Border";
    case MALI_WRAP_MODE_MIRRORED_REPEAT: return "Mirrored Repeat";
    case MALI_WRAP_MODE_MIRRORED_CLAMP_TO_EDGE: return "Mirrored Clamp to Edge";
    case MALI_WRAP_MODE_MIRRORED_CLAMP: return "Mirrored Clamp";
    case MALI_WRAP_MODE_MIRRORED_CLAMP_TO_BORDER: return "Mirrored Clamp to Border";
    default: return "XXX: INVALID";
    }
}

#endif

struct MALI_ATTRIBUTE {
   uint32_t                             buffer_index;
   bool                                 offset_enable;
   uint32_t                             format;
   int64_t                              offset;
};

#define MALI_ATTRIBUTE_header                   \
   .offset_enable = true

#define MALI_ATTRIBUTE_LENGTH 8
#define MALI_ATTRIBUTE_ALIGN 8
struct mali_attribute_packed { uint32_t opaque[2]; };
#define MALI_ATTRIBUTE_PACKED_T struct mali_attribute_packed
#define MALI_ATTRIBUTE_pack(__packed, __unpacked) \
do { \
   MALI_ATTRIBUTE_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->buffer_index, 0, 8) | \
            util_bitpack_uint((__unpacked)->offset_enable, 9, 9) | \
            util_bitpack_uint((__unpacked)->format, 10, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_sint((__unpacked)->offset, 0, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_ATTRIBUTE_unpack(__packed, __unpacked) \
do { \
   MALI_ATTRIBUTE_PACKED_T __tmp_packed = *(__packed); \
   __gen_unpack_uint((__unpacked)->buffer_index, &__tmp_packed.opaque[0], 0, 8); \
   __gen_unpack_uint((__unpacked)->offset_enable, &__tmp_packed.opaque[0], 9, 9); \
   __gen_unpack_uint((__unpacked)->format, &__tmp_packed.opaque[0], 10, 31); \
   __gen_unpack_sint((__unpacked)->offset, &__tmp_packed.opaque[0], 32, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_ATTRIBUTE_print(FILE *fp, const struct MALI_ATTRIBUTE * values, unsigned indent)
{
   fprintf(fp, "%*sBuffer index: %u\n", indent, "", values->buffer_index);
   fprintf(fp, "%*sOffset enable: %s\n", indent, "", values->offset_enable ? "true" : "false");
   mali_pixel_format_print(fp, values->format);
   fprintf(fp, "%*sOffset: %" PRId64 "\n", indent, "", (int64_t)values->offset);
}

#endif
struct MALI_ATTRIBUTE_VERTEX_ID {
   enum mali_attribute_special          type;
   uint32_t                             divisor_r;
   uint32_t                             divisor_p;
   int64_t                              offset;
};

#define MALI_ATTRIBUTE_VERTEX_ID_header         \
   .type = MALI_ATTRIBUTE_SPECIAL_VERTEX_ID

#define MALI_ATTRIBUTE_VERTEX_ID_LENGTH 16
#define MALI_ATTRIBUTE_VERTEX_ID_ALIGN 32
struct mali_attribute_vertex_id_packed { uint32_t opaque[4]; };
#define MALI_ATTRIBUTE_VERTEX_ID_PACKED_T struct mali_attribute_vertex_id_packed
#define MALI_ATTRIBUTE_VERTEX_ID_pack(__packed, __unpacked) \
do { \
   MALI_ATTRIBUTE_VERTEX_ID_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->type, 0, 7); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->divisor_r, 24, 28) | \
            util_bitpack_uint((__unpacked)->divisor_p, 29, 31); \
   __tmp_packed.opaque[ 2] = 0; \
   __tmp_packed.opaque[ 3] = util_bitpack_sint((__unpacked)->offset, 0, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_ATTRIBUTE_VERTEX_ID_unpack(__packed, __unpacked) \
do { \
   MALI_ATTRIBUTE_VERTEX_ID_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffffff00) fprintf(stderr, "XXX: Invalid field of Attribute Vertex ID unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xffffff) fprintf(stderr, "XXX: Invalid field of Attribute Vertex ID unpacked at word 1\n"); \
   if (__tmp_packed.opaque[2] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Attribute Vertex ID unpacked at word 2\n"); \
   __gen_unpack_uint((__unpacked)->type, &__tmp_packed.opaque[0], 0, 7); \
   __gen_unpack_uint((__unpacked)->divisor_r, &__tmp_packed.opaque[0], 56, 60); \
   __gen_unpack_uint((__unpacked)->divisor_p, &__tmp_packed.opaque[0], 61, 63); \
   __gen_unpack_sint((__unpacked)->offset, &__tmp_packed.opaque[0], 96, 127); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_ATTRIBUTE_VERTEX_ID_print(FILE *fp, const struct MALI_ATTRIBUTE_VERTEX_ID * values, unsigned indent)
{
   fprintf(fp, "%*sType: %s\n", indent, "", mali_attribute_special_as_str(values->type));
   fprintf(fp, "%*sDivisor R: %u\n", indent, "", values->divisor_r);
   fprintf(fp, "%*sDivisor P: %u\n", indent, "", values->divisor_p);
   fprintf(fp, "%*sOffset: %" PRId64 "\n", indent, "", (int64_t)values->offset);
}

#endif
struct MALI_ATTRIBUTE_INSTANCE_ID {
   enum mali_attribute_special          type;
   uint32_t                             divisor_r;
   uint32_t                             divisor_e;
   uint64_t                             divisor_p;
   int64_t                              offset;
};

#define MALI_ATTRIBUTE_INSTANCE_ID_header       \
   .type = MALI_ATTRIBUTE_SPECIAL_INSTANCE_ID

#define MALI_ATTRIBUTE_INSTANCE_ID_LENGTH 16
#define MALI_ATTRIBUTE_INSTANCE_ID_ALIGN 32
struct mali_attribute_instance_id_packed { uint32_t opaque[4]; };
#define MALI_ATTRIBUTE_INSTANCE_ID_PACKED_T struct mali_attribute_instance_id_packed
#define MALI_ATTRIBUTE_INSTANCE_ID_pack(__packed, __unpacked) \
do { \
   MALI_ATTRIBUTE_INSTANCE_ID_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->type, 0, 7); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->divisor_r, 24, 28) | \
            util_bitpack_uint((__unpacked)->divisor_e, 29, 29); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->divisor_p, 0, 31); \
   __tmp_packed.opaque[ 3] = util_bitpack_sint((__unpacked)->offset, 0, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_ATTRIBUTE_INSTANCE_ID_unpack(__packed, __unpacked) \
do { \
   MALI_ATTRIBUTE_INSTANCE_ID_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffffff00) fprintf(stderr, "XXX: Invalid field of Attribute Instance ID unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xc0ffffff) fprintf(stderr, "XXX: Invalid field of Attribute Instance ID unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->type, &__tmp_packed.opaque[0], 0, 7); \
   __gen_unpack_uint((__unpacked)->divisor_r, &__tmp_packed.opaque[0], 56, 60); \
   __gen_unpack_uint((__unpacked)->divisor_e, &__tmp_packed.opaque[0], 61, 61); \
   __gen_unpack_uint((__unpacked)->divisor_p, &__tmp_packed.opaque[0], 64, 95); \
   __gen_unpack_sint((__unpacked)->offset, &__tmp_packed.opaque[0], 96, 127); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_ATTRIBUTE_INSTANCE_ID_print(FILE *fp, const struct MALI_ATTRIBUTE_INSTANCE_ID * values, unsigned indent)
{
   fprintf(fp, "%*sType: %s\n", indent, "", mali_attribute_special_as_str(values->type));
   fprintf(fp, "%*sDivisor R: %u\n", indent, "", values->divisor_r);
   fprintf(fp, "%*sDivisor E: %u\n", indent, "", values->divisor_e);
   fprintf(fp, "%*sDivisor P: 0x%" PRIx64 "\n", indent, "", values->divisor_p);
   fprintf(fp, "%*sOffset: %" PRId64 "\n", indent, "", (int64_t)values->offset);
}

#endif
struct MALI_ATTRIBUTE_BUFFER {
   enum mali_attribute_special          special;
   enum mali_attribute_type             type;
   uint64_t                             pointer;
   uint64_t                             stride;
   uint64_t                             size;
   uint32_t                             divisor;
   uint32_t                             divisor_r;
   uint32_t                             divisor_p;
   uint32_t                             divisor_e;
};

#define MALI_ATTRIBUTE_BUFFER_header            \
   .type = MALI_ATTRIBUTE_TYPE_1D,  \
   .divisor = 1

#define MALI_ATTRIBUTE_BUFFER_LENGTH 16
#define MALI_ATTRIBUTE_BUFFER_ALIGN 32
struct mali_attribute_buffer_packed { uint32_t opaque[4]; };
#define MALI_ATTRIBUTE_BUFFER_PACKED_T struct mali_attribute_buffer_packed
#define MALI_ATTRIBUTE_BUFFER_pack(__packed, __unpacked) \
do { \
   MALI_ATTRIBUTE_BUFFER_PACKED_T __tmp_packed; \
   assert(((__unpacked)->pointer & 0x3f) == 0); \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->special, 0, 7) | \
            util_bitpack_uint((__unpacked)->type, 0, 5) | \
            util_bitpack_uint((__unpacked)->pointer >> 6, 6, 55); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->pointer >> 6, 6, 55) >> 32 | \
            __gen_padded((__unpacked)->divisor, 24, 31) | \
            util_bitpack_uint((__unpacked)->divisor_r, 24, 28) | \
            util_bitpack_uint((__unpacked)->divisor_p, 29, 31) | \
            util_bitpack_uint((__unpacked)->divisor_e, 29, 29); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->stride, 0, 31); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->size, 0, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_ATTRIBUTE_BUFFER_unpack(__packed, __unpacked) \
do { \
   MALI_ATTRIBUTE_BUFFER_PACKED_T __tmp_packed = *(__packed); \
   __gen_unpack_uint((__unpacked)->special, &__tmp_packed.opaque[0], 0, 7); \
   __gen_unpack_uint((__unpacked)->type, &__tmp_packed.opaque[0], 0, 5); \
   __gen_unpack_uint((__unpacked)->pointer, &__tmp_packed.opaque[0], 6, 55); \
   (__unpacked)->pointer = (__unpacked)->pointer << 6; \
   __gen_unpack_uint((__unpacked)->stride, &__tmp_packed.opaque[0], 64, 95); \
   __gen_unpack_uint((__unpacked)->size, &__tmp_packed.opaque[0], 96, 127); \
   __gen_unpack_padded((__unpacked)->divisor, &__tmp_packed.opaque[0], 56, 63); \
   __gen_unpack_uint((__unpacked)->divisor_r, &__tmp_packed.opaque[0], 56, 60); \
   __gen_unpack_uint((__unpacked)->divisor_p, &__tmp_packed.opaque[0], 61, 63); \
   __gen_unpack_uint((__unpacked)->divisor_e, &__tmp_packed.opaque[0], 61, 61); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_ATTRIBUTE_BUFFER_print(FILE *fp, const struct MALI_ATTRIBUTE_BUFFER * values, unsigned indent)
{
   fprintf(fp, "%*sSpecial: %s\n", indent, "", mali_attribute_special_as_str(values->special));
   fprintf(fp, "%*sType: %s\n", indent, "", mali_attribute_type_as_str(values->type));
   fprintf(fp, "%*sPointer: 0x%" PRIx64 "\n", indent, "", values->pointer);
   fprintf(fp, "%*sStride: 0x%" PRIx64 "\n", indent, "", values->stride);
   fprintf(fp, "%*sSize: 0x%" PRIx64 "\n", indent, "", values->size);
   fprintf(fp, "%*sDivisor: %u\n", indent, "", values->divisor);
   fprintf(fp, "%*sDivisor R: %u\n", indent, "", values->divisor_r);
   fprintf(fp, "%*sDivisor P: %u\n", indent, "", values->divisor_p);
   fprintf(fp, "%*sDivisor E: %u\n", indent, "", values->divisor_e);
}

#endif
struct MALI_ATTRIBUTE_BUFFER_CONTINUATION_NPOT {
   enum mali_attribute_type             type;
   uint64_t                             divisor_numerator;
   uint64_t                             divisor;
};

#define MALI_ATTRIBUTE_BUFFER_CONTINUATION_NPOT_header\
   .type = MALI_ATTRIBUTE_TYPE_CONTINUATION

#define MALI_ATTRIBUTE_BUFFER_CONTINUATION_NPOT_LENGTH 16
struct mali_attribute_buffer_continuation_npot_packed { uint32_t opaque[4]; };
#define MALI_ATTRIBUTE_BUFFER_CONTINUATION_NPOT_PACKED_T struct mali_attribute_buffer_continuation_npot_packed
#define MALI_ATTRIBUTE_BUFFER_CONTINUATION_NPOT_pack(__packed, __unpacked) \
do { \
   MALI_ATTRIBUTE_BUFFER_CONTINUATION_NPOT_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->type, 0, 5); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->divisor_numerator, 0, 31); \
   __tmp_packed.opaque[ 2] = 0; \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->divisor, 0, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_ATTRIBUTE_BUFFER_CONTINUATION_NPOT_unpack(__packed, __unpacked) \
do { \
   MALI_ATTRIBUTE_BUFFER_CONTINUATION_NPOT_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffffffc0) fprintf(stderr, "XXX: Invalid field of Attribute Buffer Continuation NPOT unpacked at word 0\n"); \
   if (__tmp_packed.opaque[2] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Attribute Buffer Continuation NPOT unpacked at word 2\n"); \
   __gen_unpack_uint((__unpacked)->type, &__tmp_packed.opaque[0], 0, 5); \
   __gen_unpack_uint((__unpacked)->divisor_numerator, &__tmp_packed.opaque[0], 32, 63); \
   __gen_unpack_uint((__unpacked)->divisor, &__tmp_packed.opaque[0], 96, 127); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_ATTRIBUTE_BUFFER_CONTINUATION_NPOT_print(FILE *fp, const struct MALI_ATTRIBUTE_BUFFER_CONTINUATION_NPOT * values, unsigned indent)
{
   fprintf(fp, "%*sType: %s\n", indent, "", mali_attribute_type_as_str(values->type));
   fprintf(fp, "%*sDivisor Numerator: 0x%" PRIx64 "\n", indent, "", values->divisor_numerator);
   fprintf(fp, "%*sDivisor: 0x%" PRIx64 "\n", indent, "", values->divisor);
}

#endif
struct MALI_ATTRIBUTE_BUFFER_CONTINUATION_3D {
   enum mali_attribute_type             type;
   uint32_t                             s_dimension;
   uint32_t                             t_dimension;
   uint32_t                             r_dimension;
   uint64_t                             row_stride;
   uint64_t                             slice_stride;
};

#define MALI_ATTRIBUTE_BUFFER_CONTINUATION_3D_header\
   .type = MALI_ATTRIBUTE_TYPE_CONTINUATION

#define MALI_ATTRIBUTE_BUFFER_CONTINUATION_3D_LENGTH 16
struct mali_attribute_buffer_continuation_3d_packed { uint32_t opaque[4]; };
#define MALI_ATTRIBUTE_BUFFER_CONTINUATION_3D_PACKED_T struct mali_attribute_buffer_continuation_3d_packed
#define MALI_ATTRIBUTE_BUFFER_CONTINUATION_3D_pack(__packed, __unpacked) \
do { \
   MALI_ATTRIBUTE_BUFFER_CONTINUATION_3D_PACKED_T __tmp_packed; \
   assert((__unpacked)->s_dimension >= 1); \
   assert((__unpacked)->t_dimension >= 1); \
   assert((__unpacked)->r_dimension >= 1); \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->type, 0, 5) | \
            util_bitpack_uint((__unpacked)->s_dimension - 1, 16, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->t_dimension - 1, 0, 15) | \
            util_bitpack_uint((__unpacked)->r_dimension - 1, 16, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->row_stride, 0, 31); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->slice_stride, 0, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_ATTRIBUTE_BUFFER_CONTINUATION_3D_unpack(__packed, __unpacked) \
do { \
   MALI_ATTRIBUTE_BUFFER_CONTINUATION_3D_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffc0) fprintf(stderr, "XXX: Invalid field of Attribute Buffer Continuation 3D unpacked at word 0\n"); \
   __gen_unpack_uint((__unpacked)->type, &__tmp_packed.opaque[0], 0, 5); \
   __gen_unpack_uint((__unpacked)->s_dimension, &__tmp_packed.opaque[0], 16, 31); \
   (__unpacked)->s_dimension = (__unpacked)->s_dimension + 1; \
   __gen_unpack_uint((__unpacked)->t_dimension, &__tmp_packed.opaque[0], 32, 47); \
   (__unpacked)->t_dimension = (__unpacked)->t_dimension + 1; \
   __gen_unpack_uint((__unpacked)->r_dimension, &__tmp_packed.opaque[0], 48, 63); \
   (__unpacked)->r_dimension = (__unpacked)->r_dimension + 1; \
   __gen_unpack_uint((__unpacked)->row_stride, &__tmp_packed.opaque[0], 64, 95); \
   __gen_unpack_uint((__unpacked)->slice_stride, &__tmp_packed.opaque[0], 96, 127); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_ATTRIBUTE_BUFFER_CONTINUATION_3D_print(FILE *fp, const struct MALI_ATTRIBUTE_BUFFER_CONTINUATION_3D * values, unsigned indent)
{
   fprintf(fp, "%*sType: %s\n", indent, "", mali_attribute_type_as_str(values->type));
   fprintf(fp, "%*sS dimension: %u\n", indent, "", values->s_dimension);
   fprintf(fp, "%*sT dimension: %u\n", indent, "", values->t_dimension);
   fprintf(fp, "%*sR dimension: %u\n", indent, "", values->r_dimension);
   fprintf(fp, "%*sRow Stride: 0x%" PRIx64 "\n", indent, "", values->row_stride);
   fprintf(fp, "%*sSlice Stride: 0x%" PRIx64 "\n", indent, "", values->slice_stride);
}

#endif
enum mali_blend_operand_a {
        MALI_BLEND_OPERAND_A_ZERO            =      1,
        MALI_BLEND_OPERAND_A_SRC             =      2,
        MALI_BLEND_OPERAND_A_DEST            =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_blend_operand_a_as_str(enum mali_blend_operand_a imm)
{
    switch (imm) {
    case MALI_BLEND_OPERAND_A_ZERO: return "Zero";
    case MALI_BLEND_OPERAND_A_SRC: return "Src";
    case MALI_BLEND_OPERAND_A_DEST: return "Dest";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_blend_operand_b {
        MALI_BLEND_OPERAND_B_SRC_MINUS_DEST  =      0,
        MALI_BLEND_OPERAND_B_SRC_PLUS_DEST   =      1,
        MALI_BLEND_OPERAND_B_SRC             =      2,
        MALI_BLEND_OPERAND_B_DEST            =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_blend_operand_b_as_str(enum mali_blend_operand_b imm)
{
    switch (imm) {
    case MALI_BLEND_OPERAND_B_SRC_MINUS_DEST: return "Src Minus Dest";
    case MALI_BLEND_OPERAND_B_SRC_PLUS_DEST: return "Src Plus Dest";
    case MALI_BLEND_OPERAND_B_SRC: return "Src";
    case MALI_BLEND_OPERAND_B_DEST: return "Dest";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_blend_operand_c {
        MALI_BLEND_OPERAND_C_ZERO            =      1,
        MALI_BLEND_OPERAND_C_SRC             =      2,
        MALI_BLEND_OPERAND_C_DEST            =      3,
        MALI_BLEND_OPERAND_C_SRC_X_2         =      4,
        MALI_BLEND_OPERAND_C_SRC_ALPHA       =      5,
        MALI_BLEND_OPERAND_C_DEST_ALPHA      =      6,
        MALI_BLEND_OPERAND_C_CONSTANT        =      7,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_blend_operand_c_as_str(enum mali_blend_operand_c imm)
{
    switch (imm) {
    case MALI_BLEND_OPERAND_C_ZERO: return "Zero";
    case MALI_BLEND_OPERAND_C_SRC: return "Src";
    case MALI_BLEND_OPERAND_C_DEST: return "Dest";
    case MALI_BLEND_OPERAND_C_SRC_X_2: return "Src x 2";
    case MALI_BLEND_OPERAND_C_SRC_ALPHA: return "Src Alpha";
    case MALI_BLEND_OPERAND_C_DEST_ALPHA: return "Dest Alpha";
    case MALI_BLEND_OPERAND_C_CONSTANT: return "Constant";
    default: return "XXX: INVALID";
    }
}

#endif

struct MALI_BLEND_FUNCTION {
   enum mali_blend_operand_a            a;
   bool                                 negate_a;
   enum mali_blend_operand_b            b;
   bool                                 negate_b;
   enum mali_blend_operand_c            c;
   bool                                 invert_c;
};

#define MALI_BLEND_FUNCTION_header              \
   0

#ifndef __OPENCL_VERSION__
static inline void
MALI_BLEND_FUNCTION_print(FILE *fp, const struct MALI_BLEND_FUNCTION * values, unsigned indent)
{
   fprintf(fp, "%*sA: %s\n", indent, "", mali_blend_operand_a_as_str(values->a));
   fprintf(fp, "%*sNegate A: %s\n", indent, "", values->negate_a ? "true" : "false");
   fprintf(fp, "%*sB: %s\n", indent, "", mali_blend_operand_b_as_str(values->b));
   fprintf(fp, "%*sNegate B: %s\n", indent, "", values->negate_b ? "true" : "false");
   fprintf(fp, "%*sC: %s\n", indent, "", mali_blend_operand_c_as_str(values->c));
   fprintf(fp, "%*sInvert C: %s\n", indent, "", values->invert_c ? "true" : "false");
}

#endif
struct MALI_BLEND_EQUATION {
   struct MALI_BLEND_FUNCTION           rgb;
   struct MALI_BLEND_FUNCTION           alpha;
   uint32_t                             color_mask;
};

#define MALI_BLEND_EQUATION_header              \
   .rgb = { MALI_BLEND_FUNCTION_header },  \
   .alpha = { MALI_BLEND_FUNCTION_header }

#define MALI_BLEND_EQUATION_LENGTH 4
struct mali_blend_equation_packed { uint32_t opaque[1]; };
#define MALI_BLEND_EQUATION_PACKED_T struct mali_blend_equation_packed
#define MALI_BLEND_EQUATION_pack(__packed, __unpacked) \
do { \
   MALI_BLEND_EQUATION_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->rgb.a, 0, 1) | \
            util_bitpack_uint((__unpacked)->rgb.negate_a, 3, 3) | \
            util_bitpack_uint((__unpacked)->rgb.b, 4, 5) | \
            util_bitpack_uint((__unpacked)->rgb.negate_b, 7, 7) | \
            util_bitpack_uint((__unpacked)->rgb.c, 8, 10) | \
            util_bitpack_uint((__unpacked)->rgb.invert_c, 11, 11) | \
            util_bitpack_uint((__unpacked)->alpha.a, 12, 13) | \
            util_bitpack_uint((__unpacked)->alpha.negate_a, 15, 15) | \
            util_bitpack_uint((__unpacked)->alpha.b, 16, 17) | \
            util_bitpack_uint((__unpacked)->alpha.negate_b, 19, 19) | \
            util_bitpack_uint((__unpacked)->alpha.c, 20, 22) | \
            util_bitpack_uint((__unpacked)->alpha.invert_c, 23, 23) | \
            util_bitpack_uint((__unpacked)->color_mask, 28, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_BLEND_EQUATION_unpack(__packed, __unpacked) \
do { \
   MALI_BLEND_EQUATION_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xf044044) fprintf(stderr, "XXX: Invalid field of Blend Equation unpacked at word 0\n"); \
   __gen_unpack_uint((__unpacked)->rgb.a, &__tmp_packed.opaque[0], 0, 1); \
   __gen_unpack_uint((__unpacked)->rgb.negate_a, &__tmp_packed.opaque[0], 3, 3); \
   __gen_unpack_uint((__unpacked)->rgb.b, &__tmp_packed.opaque[0], 4, 5); \
   __gen_unpack_uint((__unpacked)->rgb.negate_b, &__tmp_packed.opaque[0], 7, 7); \
   __gen_unpack_uint((__unpacked)->rgb.c, &__tmp_packed.opaque[0], 8, 10); \
   __gen_unpack_uint((__unpacked)->rgb.invert_c, &__tmp_packed.opaque[0], 11, 11); \
   __gen_unpack_uint((__unpacked)->alpha.a, &__tmp_packed.opaque[0], 12, 13); \
   __gen_unpack_uint((__unpacked)->alpha.negate_a, &__tmp_packed.opaque[0], 15, 15); \
   __gen_unpack_uint((__unpacked)->alpha.b, &__tmp_packed.opaque[0], 16, 17); \
   __gen_unpack_uint((__unpacked)->alpha.negate_b, &__tmp_packed.opaque[0], 19, 19); \
   __gen_unpack_uint((__unpacked)->alpha.c, &__tmp_packed.opaque[0], 20, 22); \
   __gen_unpack_uint((__unpacked)->alpha.invert_c, &__tmp_packed.opaque[0], 23, 23); \
   __gen_unpack_uint((__unpacked)->color_mask, &__tmp_packed.opaque[0], 28, 31); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_BLEND_EQUATION_print(FILE *fp, const struct MALI_BLEND_EQUATION * values, unsigned indent)
{
   fprintf(fp, "%*sRGB:\n", indent, "");
   MALI_BLEND_FUNCTION_print(fp, &values->rgb, indent + 2);
   fprintf(fp, "%*sAlpha:\n", indent, "");
   MALI_BLEND_FUNCTION_print(fp, &values->alpha, indent + 2);
   fprintf(fp, "%*sColor Mask: %u\n", indent, "", values->color_mask);
}

#endif
struct MALI_INVOCATION {
   uint64_t                             invocations;
   uint32_t                             size_y_shift;
   uint32_t                             size_z_shift;
   uint32_t                             workgroups_x_shift;
   uint32_t                             workgroups_y_shift;
   uint32_t                             workgroups_z_shift;
   uint32_t                             thread_group_split;
#define MALI_SPLIT_MIN_EFFICIENT                 2
};

#define MALI_INVOCATION_header                  \
   0

#define MALI_INVOCATION_LENGTH 8
struct mali_invocation_packed { uint32_t opaque[2]; };
#define MALI_INVOCATION_PACKED_T struct mali_invocation_packed
#define MALI_INVOCATION_pack(__packed, __unpacked) \
do { \
   MALI_INVOCATION_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->invocations, 0, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->size_y_shift, 0, 4) | \
            util_bitpack_uint((__unpacked)->size_z_shift, 5, 9) | \
            util_bitpack_uint((__unpacked)->workgroups_x_shift, 10, 15) | \
            util_bitpack_uint((__unpacked)->workgroups_y_shift, 16, 21) | \
            util_bitpack_uint((__unpacked)->workgroups_z_shift, 22, 27) | \
            util_bitpack_uint((__unpacked)->thread_group_split, 28, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_INVOCATION_unpack(__packed, __unpacked) \
do { \
   MALI_INVOCATION_PACKED_T __tmp_packed = *(__packed); \
   __gen_unpack_uint((__unpacked)->invocations, &__tmp_packed.opaque[0], 0, 31); \
   __gen_unpack_uint((__unpacked)->size_y_shift, &__tmp_packed.opaque[0], 32, 36); \
   __gen_unpack_uint((__unpacked)->size_z_shift, &__tmp_packed.opaque[0], 37, 41); \
   __gen_unpack_uint((__unpacked)->workgroups_x_shift, &__tmp_packed.opaque[0], 42, 47); \
   __gen_unpack_uint((__unpacked)->workgroups_y_shift, &__tmp_packed.opaque[0], 48, 53); \
   __gen_unpack_uint((__unpacked)->workgroups_z_shift, &__tmp_packed.opaque[0], 54, 59); \
   __gen_unpack_uint((__unpacked)->thread_group_split, &__tmp_packed.opaque[0], 60, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_INVOCATION_print(FILE *fp, const struct MALI_INVOCATION * values, unsigned indent)
{
   fprintf(fp, "%*sInvocations: 0x%" PRIx64 "\n", indent, "", values->invocations);
   fprintf(fp, "%*sSize Y shift: %u\n", indent, "", values->size_y_shift);
   fprintf(fp, "%*sSize Z shift: %u\n", indent, "", values->size_z_shift);
   fprintf(fp, "%*sWorkgroups X shift: %u\n", indent, "", values->workgroups_x_shift);
   fprintf(fp, "%*sWorkgroups Y shift: %u\n", indent, "", values->workgroups_y_shift);
   fprintf(fp, "%*sWorkgroups Z shift: %u\n", indent, "", values->workgroups_z_shift);
   fprintf(fp, "%*sThread group split: %u\n", indent, "", values->thread_group_split);
}

#endif
enum mali_point_size_array_format {
        MALI_POINT_SIZE_ARRAY_FORMAT_NONE    =      0,
        MALI_POINT_SIZE_ARRAY_FORMAT_FP16    =      2,
        MALI_POINT_SIZE_ARRAY_FORMAT_FP32    =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_point_size_array_format_as_str(enum mali_point_size_array_format imm)
{
    switch (imm) {
    case MALI_POINT_SIZE_ARRAY_FORMAT_NONE: return "None";
    case MALI_POINT_SIZE_ARRAY_FORMAT_FP16: return "FP16";
    case MALI_POINT_SIZE_ARRAY_FORMAT_FP32: return "FP32";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_primitive_restart {
        MALI_PRIMITIVE_RESTART_NONE          =      0,
        MALI_PRIMITIVE_RESTART_IMPLICIT      =      2,
        MALI_PRIMITIVE_RESTART_EXPLICIT      =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_primitive_restart_as_str(enum mali_primitive_restart imm)
{
    switch (imm) {
    case MALI_PRIMITIVE_RESTART_NONE: return "None";
    case MALI_PRIMITIVE_RESTART_IMPLICIT: return "Implicit";
    case MALI_PRIMITIVE_RESTART_EXPLICIT: return "Explicit";
    default: return "XXX: INVALID";
    }
}

#endif

struct MALI_PRIMITIVE {
   enum mali_draw_mode                  draw_mode;
   enum mali_index_type                 index_type;
   enum mali_point_size_array_format    point_size_array_format;
   bool                                 primitive_index_enable;
   bool                                 primitive_index_writeback;
   bool                                 first_provoking_vertex;
   bool                                 low_depth_cull;
   bool                                 high_depth_cull;
   enum mali_primitive_restart          primitive_restart;
   uint32_t                             job_task_split;
   int64_t                              base_vertex_offset;
   uint64_t                             primitive_restart_index;
   uint64_t                             index_count;
   uint64_t                             indices;
};

#define MALI_PRIMITIVE_header                   \
   .index_type = MALI_INDEX_TYPE_NONE,  \
   .first_provoking_vertex = true,  \
   .low_depth_cull = true,  \
   .high_depth_cull = true

#define MALI_PRIMITIVE_LENGTH 24
struct mali_primitive_packed { uint32_t opaque[6]; };
#define MALI_PRIMITIVE_PACKED_T struct mali_primitive_packed
#define MALI_PRIMITIVE_pack(__packed, __unpacked) \
do { \
   MALI_PRIMITIVE_PACKED_T __tmp_packed; \
   assert((__unpacked)->index_count >= 1); \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->draw_mode, 0, 7) | \
            util_bitpack_uint((__unpacked)->index_type, 8, 10) | \
            util_bitpack_uint((__unpacked)->point_size_array_format, 11, 12) | \
            util_bitpack_uint((__unpacked)->primitive_index_enable, 13, 13) | \
            util_bitpack_uint((__unpacked)->primitive_index_writeback, 14, 14) | \
            util_bitpack_uint((__unpacked)->first_provoking_vertex, 15, 15) | \
            util_bitpack_uint((__unpacked)->low_depth_cull, 16, 16) | \
            util_bitpack_uint((__unpacked)->high_depth_cull, 17, 17) | \
            util_bitpack_uint((__unpacked)->primitive_restart, 19, 20) | \
            util_bitpack_uint((__unpacked)->job_task_split, 26, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_sint((__unpacked)->base_vertex_offset, 0, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->primitive_restart_index, 0, 31); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->index_count - 1, 0, 31); \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->indices, 0, 63); \
   __tmp_packed.opaque[ 5] = util_bitpack_uint((__unpacked)->indices, 0, 63) >> 32; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_PRIMITIVE_unpack(__packed, __unpacked) \
do { \
   MALI_PRIMITIVE_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0x3e40000) fprintf(stderr, "XXX: Invalid field of Primitive unpacked at word 0\n"); \
   __gen_unpack_uint((__unpacked)->draw_mode, &__tmp_packed.opaque[0], 0, 7); \
   __gen_unpack_uint((__unpacked)->index_type, &__tmp_packed.opaque[0], 8, 10); \
   __gen_unpack_uint((__unpacked)->point_size_array_format, &__tmp_packed.opaque[0], 11, 12); \
   __gen_unpack_uint((__unpacked)->primitive_index_enable, &__tmp_packed.opaque[0], 13, 13); \
   __gen_unpack_uint((__unpacked)->primitive_index_writeback, &__tmp_packed.opaque[0], 14, 14); \
   __gen_unpack_uint((__unpacked)->first_provoking_vertex, &__tmp_packed.opaque[0], 15, 15); \
   __gen_unpack_uint((__unpacked)->low_depth_cull, &__tmp_packed.opaque[0], 16, 16); \
   __gen_unpack_uint((__unpacked)->high_depth_cull, &__tmp_packed.opaque[0], 17, 17); \
   __gen_unpack_uint((__unpacked)->primitive_restart, &__tmp_packed.opaque[0], 19, 20); \
   __gen_unpack_uint((__unpacked)->job_task_split, &__tmp_packed.opaque[0], 26, 31); \
   __gen_unpack_sint((__unpacked)->base_vertex_offset, &__tmp_packed.opaque[0], 32, 63); \
   __gen_unpack_uint((__unpacked)->primitive_restart_index, &__tmp_packed.opaque[0], 64, 95); \
   __gen_unpack_uint((__unpacked)->index_count, &__tmp_packed.opaque[0], 96, 127); \
   (__unpacked)->index_count = (__unpacked)->index_count + 1; \
   __gen_unpack_uint((__unpacked)->indices, &__tmp_packed.opaque[0], 128, 191); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_PRIMITIVE_print(FILE *fp, const struct MALI_PRIMITIVE * values, unsigned indent)
{
   fprintf(fp, "%*sDraw mode: %s\n", indent, "", mali_draw_mode_as_str(values->draw_mode));
   fprintf(fp, "%*sIndex type: %s\n", indent, "", mali_index_type_as_str(values->index_type));
   fprintf(fp, "%*sPoint size array format: %s\n", indent, "", mali_point_size_array_format_as_str(values->point_size_array_format));
   fprintf(fp, "%*sPrimitive Index Enable: %s\n", indent, "", values->primitive_index_enable ? "true" : "false");
   fprintf(fp, "%*sPrimitive Index Writeback: %s\n", indent, "", values->primitive_index_writeback ? "true" : "false");
   fprintf(fp, "%*sFirst provoking vertex: %s\n", indent, "", values->first_provoking_vertex ? "true" : "false");
   fprintf(fp, "%*sLow Depth Cull: %s\n", indent, "", values->low_depth_cull ? "true" : "false");
   fprintf(fp, "%*sHigh Depth Cull: %s\n", indent, "", values->high_depth_cull ? "true" : "false");
   fprintf(fp, "%*sPrimitive restart: %s\n", indent, "", mali_primitive_restart_as_str(values->primitive_restart));
   fprintf(fp, "%*sJob Task Split: %u\n", indent, "", values->job_task_split);
   fprintf(fp, "%*sBase vertex offset: %" PRId64 "\n", indent, "", (int64_t)values->base_vertex_offset);
   fprintf(fp, "%*sPrimitive Restart Index: 0x%" PRIx64 "\n", indent, "", values->primitive_restart_index);
   fprintf(fp, "%*sIndex count: 0x%" PRIx64 "\n", indent, "", values->index_count);
   fprintf(fp, "%*sIndices: 0x%" PRIx64 "\n", indent, "", values->indices);
}

#endif
struct MALI_DRAW {
   bool                                 four_components_per_vertex;
   bool                                 draw_descriptor_is_64b;
   bool                                 texture_descriptor_is_64b;
   enum mali_occlusion_mode             occlusion_query;
   bool                                 front_face_ccw;
   bool                                 cull_front_face;
   bool                                 cull_back_face;
   uint32_t                             flat_shading_vertex;
   bool                                 primitive_barrier;
   bool                                 clean_fragment_write;
   uint32_t                             instance_size;
   uint32_t                             instance_primitive_size;
   int64_t                              offset_start;
   int64_t                              primitive_index_base;
   uint64_t                             position;
   uint64_t                             uniform_buffers;
   uint64_t                             textures;
   uint64_t                             samplers;
   uint64_t                             push_uniforms;
   uint64_t                             state;
   uint64_t                             attribute_buffers;
   uint64_t                             attributes;
   uint64_t                             varying_buffers;
   uint64_t                             varyings;
   uint64_t                             viewport;
   uint64_t                             occlusion;
   uint64_t                             thread_storage;
   uint64_t                             fbd;
};

#define MALI_DRAW_header                        \
   .four_components_per_vertex = true,  \
   .draw_descriptor_is_64b = true,  \
   .texture_descriptor_is_64b = true,  \
   .occlusion_query = MALI_OCCLUSION_MODE_DISABLED,  \
   .instance_size = 1,  \
   .instance_primitive_size = 1

#define MALI_DRAW_LENGTH 120
#define MALI_DRAW_ALIGN 64
struct mali_draw_packed { uint32_t opaque[30]; };
#define MALI_DRAW_PACKED_T struct mali_draw_packed
#define MALI_DRAW_pack(__packed, __unpacked) \
do { \
   MALI_DRAW_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->four_components_per_vertex, 0, 0) | \
            util_bitpack_uint((__unpacked)->draw_descriptor_is_64b, 1, 1) | \
            util_bitpack_uint((__unpacked)->texture_descriptor_is_64b, 2, 2) | \
            util_bitpack_uint((__unpacked)->occlusion_query, 3, 4) | \
            util_bitpack_uint((__unpacked)->front_face_ccw, 5, 5) | \
            util_bitpack_uint((__unpacked)->cull_front_face, 6, 6) | \
            util_bitpack_uint((__unpacked)->cull_back_face, 7, 7) | \
            util_bitpack_uint((__unpacked)->flat_shading_vertex, 8, 8) | \
            util_bitpack_uint((__unpacked)->primitive_barrier, 10, 10) | \
            util_bitpack_uint((__unpacked)->clean_fragment_write, 11, 11) | \
            __gen_padded((__unpacked)->instance_size, 16, 23) | \
            __gen_padded((__unpacked)->instance_primitive_size, 24, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_sint((__unpacked)->offset_start, 0, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_sint((__unpacked)->primitive_index_base, 0, 31); \
   __tmp_packed.opaque[ 3] = 0; \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->position, 0, 63); \
   __tmp_packed.opaque[ 5] = util_bitpack_uint((__unpacked)->position, 0, 63) >> 32; \
   __tmp_packed.opaque[ 6] = util_bitpack_uint((__unpacked)->uniform_buffers, 0, 63); \
   __tmp_packed.opaque[ 7] = util_bitpack_uint((__unpacked)->uniform_buffers, 0, 63) >> 32; \
   __tmp_packed.opaque[ 8] = util_bitpack_uint((__unpacked)->textures, 0, 63); \
   __tmp_packed.opaque[ 9] = util_bitpack_uint((__unpacked)->textures, 0, 63) >> 32; \
   __tmp_packed.opaque[10] = util_bitpack_uint((__unpacked)->samplers, 0, 63); \
   __tmp_packed.opaque[11] = util_bitpack_uint((__unpacked)->samplers, 0, 63) >> 32; \
   __tmp_packed.opaque[12] = util_bitpack_uint((__unpacked)->push_uniforms, 0, 63); \
   __tmp_packed.opaque[13] = util_bitpack_uint((__unpacked)->push_uniforms, 0, 63) >> 32; \
   __tmp_packed.opaque[14] = util_bitpack_uint((__unpacked)->state, 0, 63); \
   __tmp_packed.opaque[15] = util_bitpack_uint((__unpacked)->state, 0, 63) >> 32; \
   __tmp_packed.opaque[16] = util_bitpack_uint((__unpacked)->attribute_buffers, 0, 63); \
   __tmp_packed.opaque[17] = util_bitpack_uint((__unpacked)->attribute_buffers, 0, 63) >> 32; \
   __tmp_packed.opaque[18] = util_bitpack_uint((__unpacked)->attributes, 0, 63); \
   __tmp_packed.opaque[19] = util_bitpack_uint((__unpacked)->attributes, 0, 63) >> 32; \
   __tmp_packed.opaque[20] = util_bitpack_uint((__unpacked)->varying_buffers, 0, 63); \
   __tmp_packed.opaque[21] = util_bitpack_uint((__unpacked)->varying_buffers, 0, 63) >> 32; \
   __tmp_packed.opaque[22] = util_bitpack_uint((__unpacked)->varyings, 0, 63); \
   __tmp_packed.opaque[23] = util_bitpack_uint((__unpacked)->varyings, 0, 63) >> 32; \
   __tmp_packed.opaque[24] = util_bitpack_uint((__unpacked)->viewport, 0, 63); \
   __tmp_packed.opaque[25] = util_bitpack_uint((__unpacked)->viewport, 0, 63) >> 32; \
   __tmp_packed.opaque[26] = util_bitpack_uint((__unpacked)->occlusion, 0, 63); \
   __tmp_packed.opaque[27] = util_bitpack_uint((__unpacked)->occlusion, 0, 63) >> 32; \
   __tmp_packed.opaque[28] = util_bitpack_uint((__unpacked)->thread_storage, 0, 63) | \
            util_bitpack_uint((__unpacked)->fbd, 0, 63); \
   __tmp_packed.opaque[29] = util_bitpack_uint((__unpacked)->thread_storage, 0, 63) >> 32 | \
            util_bitpack_uint((__unpacked)->fbd, 0, 63) >> 32; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_DRAW_unpack(__packed, __unpacked) \
do { \
   MALI_DRAW_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xf200) fprintf(stderr, "XXX: Invalid field of Draw unpacked at word 0\n"); \
   if (__tmp_packed.opaque[3] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Draw unpacked at word 3\n"); \
   __gen_unpack_uint((__unpacked)->four_components_per_vertex, &__tmp_packed.opaque[0], 0, 0); \
   __gen_unpack_uint((__unpacked)->draw_descriptor_is_64b, &__tmp_packed.opaque[0], 1, 1); \
   __gen_unpack_uint((__unpacked)->texture_descriptor_is_64b, &__tmp_packed.opaque[0], 2, 2); \
   __gen_unpack_uint((__unpacked)->occlusion_query, &__tmp_packed.opaque[0], 3, 4); \
   __gen_unpack_uint((__unpacked)->front_face_ccw, &__tmp_packed.opaque[0], 5, 5); \
   __gen_unpack_uint((__unpacked)->cull_front_face, &__tmp_packed.opaque[0], 6, 6); \
   __gen_unpack_uint((__unpacked)->cull_back_face, &__tmp_packed.opaque[0], 7, 7); \
   __gen_unpack_uint((__unpacked)->flat_shading_vertex, &__tmp_packed.opaque[0], 8, 8); \
   __gen_unpack_uint((__unpacked)->primitive_barrier, &__tmp_packed.opaque[0], 10, 10); \
   __gen_unpack_uint((__unpacked)->clean_fragment_write, &__tmp_packed.opaque[0], 11, 11); \
   __gen_unpack_padded((__unpacked)->instance_size, &__tmp_packed.opaque[0], 16, 23); \
   __gen_unpack_padded((__unpacked)->instance_primitive_size, &__tmp_packed.opaque[0], 24, 31); \
   __gen_unpack_sint((__unpacked)->offset_start, &__tmp_packed.opaque[0], 32, 63); \
   __gen_unpack_sint((__unpacked)->primitive_index_base, &__tmp_packed.opaque[0], 64, 95); \
   __gen_unpack_uint((__unpacked)->position, &__tmp_packed.opaque[0], 128, 191); \
   __gen_unpack_uint((__unpacked)->uniform_buffers, &__tmp_packed.opaque[0], 192, 255); \
   __gen_unpack_uint((__unpacked)->textures, &__tmp_packed.opaque[0], 256, 319); \
   __gen_unpack_uint((__unpacked)->samplers, &__tmp_packed.opaque[0], 320, 383); \
   __gen_unpack_uint((__unpacked)->push_uniforms, &__tmp_packed.opaque[0], 384, 447); \
   __gen_unpack_uint((__unpacked)->state, &__tmp_packed.opaque[0], 448, 511); \
   __gen_unpack_uint((__unpacked)->attribute_buffers, &__tmp_packed.opaque[0], 512, 575); \
   __gen_unpack_uint((__unpacked)->attributes, &__tmp_packed.opaque[0], 576, 639); \
   __gen_unpack_uint((__unpacked)->varying_buffers, &__tmp_packed.opaque[0], 640, 703); \
   __gen_unpack_uint((__unpacked)->varyings, &__tmp_packed.opaque[0], 704, 767); \
   __gen_unpack_uint((__unpacked)->viewport, &__tmp_packed.opaque[0], 768, 831); \
   __gen_unpack_uint((__unpacked)->occlusion, &__tmp_packed.opaque[0], 832, 895); \
   __gen_unpack_uint((__unpacked)->thread_storage, &__tmp_packed.opaque[0], 896, 959); \
   __gen_unpack_uint((__unpacked)->fbd, &__tmp_packed.opaque[0], 896, 959); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_DRAW_print(FILE *fp, const struct MALI_DRAW * values, unsigned indent)
{
   fprintf(fp, "%*sFour Components Per Vertex: %s\n", indent, "", values->four_components_per_vertex ? "true" : "false");
   fprintf(fp, "%*sDraw Descriptor Is 64b: %s\n", indent, "", values->draw_descriptor_is_64b ? "true" : "false");
   fprintf(fp, "%*sTexture Descriptor Is 64b: %s\n", indent, "", values->texture_descriptor_is_64b ? "true" : "false");
   fprintf(fp, "%*sOcclusion query: %s\n", indent, "", mali_occlusion_mode_as_str(values->occlusion_query));
   fprintf(fp, "%*sFront face CCW: %s\n", indent, "", values->front_face_ccw ? "true" : "false");
   fprintf(fp, "%*sCull front face: %s\n", indent, "", values->cull_front_face ? "true" : "false");
   fprintf(fp, "%*sCull back face: %s\n", indent, "", values->cull_back_face ? "true" : "false");
   fprintf(fp, "%*sFlat Shading Vertex: %u\n", indent, "", values->flat_shading_vertex);
   fprintf(fp, "%*sPrimitive Barrier: %s\n", indent, "", values->primitive_barrier ? "true" : "false");
   fprintf(fp, "%*sClean Fragment Write: %s\n", indent, "", values->clean_fragment_write ? "true" : "false");
   fprintf(fp, "%*sInstance Size: %u\n", indent, "", values->instance_size);
   fprintf(fp, "%*sInstance Primitive Size: %u\n", indent, "", values->instance_primitive_size);
   fprintf(fp, "%*sOffset start: %" PRId64 "\n", indent, "", (int64_t)values->offset_start);
   fprintf(fp, "%*sPrimitive Index Base: %" PRId64 "\n", indent, "", (int64_t)values->primitive_index_base);
   fprintf(fp, "%*sPosition: 0x%" PRIx64 "\n", indent, "", values->position);
   fprintf(fp, "%*sUniform buffers: 0x%" PRIx64 "\n", indent, "", values->uniform_buffers);
   fprintf(fp, "%*sTextures: 0x%" PRIx64 "\n", indent, "", values->textures);
   fprintf(fp, "%*sSamplers: 0x%" PRIx64 "\n", indent, "", values->samplers);
   fprintf(fp, "%*sPush uniforms: 0x%" PRIx64 "\n", indent, "", values->push_uniforms);
   fprintf(fp, "%*sState: 0x%" PRIx64 "\n", indent, "", values->state);
   fprintf(fp, "%*sAttribute buffers: 0x%" PRIx64 "\n", indent, "", values->attribute_buffers);
   fprintf(fp, "%*sAttributes: 0x%" PRIx64 "\n", indent, "", values->attributes);
   fprintf(fp, "%*sVarying buffers: 0x%" PRIx64 "\n", indent, "", values->varying_buffers);
   fprintf(fp, "%*sVaryings: 0x%" PRIx64 "\n", indent, "", values->varyings);
   fprintf(fp, "%*sViewport: 0x%" PRIx64 "\n", indent, "", values->viewport);
   fprintf(fp, "%*sOcclusion: 0x%" PRIx64 "\n", indent, "", values->occlusion);
   fprintf(fp, "%*sThread Storage: 0x%" PRIx64 "\n", indent, "", values->thread_storage);
   fprintf(fp, "%*sFBD: 0x%" PRIx64 "\n", indent, "", values->fbd);
}

#endif
enum mali_surface_type {
        MALI_SURFACE_TYPE_32                 =      0,
        MALI_SURFACE_TYPE_64                 =      1,
        MALI_SURFACE_TYPE_32_WITH_ROW_STRIDE =      2,
        MALI_SURFACE_TYPE_64_WITH_STRIDES    =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_surface_type_as_str(enum mali_surface_type imm)
{
    switch (imm) {
    case MALI_SURFACE_TYPE_32: return "32";
    case MALI_SURFACE_TYPE_64: return "64";
    case MALI_SURFACE_TYPE_32_WITH_ROW_STRIDE: return "32 With Row Stride";
    case MALI_SURFACE_TYPE_64_WITH_STRIDES: return "64 With Strides";
    default: return "XXX: INVALID";
    }
}

#endif

struct MALI_SURFACE {
   uint64_t                             pointer;
};

#define MALI_SURFACE_header                     \
   0

#define MALI_SURFACE_LENGTH 8
#define MALI_SURFACE_ALIGN 8
struct mali_surface_packed { uint32_t opaque[2]; };
#define MALI_SURFACE_PACKED_T struct mali_surface_packed
#define MALI_SURFACE_pack(__packed, __unpacked) \
do { \
   MALI_SURFACE_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->pointer, 0, 63); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->pointer, 0, 63) >> 32; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_SURFACE_unpack(__packed, __unpacked) \
do { \
   MALI_SURFACE_PACKED_T __tmp_packed = *(__packed); \
   __gen_unpack_uint((__unpacked)->pointer, &__tmp_packed.opaque[0], 0, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_SURFACE_print(FILE *fp, const struct MALI_SURFACE * values, unsigned indent)
{
   fprintf(fp, "%*sPointer: 0x%" PRIx64 "\n", indent, "", values->pointer);
}

#endif
struct MALI_SURFACE_32 {
   uint64_t                             pointer;
};

#define MALI_SURFACE_32_header                  \
   0

#define MALI_SURFACE_32_LENGTH 4
#define MALI_SURFACE_32_ALIGN 4
struct mali_surface_32_packed { uint32_t opaque[1]; };
#define MALI_SURFACE_32_PACKED_T struct mali_surface_32_packed
#define MALI_SURFACE_32_pack(__packed, __unpacked) \
do { \
   MALI_SURFACE_32_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->pointer, 0, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_SURFACE_32_unpack(__packed, __unpacked) \
do { \
   MALI_SURFACE_32_PACKED_T __tmp_packed = *(__packed); \
   __gen_unpack_uint((__unpacked)->pointer, &__tmp_packed.opaque[0], 0, 31); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_SURFACE_32_print(FILE *fp, const struct MALI_SURFACE_32 * values, unsigned indent)
{
   fprintf(fp, "%*sPointer: 0x%" PRIx64 "\n", indent, "", values->pointer);
}

#endif
struct MALI_SURFACE_32_WITH_ROW_STRIDE {
   uint64_t                             pointer;
   int64_t                              row_stride;
};

#define MALI_SURFACE_32_WITH_ROW_STRIDE_header  \
   0

#define MALI_SURFACE_32_WITH_ROW_STRIDE_LENGTH 8
#define MALI_SURFACE_32_WITH_ROW_STRIDE_ALIGN 8
struct mali_surface_32_with_row_stride_packed { uint32_t opaque[2]; };
#define MALI_SURFACE_32_WITH_ROW_STRIDE_PACKED_T struct mali_surface_32_with_row_stride_packed
#define MALI_SURFACE_32_WITH_ROW_STRIDE_pack(__packed, __unpacked) \
do { \
   MALI_SURFACE_32_WITH_ROW_STRIDE_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->pointer, 0, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_sint((__unpacked)->row_stride, 0, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_SURFACE_32_WITH_ROW_STRIDE_unpack(__packed, __unpacked) \
do { \
   MALI_SURFACE_32_WITH_ROW_STRIDE_PACKED_T __tmp_packed = *(__packed); \
   __gen_unpack_uint((__unpacked)->pointer, &__tmp_packed.opaque[0], 0, 31); \
   __gen_unpack_sint((__unpacked)->row_stride, &__tmp_packed.opaque[0], 32, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_SURFACE_32_WITH_ROW_STRIDE_print(FILE *fp, const struct MALI_SURFACE_32_WITH_ROW_STRIDE * values, unsigned indent)
{
   fprintf(fp, "%*sPointer: 0x%" PRIx64 "\n", indent, "", values->pointer);
   fprintf(fp, "%*sRow stride: %" PRId64 "\n", indent, "", (int64_t)values->row_stride);
}

#endif
struct MALI_SURFACE_WITH_STRIDE {
   uint64_t                             pointer;
   int64_t                              row_stride;
   int64_t                              surface_stride;
};

#define MALI_SURFACE_WITH_STRIDE_header         \
   0

#define MALI_SURFACE_WITH_STRIDE_LENGTH 16
#define MALI_SURFACE_WITH_STRIDE_ALIGN 8
struct mali_surface_with_stride_packed { uint32_t opaque[4]; };
#define MALI_SURFACE_WITH_STRIDE_PACKED_T struct mali_surface_with_stride_packed
#define MALI_SURFACE_WITH_STRIDE_pack(__packed, __unpacked) \
do { \
   MALI_SURFACE_WITH_STRIDE_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->pointer, 0, 63); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->pointer, 0, 63) >> 32; \
   __tmp_packed.opaque[ 2] = util_bitpack_sint((__unpacked)->row_stride, 0, 31); \
   __tmp_packed.opaque[ 3] = util_bitpack_sint((__unpacked)->surface_stride, 0, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_SURFACE_WITH_STRIDE_unpack(__packed, __unpacked) \
do { \
   MALI_SURFACE_WITH_STRIDE_PACKED_T __tmp_packed = *(__packed); \
   __gen_unpack_uint((__unpacked)->pointer, &__tmp_packed.opaque[0], 0, 63); \
   __gen_unpack_sint((__unpacked)->row_stride, &__tmp_packed.opaque[0], 64, 95); \
   __gen_unpack_sint((__unpacked)->surface_stride, &__tmp_packed.opaque[0], 96, 127); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_SURFACE_WITH_STRIDE_print(FILE *fp, const struct MALI_SURFACE_WITH_STRIDE * values, unsigned indent)
{
   fprintf(fp, "%*sPointer: 0x%" PRIx64 "\n", indent, "", values->pointer);
   fprintf(fp, "%*sRow stride: %" PRId64 "\n", indent, "", (int64_t)values->row_stride);
   fprintf(fp, "%*sSurface stride: %" PRId64 "\n", indent, "", (int64_t)values->surface_stride);
}

#endif
struct MALI_SAMPLER {
   bool                                 magnify_nearest;
   bool                                 minify_nearest;
   enum mali_mipmap_mode                mipmap_mode;
   bool                                 normalized_coordinates;
   bool                                 isotropic_lod;
   float                                lod_bias;
   float                                minimum_lod;
   float                                maximum_lod;
   enum mali_wrap_mode                  wrap_mode_s;
   enum mali_wrap_mode                  wrap_mode_t;
   enum mali_wrap_mode                  wrap_mode_r;
   enum mali_func                       compare_function;
   bool                                 seamless_cube_map;
   uint32_t                             border_color_r;
   uint32_t                             border_color_g;
   uint32_t                             border_color_b;
   uint32_t                             border_color_a;
};

#define MALI_SAMPLER_header                     \
   .magnify_nearest = true,  \
   .minify_nearest = true,  \
   .mipmap_mode = MALI_MIPMAP_MODE_NEAREST,  \
   .normalized_coordinates = true,  \
   .lod_bias = 0,  \
   .minimum_lod = 0,  \
   .maximum_lod = 0,  \
   .wrap_mode_s = MALI_WRAP_MODE_CLAMP_TO_EDGE,  \
   .wrap_mode_t = MALI_WRAP_MODE_CLAMP_TO_EDGE,  \
   .wrap_mode_r = MALI_WRAP_MODE_CLAMP_TO_EDGE,  \
   .compare_function = MALI_FUNC_NEVER,  \
   .seamless_cube_map = true,  \
   .border_color_r = 0.0,  \
   .border_color_g = 0.0,  \
   .border_color_b = 0.0,  \
   .border_color_a = 0.0

#define MALI_SAMPLER_LENGTH 32
#define MALI_SAMPLER_ALIGN 32
struct mali_sampler_packed { uint32_t opaque[8]; };
#define MALI_SAMPLER_PACKED_T struct mali_sampler_packed
#define MALI_SAMPLER_pack(__packed, __unpacked) \
do { \
   MALI_SAMPLER_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->magnify_nearest, 0, 0) | \
            util_bitpack_uint((__unpacked)->minify_nearest, 1, 1) | \
            util_bitpack_uint((__unpacked)->mipmap_mode, 3, 4) | \
            util_bitpack_uint((__unpacked)->normalized_coordinates, 5, 5) | \
            util_bitpack_uint((__unpacked)->isotropic_lod, 6, 6) | \
            util_bitpack_sfixed_clamp((__unpacked)->lod_bias, 16, 31, 8); \
   __tmp_packed.opaque[ 1] = util_bitpack_ufixed_clamp((__unpacked)->minimum_lod, 0, 15, 8) | \
            util_bitpack_ufixed_clamp((__unpacked)->maximum_lod, 16, 31, 8); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->wrap_mode_s, 0, 3) | \
            util_bitpack_uint((__unpacked)->wrap_mode_t, 4, 7) | \
            util_bitpack_uint((__unpacked)->wrap_mode_r, 8, 11) | \
            util_bitpack_uint((__unpacked)->compare_function, 12, 14) | \
            util_bitpack_uint((__unpacked)->seamless_cube_map, 15, 15); \
   __tmp_packed.opaque[ 3] = 0; \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->border_color_r, 0, 31); \
   __tmp_packed.opaque[ 5] = util_bitpack_uint((__unpacked)->border_color_g, 0, 31); \
   __tmp_packed.opaque[ 6] = util_bitpack_uint((__unpacked)->border_color_b, 0, 31); \
   __tmp_packed.opaque[ 7] = util_bitpack_uint((__unpacked)->border_color_a, 0, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_SAMPLER_unpack(__packed, __unpacked) \
do { \
   MALI_SAMPLER_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xff84) fprintf(stderr, "XXX: Invalid field of Sampler unpacked at word 0\n"); \
   if (__tmp_packed.opaque[2] & 0xffff0000) fprintf(stderr, "XXX: Invalid field of Sampler unpacked at word 2\n"); \
   if (__tmp_packed.opaque[3] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Sampler unpacked at word 3\n"); \
   __gen_unpack_uint((__unpacked)->magnify_nearest, &__tmp_packed.opaque[0], 0, 0); \
   __gen_unpack_uint((__unpacked)->minify_nearest, &__tmp_packed.opaque[0], 1, 1); \
   __gen_unpack_uint((__unpacked)->mipmap_mode, &__tmp_packed.opaque[0], 3, 4); \
   __gen_unpack_uint((__unpacked)->normalized_coordinates, &__tmp_packed.opaque[0], 5, 5); \
   __gen_unpack_uint((__unpacked)->isotropic_lod, &__tmp_packed.opaque[0], 6, 6); \
   __gen_unpack_slod((__unpacked)->lod_bias, &__tmp_packed.opaque[0], 16, 31); \
   __gen_unpack_ulod((__unpacked)->minimum_lod, &__tmp_packed.opaque[0], 32, 47); \
   __gen_unpack_ulod((__unpacked)->maximum_lod, &__tmp_packed.opaque[0], 48, 63); \
   __gen_unpack_uint((__unpacked)->wrap_mode_s, &__tmp_packed.opaque[0], 64, 67); \
   __gen_unpack_uint((__unpacked)->wrap_mode_t, &__tmp_packed.opaque[0], 68, 71); \
   __gen_unpack_uint((__unpacked)->wrap_mode_r, &__tmp_packed.opaque[0], 72, 75); \
   __gen_unpack_uint((__unpacked)->compare_function, &__tmp_packed.opaque[0], 76, 78); \
   __gen_unpack_uint((__unpacked)->seamless_cube_map, &__tmp_packed.opaque[0], 79, 79); \
   __gen_unpack_uint((__unpacked)->border_color_r, &__tmp_packed.opaque[0], 128, 159); \
   __gen_unpack_uint((__unpacked)->border_color_g, &__tmp_packed.opaque[0], 160, 191); \
   __gen_unpack_uint((__unpacked)->border_color_b, &__tmp_packed.opaque[0], 192, 223); \
   __gen_unpack_uint((__unpacked)->border_color_a, &__tmp_packed.opaque[0], 224, 255); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_SAMPLER_print(FILE *fp, const struct MALI_SAMPLER * values, unsigned indent)
{
   fprintf(fp, "%*sMagnify Nearest: %s\n", indent, "", values->magnify_nearest ? "true" : "false");
   fprintf(fp, "%*sMinify Nearest: %s\n", indent, "", values->minify_nearest ? "true" : "false");
   fprintf(fp, "%*sMipmap Mode: %s\n", indent, "", mali_mipmap_mode_as_str(values->mipmap_mode));
   fprintf(fp, "%*sNormalized Coordinates: %s\n", indent, "", values->normalized_coordinates ? "true" : "false");
   fprintf(fp, "%*sIsotropic LOD: %s\n", indent, "", values->isotropic_lod ? "true" : "false");
   fprintf(fp, "%*sLOD Bias: %f\n", indent, "", values->lod_bias);
   fprintf(fp, "%*sMinimum LOD: %f\n", indent, "", values->minimum_lod);
   fprintf(fp, "%*sMaximum LOD: %f\n", indent, "", values->maximum_lod);
   fprintf(fp, "%*sWrap Mode S: %s\n", indent, "", mali_wrap_mode_as_str(values->wrap_mode_s));
   fprintf(fp, "%*sWrap Mode T: %s\n", indent, "", mali_wrap_mode_as_str(values->wrap_mode_t));
   fprintf(fp, "%*sWrap Mode R: %s\n", indent, "", mali_wrap_mode_as_str(values->wrap_mode_r));
   fprintf(fp, "%*sCompare Function: %s\n", indent, "", mali_func_as_str(values->compare_function));
   fprintf(fp, "%*sSeamless Cube Map: %s\n", indent, "", values->seamless_cube_map ? "true" : "false");
   fprintf(fp, "%*sBorder Color R: 0x%X (%f)\n", indent, "", values->border_color_r, uif(values->border_color_r));
   fprintf(fp, "%*sBorder Color G: 0x%X (%f)\n", indent, "", values->border_color_g, uif(values->border_color_g));
   fprintf(fp, "%*sBorder Color B: 0x%X (%f)\n", indent, "", values->border_color_b, uif(values->border_color_b));
   fprintf(fp, "%*sBorder Color A: 0x%X (%f)\n", indent, "", values->border_color_a, uif(values->border_color_a));
}

#endif
struct MALI_TEXTURE {
   uint32_t                             width;
   uint32_t                             height;
   uint32_t                             depth;
   uint32_t                             sample_count;
   uint32_t                             array_size;
   uint32_t                             format;
   enum mali_texture_dimension          dimension;
   enum mali_texture_layout             texel_ordering;
   enum mali_surface_type               surface_type;
   uint32_t                             levels;
   uint32_t                             swizzle;
};

#define MALI_TEXTURE_header                     \
   .depth = 1,  \
   .sample_count = 1,  \
   .surface_type = MALI_SURFACE_TYPE_64_WITH_STRIDES,  \
   .levels = 1

#define MALI_TEXTURE_LENGTH 32
#define MALI_TEXTURE_ALIGN 64
struct mali_texture_packed { uint32_t opaque[8]; };
#define MALI_TEXTURE_PACKED_T struct mali_texture_packed
#define MALI_TEXTURE_pack(__packed, __unpacked) \
do { \
   MALI_TEXTURE_PACKED_T __tmp_packed; \
   assert((__unpacked)->width >= 1); \
   assert((__unpacked)->height >= 1); \
   assert((__unpacked)->depth >= 1); \
   assert((__unpacked)->sample_count >= 1); \
   assert((__unpacked)->array_size >= 1); \
   assert((__unpacked)->levels >= 1); \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->width - 1, 0, 15) | \
            util_bitpack_uint((__unpacked)->height - 1, 16, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->depth - 1, 0, 15) | \
            util_bitpack_uint((__unpacked)->sample_count - 1, 0, 15) | \
            util_bitpack_uint((__unpacked)->array_size - 1, 16, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->format, 0, 21) | \
            util_bitpack_uint((__unpacked)->dimension, 22, 23) | \
            util_bitpack_uint((__unpacked)->texel_ordering, 24, 27) | \
            util_bitpack_uint((__unpacked)->surface_type, 28, 29); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->levels - 1, 24, 31); \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->swizzle, 0, 11); \
   __tmp_packed.opaque[ 5] = 0; \
   __tmp_packed.opaque[ 6] = 0; \
   __tmp_packed.opaque[ 7] = 0; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_TEXTURE_unpack(__packed, __unpacked) \
do { \
   MALI_TEXTURE_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[2] & 0xc0000000) fprintf(stderr, "XXX: Invalid field of Texture unpacked at word 2\n"); \
   if (__tmp_packed.opaque[3] & 0xffffff) fprintf(stderr, "XXX: Invalid field of Texture unpacked at word 3\n"); \
   if (__tmp_packed.opaque[4] & 0xfffff000) fprintf(stderr, "XXX: Invalid field of Texture unpacked at word 4\n"); \
   if (__tmp_packed.opaque[5] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Texture unpacked at word 5\n"); \
   if (__tmp_packed.opaque[6] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Texture unpacked at word 6\n"); \
   if (__tmp_packed.opaque[7] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Texture unpacked at word 7\n"); \
   __gen_unpack_uint((__unpacked)->width, &__tmp_packed.opaque[0], 0, 15); \
   (__unpacked)->width = (__unpacked)->width + 1; \
   __gen_unpack_uint((__unpacked)->height, &__tmp_packed.opaque[0], 16, 31); \
   (__unpacked)->height = (__unpacked)->height + 1; \
   __gen_unpack_uint((__unpacked)->depth, &__tmp_packed.opaque[0], 32, 47); \
   (__unpacked)->depth = (__unpacked)->depth + 1; \
   __gen_unpack_uint((__unpacked)->sample_count, &__tmp_packed.opaque[0], 32, 47); \
   (__unpacked)->sample_count = (__unpacked)->sample_count + 1; \
   __gen_unpack_uint((__unpacked)->array_size, &__tmp_packed.opaque[0], 48, 63); \
   (__unpacked)->array_size = (__unpacked)->array_size + 1; \
   __gen_unpack_uint((__unpacked)->format, &__tmp_packed.opaque[0], 64, 85); \
   __gen_unpack_uint((__unpacked)->dimension, &__tmp_packed.opaque[0], 86, 87); \
   __gen_unpack_uint((__unpacked)->texel_ordering, &__tmp_packed.opaque[0], 88, 91); \
   __gen_unpack_uint((__unpacked)->surface_type, &__tmp_packed.opaque[0], 92, 93); \
   __gen_unpack_uint((__unpacked)->levels, &__tmp_packed.opaque[0], 120, 127); \
   (__unpacked)->levels = (__unpacked)->levels + 1; \
   __gen_unpack_uint((__unpacked)->swizzle, &__tmp_packed.opaque[0], 128, 139); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_TEXTURE_print(FILE *fp, const struct MALI_TEXTURE * values, unsigned indent)
{
   fprintf(fp, "%*sWidth: %u\n", indent, "", values->width);
   fprintf(fp, "%*sHeight: %u\n", indent, "", values->height);
   fprintf(fp, "%*sDepth: %u\n", indent, "", values->depth);
   fprintf(fp, "%*sSample count: %u\n", indent, "", values->sample_count);
   fprintf(fp, "%*sArray size: %u\n", indent, "", values->array_size);
   mali_pixel_format_print(fp, values->format);
   fprintf(fp, "%*sDimension: %s\n", indent, "", mali_texture_dimension_as_str(values->dimension));
   fprintf(fp, "%*sTexel ordering: %s\n", indent, "", mali_texture_layout_as_str(values->texel_ordering));
   fprintf(fp, "%*sSurface Type: %s\n", indent, "", mali_surface_type_as_str(values->surface_type));
   fprintf(fp, "%*sLevels: %u\n", indent, "", values->levels);
   fprintf(fp, "%*sSwizzle: %u\n", indent, "", values->swizzle);
}

#endif
enum mali_fp_mode {
        MALI_FP_MODE_GL_INF_NAN_ALLOWED      =      0,
        MALI_FP_MODE_GL_INF_NAN_SUPPRESSED   =      1,
        MALI_FP_MODE_CL                      =      2,
        MALI_FP_MODE_D3D11                   =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_fp_mode_as_str(enum mali_fp_mode imm)
{
    switch (imm) {
    case MALI_FP_MODE_GL_INF_NAN_ALLOWED: return "GL Inf/NaN Allowed";
    case MALI_FP_MODE_GL_INF_NAN_SUPPRESSED: return "GL Inf/NaN Suppressed";
    case MALI_FP_MODE_CL: return "CL";
    case MALI_FP_MODE_D3D11: return "D3D11";
    default: return "XXX: INVALID";
    }
}

#endif

struct MALI_RENDERER_PROPERTIES {
   uint32_t                             uniform_buffer_count;
   enum mali_depth_source               depth_source;
   bool                                 shader_contains_barrier;
   bool                                 force_early_z;
   bool                                 shader_contains_discard;
   bool                                 shader_has_side_effects;
   bool                                 shader_reads_tilebuffer;
   bool                                 forward_pixel_kill;
   uint32_t                             work_register_count;
   uint32_t                             uniform_count;
   bool                                 stencil_from_shader;
   enum mali_fp_mode                    fp_mode;
};

#define MALI_RENDERER_PROPERTIES_header         \
   .depth_source = MALI_DEPTH_SOURCE_MINIMUM

#define MALI_RENDERER_PROPERTIES_LENGTH 4
struct mali_renderer_properties_packed { uint32_t opaque[1]; };
#define MALI_RENDERER_PROPERTIES_PACKED_T struct mali_renderer_properties_packed
#define MALI_RENDERER_PROPERTIES_pack(__packed, __unpacked) \
do { \
   MALI_RENDERER_PROPERTIES_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->uniform_buffer_count, 0, 7) | \
            util_bitpack_uint((__unpacked)->depth_source, 8, 9) | \
            util_bitpack_uint((__unpacked)->shader_contains_barrier, 11, 11) | \
            util_bitpack_uint((__unpacked)->force_early_z, 10, 10) | \
            util_bitpack_uint((__unpacked)->shader_contains_discard, 12, 12) | \
            util_bitpack_uint((__unpacked)->shader_has_side_effects, 13, 13) | \
            util_bitpack_uint((__unpacked)->shader_reads_tilebuffer, 14, 14) | \
            util_bitpack_uint((__unpacked)->forward_pixel_kill, 15, 15) | \
            util_bitpack_uint((__unpacked)->work_register_count, 16, 20) | \
            util_bitpack_uint((__unpacked)->uniform_count, 21, 25) | \
            util_bitpack_uint((__unpacked)->stencil_from_shader, 28, 28) | \
            util_bitpack_uint((__unpacked)->fp_mode, 29, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_RENDERER_PROPERTIES_unpack(__packed, __unpacked) \
do { \
   MALI_RENDERER_PROPERTIES_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xc000000) fprintf(stderr, "XXX: Invalid field of Renderer Properties unpacked at word 0\n"); \
   __gen_unpack_uint((__unpacked)->uniform_buffer_count, &__tmp_packed.opaque[0], 0, 7); \
   __gen_unpack_uint((__unpacked)->depth_source, &__tmp_packed.opaque[0], 8, 9); \
   __gen_unpack_uint((__unpacked)->shader_contains_barrier, &__tmp_packed.opaque[0], 11, 11); \
   __gen_unpack_uint((__unpacked)->force_early_z, &__tmp_packed.opaque[0], 10, 10); \
   __gen_unpack_uint((__unpacked)->shader_contains_discard, &__tmp_packed.opaque[0], 12, 12); \
   __gen_unpack_uint((__unpacked)->shader_has_side_effects, &__tmp_packed.opaque[0], 13, 13); \
   __gen_unpack_uint((__unpacked)->shader_reads_tilebuffer, &__tmp_packed.opaque[0], 14, 14); \
   __gen_unpack_uint((__unpacked)->forward_pixel_kill, &__tmp_packed.opaque[0], 15, 15); \
   __gen_unpack_uint((__unpacked)->work_register_count, &__tmp_packed.opaque[0], 16, 20); \
   __gen_unpack_uint((__unpacked)->uniform_count, &__tmp_packed.opaque[0], 21, 25); \
   __gen_unpack_uint((__unpacked)->stencil_from_shader, &__tmp_packed.opaque[0], 28, 28); \
   __gen_unpack_uint((__unpacked)->fp_mode, &__tmp_packed.opaque[0], 29, 31); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_RENDERER_PROPERTIES_print(FILE *fp, const struct MALI_RENDERER_PROPERTIES * values, unsigned indent)
{
   fprintf(fp, "%*sUniform buffer count: %u\n", indent, "", values->uniform_buffer_count);
   fprintf(fp, "%*sDepth source: %s\n", indent, "", mali_depth_source_as_str(values->depth_source));
   fprintf(fp, "%*sShader contains barrier: %s\n", indent, "", values->shader_contains_barrier ? "true" : "false");
   fprintf(fp, "%*sForce early-z: %s\n", indent, "", values->force_early_z ? "true" : "false");
   fprintf(fp, "%*sShader contains discard: %s\n", indent, "", values->shader_contains_discard ? "true" : "false");
   fprintf(fp, "%*sShader has side-effects: %s\n", indent, "", values->shader_has_side_effects ? "true" : "false");
   fprintf(fp, "%*sShader reads tilebuffer: %s\n", indent, "", values->shader_reads_tilebuffer ? "true" : "false");
   fprintf(fp, "%*sForward pixel kill: %s\n", indent, "", values->forward_pixel_kill ? "true" : "false");
   fprintf(fp, "%*sWork register count: %u\n", indent, "", values->work_register_count);
   fprintf(fp, "%*sUniform count: %u\n", indent, "", values->uniform_count);
   fprintf(fp, "%*sStencil from shader: %s\n", indent, "", values->stencil_from_shader ? "true" : "false");
   fprintf(fp, "%*sFP mode: %s\n", indent, "", mali_fp_mode_as_str(values->fp_mode));
}

#endif
struct MALI_SHADER {
   uint64_t                             shader;
   uint32_t                             sampler_count;
   uint32_t                             texture_count;
   uint32_t                             attribute_count;
   uint32_t                             varying_count;
};

#define MALI_SHADER_header                      \
   0

#define MALI_SHADER_LENGTH 16
struct mali_shader_packed { uint32_t opaque[4]; };
#define MALI_SHADER_PACKED_T struct mali_shader_packed
#define MALI_SHADER_pack(__packed, __unpacked) \
do { \
   MALI_SHADER_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->shader, 0, 63); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->shader, 0, 63) >> 32; \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->sampler_count, 0, 15) | \
            util_bitpack_uint((__unpacked)->texture_count, 16, 31); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->attribute_count, 0, 15) | \
            util_bitpack_uint((__unpacked)->varying_count, 16, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_SHADER_unpack(__packed, __unpacked) \
do { \
   MALI_SHADER_PACKED_T __tmp_packed = *(__packed); \
   __gen_unpack_uint((__unpacked)->shader, &__tmp_packed.opaque[0], 0, 63); \
   __gen_unpack_uint((__unpacked)->sampler_count, &__tmp_packed.opaque[0], 64, 79); \
   __gen_unpack_uint((__unpacked)->texture_count, &__tmp_packed.opaque[0], 80, 95); \
   __gen_unpack_uint((__unpacked)->attribute_count, &__tmp_packed.opaque[0], 96, 111); \
   __gen_unpack_uint((__unpacked)->varying_count, &__tmp_packed.opaque[0], 112, 127); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_SHADER_print(FILE *fp, const struct MALI_SHADER * values, unsigned indent)
{
   fprintf(fp, "%*sShader: 0x%" PRIx64 "\n", indent, "", values->shader);
   fprintf(fp, "%*sSampler count: %u\n", indent, "", values->sampler_count);
   fprintf(fp, "%*sTexture count: %u\n", indent, "", values->texture_count);
   fprintf(fp, "%*sAttribute count: %u\n", indent, "", values->attribute_count);
   fprintf(fp, "%*sVarying count: %u\n", indent, "", values->varying_count);
}

#endif
struct MALI_MULTISAMPLE_MISC {
   uint32_t                             sample_mask;
   bool                                 multisample_enable;
   bool                                 multisample_late_coverage;
   bool                                 evaluate_per_sample;
   bool                                 fixed_function_depth_range_fixed;
   bool                                 shader_depth_range_fixed;
   bool                                 load_destination;
   bool                                 blend_shader;
   bool                                 blend_shader_discard;
   enum mali_func                       depth_function;
   bool                                 depth_write_mask;
   bool                                 fixed_function_near_discard;
   bool                                 fixed_function_far_discard;
   bool                                 fragment_near_discard;
   bool                                 fragment_far_discard;
};

#define MALI_MULTISAMPLE_MISC_header            \
   0

#define MALI_MULTISAMPLE_MISC_LENGTH 4
struct mali_multisample_misc_packed { uint32_t opaque[1]; };
#define MALI_MULTISAMPLE_MISC_PACKED_T struct mali_multisample_misc_packed
#define MALI_MULTISAMPLE_MISC_pack(__packed, __unpacked) \
do { \
   MALI_MULTISAMPLE_MISC_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->sample_mask, 0, 15) | \
            util_bitpack_uint((__unpacked)->multisample_enable, 16, 16) | \
            util_bitpack_uint((__unpacked)->multisample_late_coverage, 17, 17) | \
            util_bitpack_uint((__unpacked)->evaluate_per_sample, 18, 18) | \
            util_bitpack_uint((__unpacked)->fixed_function_depth_range_fixed, 19, 19) | \
            util_bitpack_uint((__unpacked)->shader_depth_range_fixed, 20, 20) | \
            util_bitpack_uint((__unpacked)->load_destination, 21, 21) | \
            util_bitpack_uint((__unpacked)->blend_shader, 22, 22) | \
            util_bitpack_uint((__unpacked)->blend_shader_discard, 23, 23) | \
            util_bitpack_uint((__unpacked)->depth_function, 24, 26) | \
            util_bitpack_uint((__unpacked)->depth_write_mask, 27, 27) | \
            util_bitpack_uint((__unpacked)->fixed_function_near_discard, 28, 28) | \
            util_bitpack_uint((__unpacked)->fixed_function_far_discard, 29, 29) | \
            util_bitpack_uint((__unpacked)->fragment_near_discard, 30, 30) | \
            util_bitpack_uint((__unpacked)->fragment_far_discard, 31, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_MULTISAMPLE_MISC_unpack(__packed, __unpacked) \
do { \
   MALI_MULTISAMPLE_MISC_PACKED_T __tmp_packed = *(__packed); \
   __gen_unpack_uint((__unpacked)->sample_mask, &__tmp_packed.opaque[0], 0, 15); \
   __gen_unpack_uint((__unpacked)->multisample_enable, &__tmp_packed.opaque[0], 16, 16); \
   __gen_unpack_uint((__unpacked)->multisample_late_coverage, &__tmp_packed.opaque[0], 17, 17); \
   __gen_unpack_uint((__unpacked)->evaluate_per_sample, &__tmp_packed.opaque[0], 18, 18); \
   __gen_unpack_uint((__unpacked)->fixed_function_depth_range_fixed, &__tmp_packed.opaque[0], 19, 19); \
   __gen_unpack_uint((__unpacked)->shader_depth_range_fixed, &__tmp_packed.opaque[0], 20, 20); \
   __gen_unpack_uint((__unpacked)->load_destination, &__tmp_packed.opaque[0], 21, 21); \
   __gen_unpack_uint((__unpacked)->blend_shader, &__tmp_packed.opaque[0], 22, 22); \
   __gen_unpack_uint((__unpacked)->blend_shader_discard, &__tmp_packed.opaque[0], 23, 23); \
   __gen_unpack_uint((__unpacked)->depth_function, &__tmp_packed.opaque[0], 24, 26); \
   __gen_unpack_uint((__unpacked)->depth_write_mask, &__tmp_packed.opaque[0], 27, 27); \
   __gen_unpack_uint((__unpacked)->fixed_function_near_discard, &__tmp_packed.opaque[0], 28, 28); \
   __gen_unpack_uint((__unpacked)->fixed_function_far_discard, &__tmp_packed.opaque[0], 29, 29); \
   __gen_unpack_uint((__unpacked)->fragment_near_discard, &__tmp_packed.opaque[0], 30, 30); \
   __gen_unpack_uint((__unpacked)->fragment_far_discard, &__tmp_packed.opaque[0], 31, 31); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_MULTISAMPLE_MISC_print(FILE *fp, const struct MALI_MULTISAMPLE_MISC * values, unsigned indent)
{
   fprintf(fp, "%*sSample mask: %u\n", indent, "", values->sample_mask);
   fprintf(fp, "%*sMultisample enable: %s\n", indent, "", values->multisample_enable ? "true" : "false");
   fprintf(fp, "%*sMultisample late coverage: %s\n", indent, "", values->multisample_late_coverage ? "true" : "false");
   fprintf(fp, "%*sEvaluate per-sample: %s\n", indent, "", values->evaluate_per_sample ? "true" : "false");
   fprintf(fp, "%*sFixed-function depth range fixed: %s\n", indent, "", values->fixed_function_depth_range_fixed ? "true" : "false");
   fprintf(fp, "%*sShader depth range fixed: %s\n", indent, "", values->shader_depth_range_fixed ? "true" : "false");
   fprintf(fp, "%*sLoad destination: %s\n", indent, "", values->load_destination ? "true" : "false");
   fprintf(fp, "%*sBlend shader: %s\n", indent, "", values->blend_shader ? "true" : "false");
   fprintf(fp, "%*sBlend shader discard: %s\n", indent, "", values->blend_shader_discard ? "true" : "false");
   fprintf(fp, "%*sDepth function: %s\n", indent, "", mali_func_as_str(values->depth_function));
   fprintf(fp, "%*sDepth write mask: %s\n", indent, "", values->depth_write_mask ? "true" : "false");
   fprintf(fp, "%*sFixed-function near discard: %s\n", indent, "", values->fixed_function_near_discard ? "true" : "false");
   fprintf(fp, "%*sFixed-function far discard: %s\n", indent, "", values->fixed_function_far_discard ? "true" : "false");
   fprintf(fp, "%*sFragment near discard: %s\n", indent, "", values->fragment_near_discard ? "true" : "false");
   fprintf(fp, "%*sFragment far discard: %s\n", indent, "", values->fragment_far_discard ? "true" : "false");
}

#endif
struct MALI_STENCIL_MASK_MISC {
   uint32_t                             stencil_mask_front;
   uint32_t                             stencil_mask_back;
   bool                                 stencil_enable;
   bool                                 alpha_to_coverage;
   bool                                 alpha_to_coverage_invert;
   bool                                 alpha_to_one;
   bool                                 write_enable;
   enum mali_func                       alpha_test_compare_function;
   bool                                 srgb;
   bool                                 dither_disable;
   bool                                 force_seamless_cubemaps;
   bool                                 front_facing_depth_bias;
   bool                                 back_facing_depth_bias;
   bool                                 aligned_line_ends;
   bool                                 point_snap;
};

#define MALI_STENCIL_MASK_MISC_header           \
   0

#define MALI_STENCIL_MASK_MISC_LENGTH 4
struct mali_stencil_mask_misc_packed { uint32_t opaque[1]; };
#define MALI_STENCIL_MASK_MISC_PACKED_T struct mali_stencil_mask_misc_packed
#define MALI_STENCIL_MASK_MISC_pack(__packed, __unpacked) \
do { \
   MALI_STENCIL_MASK_MISC_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->stencil_mask_front, 0, 7) | \
            util_bitpack_uint((__unpacked)->stencil_mask_back, 8, 15) | \
            util_bitpack_uint((__unpacked)->stencil_enable, 16, 16) | \
            util_bitpack_uint((__unpacked)->alpha_to_coverage, 17, 17) | \
            util_bitpack_uint((__unpacked)->alpha_to_coverage_invert, 18, 18) | \
            util_bitpack_uint((__unpacked)->alpha_to_one, 19, 19) | \
            util_bitpack_uint((__unpacked)->write_enable, 20, 20) | \
            util_bitpack_uint((__unpacked)->alpha_test_compare_function, 21, 23) | \
            util_bitpack_uint((__unpacked)->srgb, 24, 24) | \
            util_bitpack_uint((__unpacked)->dither_disable, 25, 25) | \
            util_bitpack_uint((__unpacked)->force_seamless_cubemaps, 26, 26) | \
            util_bitpack_uint((__unpacked)->front_facing_depth_bias, 28, 28) | \
            util_bitpack_uint((__unpacked)->back_facing_depth_bias, 29, 29) | \
            util_bitpack_uint((__unpacked)->aligned_line_ends, 30, 30) | \
            util_bitpack_uint((__unpacked)->point_snap, 31, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_STENCIL_MASK_MISC_unpack(__packed, __unpacked) \
do { \
   MALI_STENCIL_MASK_MISC_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0x8000000) fprintf(stderr, "XXX: Invalid field of Stencil Mask, Misc unpacked at word 0\n"); \
   __gen_unpack_uint((__unpacked)->stencil_mask_front, &__tmp_packed.opaque[0], 0, 7); \
   __gen_unpack_uint((__unpacked)->stencil_mask_back, &__tmp_packed.opaque[0], 8, 15); \
   __gen_unpack_uint((__unpacked)->stencil_enable, &__tmp_packed.opaque[0], 16, 16); \
   __gen_unpack_uint((__unpacked)->alpha_to_coverage, &__tmp_packed.opaque[0], 17, 17); \
   __gen_unpack_uint((__unpacked)->alpha_to_coverage_invert, &__tmp_packed.opaque[0], 18, 18); \
   __gen_unpack_uint((__unpacked)->alpha_to_one, &__tmp_packed.opaque[0], 19, 19); \
   __gen_unpack_uint((__unpacked)->write_enable, &__tmp_packed.opaque[0], 20, 20); \
   __gen_unpack_uint((__unpacked)->alpha_test_compare_function, &__tmp_packed.opaque[0], 21, 23); \
   __gen_unpack_uint((__unpacked)->srgb, &__tmp_packed.opaque[0], 24, 24); \
   __gen_unpack_uint((__unpacked)->dither_disable, &__tmp_packed.opaque[0], 25, 25); \
   __gen_unpack_uint((__unpacked)->force_seamless_cubemaps, &__tmp_packed.opaque[0], 26, 26); \
   __gen_unpack_uint((__unpacked)->front_facing_depth_bias, &__tmp_packed.opaque[0], 28, 28); \
   __gen_unpack_uint((__unpacked)->back_facing_depth_bias, &__tmp_packed.opaque[0], 29, 29); \
   __gen_unpack_uint((__unpacked)->aligned_line_ends, &__tmp_packed.opaque[0], 30, 30); \
   __gen_unpack_uint((__unpacked)->point_snap, &__tmp_packed.opaque[0], 31, 31); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_STENCIL_MASK_MISC_print(FILE *fp, const struct MALI_STENCIL_MASK_MISC * values, unsigned indent)
{
   fprintf(fp, "%*sStencil mask front: %u\n", indent, "", values->stencil_mask_front);
   fprintf(fp, "%*sStencil mask back: %u\n", indent, "", values->stencil_mask_back);
   fprintf(fp, "%*sStencil enable: %s\n", indent, "", values->stencil_enable ? "true" : "false");
   fprintf(fp, "%*sAlpha-to-coverage: %s\n", indent, "", values->alpha_to_coverage ? "true" : "false");
   fprintf(fp, "%*sAlpha-to-coverage Invert: %s\n", indent, "", values->alpha_to_coverage_invert ? "true" : "false");
   fprintf(fp, "%*sAlpha to one: %s\n", indent, "", values->alpha_to_one ? "true" : "false");
   fprintf(fp, "%*sWrite enable: %s\n", indent, "", values->write_enable ? "true" : "false");
   fprintf(fp, "%*sAlpha test compare function: %s\n", indent, "", mali_func_as_str(values->alpha_test_compare_function));
   fprintf(fp, "%*ssRGB: %s\n", indent, "", values->srgb ? "true" : "false");
   fprintf(fp, "%*sDither disable: %s\n", indent, "", values->dither_disable ? "true" : "false");
   fprintf(fp, "%*sForce seamless cubemaps: %s\n", indent, "", values->force_seamless_cubemaps ? "true" : "false");
   fprintf(fp, "%*sFront-facing depth bias: %s\n", indent, "", values->front_facing_depth_bias ? "true" : "false");
   fprintf(fp, "%*sBack-facing depth bias: %s\n", indent, "", values->back_facing_depth_bias ? "true" : "false");
   fprintf(fp, "%*sAligned line-ends: %s\n", indent, "", values->aligned_line_ends ? "true" : "false");
   fprintf(fp, "%*sPoint snap: %s\n", indent, "", values->point_snap ? "true" : "false");
}

#endif
struct MALI_STENCIL {
   uint32_t                             reference_value;
   uint32_t                             mask;
   enum mali_func                       compare_function;
   enum mali_stencil_op                 stencil_fail;
   enum mali_stencil_op                 depth_fail;
   enum mali_stencil_op                 depth_pass;
};

#define MALI_STENCIL_header                     \
   0

#define MALI_STENCIL_LENGTH 4
struct mali_stencil_packed { uint32_t opaque[1]; };
#define MALI_STENCIL_PACKED_T struct mali_stencil_packed
#define MALI_STENCIL_pack(__packed, __unpacked) \
do { \
   MALI_STENCIL_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->reference_value, 0, 7) | \
            util_bitpack_uint((__unpacked)->mask, 8, 15) | \
            util_bitpack_uint((__unpacked)->compare_function, 16, 18) | \
            util_bitpack_uint((__unpacked)->stencil_fail, 19, 21) | \
            util_bitpack_uint((__unpacked)->depth_fail, 22, 24) | \
            util_bitpack_uint((__unpacked)->depth_pass, 25, 27); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_STENCIL_unpack(__packed, __unpacked) \
do { \
   MALI_STENCIL_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xf0000000) fprintf(stderr, "XXX: Invalid field of Stencil unpacked at word 0\n"); \
   __gen_unpack_uint((__unpacked)->reference_value, &__tmp_packed.opaque[0], 0, 7); \
   __gen_unpack_uint((__unpacked)->mask, &__tmp_packed.opaque[0], 8, 15); \
   __gen_unpack_uint((__unpacked)->compare_function, &__tmp_packed.opaque[0], 16, 18); \
   __gen_unpack_uint((__unpacked)->stencil_fail, &__tmp_packed.opaque[0], 19, 21); \
   __gen_unpack_uint((__unpacked)->depth_fail, &__tmp_packed.opaque[0], 22, 24); \
   __gen_unpack_uint((__unpacked)->depth_pass, &__tmp_packed.opaque[0], 25, 27); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_STENCIL_print(FILE *fp, const struct MALI_STENCIL * values, unsigned indent)
{
   fprintf(fp, "%*sReference Value: %u\n", indent, "", values->reference_value);
   fprintf(fp, "%*sMask: %u\n", indent, "", values->mask);
   fprintf(fp, "%*sCompare Function: %s\n", indent, "", mali_func_as_str(values->compare_function));
   fprintf(fp, "%*sStencil Fail: %s\n", indent, "", mali_stencil_op_as_str(values->stencil_fail));
   fprintf(fp, "%*sDepth Fail: %s\n", indent, "", mali_stencil_op_as_str(values->depth_fail));
   fprintf(fp, "%*sDepth Pass: %s\n", indent, "", mali_stencil_op_as_str(values->depth_pass));
}

#endif
struct MALI_RENDERER_STATE {
   struct MALI_SHADER                   shader;
   struct MALI_RENDERER_PROPERTIES      properties;
   float                                depth_units;
   float                                depth_factor;
   float                                depth_bias_clamp;
   struct MALI_MULTISAMPLE_MISC         multisample_misc;
   struct MALI_STENCIL_MASK_MISC        stencil_mask_misc;
   struct MALI_STENCIL                  stencil_front;
   struct MALI_STENCIL                  stencil_back;
   float                                alpha_reference;
   uint32_t                             thread_balancing;
   uint64_t                             blend_shader;
   struct MALI_BLEND_EQUATION           blend_equation;
   float                                blend_constant;
};

#define MALI_RENDERER_STATE_header              \
   .shader = { MALI_SHADER_header },  \
   .properties = { MALI_RENDERER_PROPERTIES_header },  \
   .multisample_misc = { MALI_MULTISAMPLE_MISC_header },  \
   .stencil_mask_misc = { MALI_STENCIL_MASK_MISC_header },  \
   .stencil_front = { MALI_STENCIL_header },  \
   .stencil_back = { MALI_STENCIL_header },  \
   .blend_equation = { MALI_BLEND_EQUATION_header }

#define MALI_RENDERER_STATE_LENGTH 64
#define MALI_RENDERER_STATE_ALIGN 64
struct mali_renderer_state_packed { uint32_t opaque[16]; };
#define MALI_RENDERER_STATE_PACKED_T struct mali_renderer_state_packed
#define MALI_RENDERER_STATE_pack(__packed, __unpacked) \
do { \
   MALI_RENDERER_STATE_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->shader.shader, 0, 63); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->shader.shader, 0, 63) >> 32; \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->shader.sampler_count, 0, 15) | \
            util_bitpack_uint((__unpacked)->shader.texture_count, 16, 31); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->shader.attribute_count, 0, 15) | \
            util_bitpack_uint((__unpacked)->shader.varying_count, 16, 31); \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->properties.uniform_buffer_count, 0, 7) | \
            util_bitpack_uint((__unpacked)->properties.depth_source, 8, 9) | \
            util_bitpack_uint((__unpacked)->properties.shader_contains_barrier, 11, 11) | \
            util_bitpack_uint((__unpacked)->properties.force_early_z, 10, 10) | \
            util_bitpack_uint((__unpacked)->properties.shader_contains_discard, 12, 12) | \
            util_bitpack_uint((__unpacked)->properties.shader_has_side_effects, 13, 13) | \
            util_bitpack_uint((__unpacked)->properties.shader_reads_tilebuffer, 14, 14) | \
            util_bitpack_uint((__unpacked)->properties.forward_pixel_kill, 15, 15) | \
            util_bitpack_uint((__unpacked)->properties.work_register_count, 16, 20) | \
            util_bitpack_uint((__unpacked)->properties.uniform_count, 21, 25) | \
            util_bitpack_uint((__unpacked)->properties.stencil_from_shader, 28, 28) | \
            util_bitpack_uint((__unpacked)->properties.fp_mode, 29, 31); \
   __tmp_packed.opaque[ 5] = util_bitpack_float((__unpacked)->depth_units); \
   __tmp_packed.opaque[ 6] = util_bitpack_float((__unpacked)->depth_factor); \
   __tmp_packed.opaque[ 7] = util_bitpack_float((__unpacked)->depth_bias_clamp); \
   __tmp_packed.opaque[ 8] = util_bitpack_uint((__unpacked)->multisample_misc.sample_mask, 0, 15) | \
            util_bitpack_uint((__unpacked)->multisample_misc.multisample_enable, 16, 16) | \
            util_bitpack_uint((__unpacked)->multisample_misc.multisample_late_coverage, 17, 17) | \
            util_bitpack_uint((__unpacked)->multisample_misc.evaluate_per_sample, 18, 18) | \
            util_bitpack_uint((__unpacked)->multisample_misc.fixed_function_depth_range_fixed, 19, 19) | \
            util_bitpack_uint((__unpacked)->multisample_misc.shader_depth_range_fixed, 20, 20) | \
            util_bitpack_uint((__unpacked)->multisample_misc.load_destination, 21, 21) | \
            util_bitpack_uint((__unpacked)->multisample_misc.blend_shader, 22, 22) | \
            util_bitpack_uint((__unpacked)->multisample_misc.blend_shader_discard, 23, 23) | \
            util_bitpack_uint((__unpacked)->multisample_misc.depth_function, 24, 26) | \
            util_bitpack_uint((__unpacked)->multisample_misc.depth_write_mask, 27, 27) | \
            util_bitpack_uint((__unpacked)->multisample_misc.fixed_function_near_discard, 28, 28) | \
            util_bitpack_uint((__unpacked)->multisample_misc.fixed_function_far_discard, 29, 29) | \
            util_bitpack_uint((__unpacked)->multisample_misc.fragment_near_discard, 30, 30) | \
            util_bitpack_uint((__unpacked)->multisample_misc.fragment_far_discard, 31, 31); \
   __tmp_packed.opaque[ 9] = util_bitpack_uint((__unpacked)->stencil_mask_misc.stencil_mask_front, 0, 7) | \
            util_bitpack_uint((__unpacked)->stencil_mask_misc.stencil_mask_back, 8, 15) | \
            util_bitpack_uint((__unpacked)->stencil_mask_misc.stencil_enable, 16, 16) | \
            util_bitpack_uint((__unpacked)->stencil_mask_misc.alpha_to_coverage, 17, 17) | \
            util_bitpack_uint((__unpacked)->stencil_mask_misc.alpha_to_coverage_invert, 18, 18) | \
            util_bitpack_uint((__unpacked)->stencil_mask_misc.alpha_to_one, 19, 19) | \
            util_bitpack_uint((__unpacked)->stencil_mask_misc.write_enable, 20, 20) | \
            util_bitpack_uint((__unpacked)->stencil_mask_misc.alpha_test_compare_function, 21, 23) | \
            util_bitpack_uint((__unpacked)->stencil_mask_misc.srgb, 24, 24) | \
            util_bitpack_uint((__unpacked)->stencil_mask_misc.dither_disable, 25, 25) | \
            util_bitpack_uint((__unpacked)->stencil_mask_misc.force_seamless_cubemaps, 26, 26) | \
            util_bitpack_uint((__unpacked)->stencil_mask_misc.front_facing_depth_bias, 28, 28) | \
            util_bitpack_uint((__unpacked)->stencil_mask_misc.back_facing_depth_bias, 29, 29) | \
            util_bitpack_uint((__unpacked)->stencil_mask_misc.aligned_line_ends, 30, 30) | \
            util_bitpack_uint((__unpacked)->stencil_mask_misc.point_snap, 31, 31); \
   __tmp_packed.opaque[10] = util_bitpack_uint((__unpacked)->stencil_front.reference_value, 0, 7) | \
            util_bitpack_uint((__unpacked)->stencil_front.mask, 8, 15) | \
            util_bitpack_uint((__unpacked)->stencil_front.compare_function, 16, 18) | \
            util_bitpack_uint((__unpacked)->stencil_front.stencil_fail, 19, 21) | \
            util_bitpack_uint((__unpacked)->stencil_front.depth_fail, 22, 24) | \
            util_bitpack_uint((__unpacked)->stencil_front.depth_pass, 25, 27); \
   __tmp_packed.opaque[11] = util_bitpack_uint((__unpacked)->stencil_back.reference_value, 0, 7) | \
            util_bitpack_uint((__unpacked)->stencil_back.mask, 8, 15) | \
            util_bitpack_uint((__unpacked)->stencil_back.compare_function, 16, 18) | \
            util_bitpack_uint((__unpacked)->stencil_back.stencil_fail, 19, 21) | \
            util_bitpack_uint((__unpacked)->stencil_back.depth_fail, 22, 24) | \
            util_bitpack_uint((__unpacked)->stencil_back.depth_pass, 25, 27); \
   __tmp_packed.opaque[12] = util_bitpack_float((__unpacked)->alpha_reference); \
   __tmp_packed.opaque[13] = util_bitpack_uint((__unpacked)->thread_balancing, 0, 15); \
   __tmp_packed.opaque[14] = util_bitpack_uint((__unpacked)->blend_shader, 0, 63) | \
            util_bitpack_uint((__unpacked)->blend_equation.rgb.a, 0, 1) | \
            util_bitpack_uint((__unpacked)->blend_equation.rgb.negate_a, 3, 3) | \
            util_bitpack_uint((__unpacked)->blend_equation.rgb.b, 4, 5) | \
            util_bitpack_uint((__unpacked)->blend_equation.rgb.negate_b, 7, 7) | \
            util_bitpack_uint((__unpacked)->blend_equation.rgb.c, 8, 10) | \
            util_bitpack_uint((__unpacked)->blend_equation.rgb.invert_c, 11, 11) | \
            util_bitpack_uint((__unpacked)->blend_equation.alpha.a, 12, 13) | \
            util_bitpack_uint((__unpacked)->blend_equation.alpha.negate_a, 15, 15) | \
            util_bitpack_uint((__unpacked)->blend_equation.alpha.b, 16, 17) | \
            util_bitpack_uint((__unpacked)->blend_equation.alpha.negate_b, 19, 19) | \
            util_bitpack_uint((__unpacked)->blend_equation.alpha.c, 20, 22) | \
            util_bitpack_uint((__unpacked)->blend_equation.alpha.invert_c, 23, 23) | \
            util_bitpack_uint((__unpacked)->blend_equation.color_mask, 28, 31); \
   __tmp_packed.opaque[15] = util_bitpack_uint((__unpacked)->blend_shader, 0, 63) >> 32 | \
            util_bitpack_float((__unpacked)->blend_constant); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_RENDERER_STATE_unpack(__packed, __unpacked) \
do { \
   MALI_RENDERER_STATE_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[4] & 0xc000000) fprintf(stderr, "XXX: Invalid field of Renderer State unpacked at word 4\n"); \
   if (__tmp_packed.opaque[9] & 0x8000000) fprintf(stderr, "XXX: Invalid field of Renderer State unpacked at word 9\n"); \
   if (__tmp_packed.opaque[10] & 0xf0000000) fprintf(stderr, "XXX: Invalid field of Renderer State unpacked at word 10\n"); \
   if (__tmp_packed.opaque[11] & 0xf0000000) fprintf(stderr, "XXX: Invalid field of Renderer State unpacked at word 11\n"); \
   if (__tmp_packed.opaque[13] & 0xffff0000) fprintf(stderr, "XXX: Invalid field of Renderer State unpacked at word 13\n"); \
   __gen_unpack_uint((__unpacked)->shader.shader, &__tmp_packed.opaque[0], 0, 63); \
   __gen_unpack_uint((__unpacked)->shader.sampler_count, &__tmp_packed.opaque[0], 64, 79); \
   __gen_unpack_uint((__unpacked)->shader.texture_count, &__tmp_packed.opaque[0], 80, 95); \
   __gen_unpack_uint((__unpacked)->shader.attribute_count, &__tmp_packed.opaque[0], 96, 111); \
   __gen_unpack_uint((__unpacked)->shader.varying_count, &__tmp_packed.opaque[0], 112, 127); \
   __gen_unpack_uint((__unpacked)->properties.uniform_buffer_count, &__tmp_packed.opaque[0], 128, 135); \
   __gen_unpack_uint((__unpacked)->properties.depth_source, &__tmp_packed.opaque[0], 136, 137); \
   __gen_unpack_uint((__unpacked)->properties.shader_contains_barrier, &__tmp_packed.opaque[0], 139, 139); \
   __gen_unpack_uint((__unpacked)->properties.force_early_z, &__tmp_packed.opaque[0], 138, 138); \
   __gen_unpack_uint((__unpacked)->properties.shader_contains_discard, &__tmp_packed.opaque[0], 140, 140); \
   __gen_unpack_uint((__unpacked)->properties.shader_has_side_effects, &__tmp_packed.opaque[0], 141, 141); \
   __gen_unpack_uint((__unpacked)->properties.shader_reads_tilebuffer, &__tmp_packed.opaque[0], 142, 142); \
   __gen_unpack_uint((__unpacked)->properties.forward_pixel_kill, &__tmp_packed.opaque[0], 143, 143); \
   __gen_unpack_uint((__unpacked)->properties.work_register_count, &__tmp_packed.opaque[0], 144, 148); \
   __gen_unpack_uint((__unpacked)->properties.uniform_count, &__tmp_packed.opaque[0], 149, 153); \
   __gen_unpack_uint((__unpacked)->properties.stencil_from_shader, &__tmp_packed.opaque[0], 156, 156); \
   __gen_unpack_uint((__unpacked)->properties.fp_mode, &__tmp_packed.opaque[0], 157, 159); \
   __gen_unpack_float((__unpacked)->depth_units, &__tmp_packed.opaque[0], 160, 191); \
   __gen_unpack_float((__unpacked)->depth_factor, &__tmp_packed.opaque[0], 192, 223); \
   __gen_unpack_float((__unpacked)->depth_bias_clamp, &__tmp_packed.opaque[0], 224, 255); \
   __gen_unpack_uint((__unpacked)->multisample_misc.sample_mask, &__tmp_packed.opaque[0], 256, 271); \
   __gen_unpack_uint((__unpacked)->multisample_misc.multisample_enable, &__tmp_packed.opaque[0], 272, 272); \
   __gen_unpack_uint((__unpacked)->multisample_misc.multisample_late_coverage, &__tmp_packed.opaque[0], 273, 273); \
   __gen_unpack_uint((__unpacked)->multisample_misc.evaluate_per_sample, &__tmp_packed.opaque[0], 274, 274); \
   __gen_unpack_uint((__unpacked)->multisample_misc.fixed_function_depth_range_fixed, &__tmp_packed.opaque[0], 275, 275); \
   __gen_unpack_uint((__unpacked)->multisample_misc.shader_depth_range_fixed, &__tmp_packed.opaque[0], 276, 276); \
   __gen_unpack_uint((__unpacked)->multisample_misc.load_destination, &__tmp_packed.opaque[0], 277, 277); \
   __gen_unpack_uint((__unpacked)->multisample_misc.blend_shader, &__tmp_packed.opaque[0], 278, 278); \
   __gen_unpack_uint((__unpacked)->multisample_misc.blend_shader_discard, &__tmp_packed.opaque[0], 279, 279); \
   __gen_unpack_uint((__unpacked)->multisample_misc.depth_function, &__tmp_packed.opaque[0], 280, 282); \
   __gen_unpack_uint((__unpacked)->multisample_misc.depth_write_mask, &__tmp_packed.opaque[0], 283, 283); \
   __gen_unpack_uint((__unpacked)->multisample_misc.fixed_function_near_discard, &__tmp_packed.opaque[0], 284, 284); \
   __gen_unpack_uint((__unpacked)->multisample_misc.fixed_function_far_discard, &__tmp_packed.opaque[0], 285, 285); \
   __gen_unpack_uint((__unpacked)->multisample_misc.fragment_near_discard, &__tmp_packed.opaque[0], 286, 286); \
   __gen_unpack_uint((__unpacked)->multisample_misc.fragment_far_discard, &__tmp_packed.opaque[0], 287, 287); \
   __gen_unpack_uint((__unpacked)->stencil_mask_misc.stencil_mask_front, &__tmp_packed.opaque[0], 288, 295); \
   __gen_unpack_uint((__unpacked)->stencil_mask_misc.stencil_mask_back, &__tmp_packed.opaque[0], 296, 303); \
   __gen_unpack_uint((__unpacked)->stencil_mask_misc.stencil_enable, &__tmp_packed.opaque[0], 304, 304); \
   __gen_unpack_uint((__unpacked)->stencil_mask_misc.alpha_to_coverage, &__tmp_packed.opaque[0], 305, 305); \
   __gen_unpack_uint((__unpacked)->stencil_mask_misc.alpha_to_coverage_invert, &__tmp_packed.opaque[0], 306, 306); \
   __gen_unpack_uint((__unpacked)->stencil_mask_misc.alpha_to_one, &__tmp_packed.opaque[0], 307, 307); \
   __gen_unpack_uint((__unpacked)->stencil_mask_misc.write_enable, &__tmp_packed.opaque[0], 308, 308); \
   __gen_unpack_uint((__unpacked)->stencil_mask_misc.alpha_test_compare_function, &__tmp_packed.opaque[0], 309, 311); \
   __gen_unpack_uint((__unpacked)->stencil_mask_misc.srgb, &__tmp_packed.opaque[0], 312, 312); \
   __gen_unpack_uint((__unpacked)->stencil_mask_misc.dither_disable, &__tmp_packed.opaque[0], 313, 313); \
   __gen_unpack_uint((__unpacked)->stencil_mask_misc.force_seamless_cubemaps, &__tmp_packed.opaque[0], 314, 314); \
   __gen_unpack_uint((__unpacked)->stencil_mask_misc.front_facing_depth_bias, &__tmp_packed.opaque[0], 316, 316); \
   __gen_unpack_uint((__unpacked)->stencil_mask_misc.back_facing_depth_bias, &__tmp_packed.opaque[0], 317, 317); \
   __gen_unpack_uint((__unpacked)->stencil_mask_misc.aligned_line_ends, &__tmp_packed.opaque[0], 318, 318); \
   __gen_unpack_uint((__unpacked)->stencil_mask_misc.point_snap, &__tmp_packed.opaque[0], 319, 319); \
   __gen_unpack_uint((__unpacked)->stencil_front.reference_value, &__tmp_packed.opaque[0], 320, 327); \
   __gen_unpack_uint((__unpacked)->stencil_front.mask, &__tmp_packed.opaque[0], 328, 335); \
   __gen_unpack_uint((__unpacked)->stencil_front.compare_function, &__tmp_packed.opaque[0], 336, 338); \
   __gen_unpack_uint((__unpacked)->stencil_front.stencil_fail, &__tmp_packed.opaque[0], 339, 341); \
   __gen_unpack_uint((__unpacked)->stencil_front.depth_fail, &__tmp_packed.opaque[0], 342, 344); \
   __gen_unpack_uint((__unpacked)->stencil_front.depth_pass, &__tmp_packed.opaque[0], 345, 347); \
   __gen_unpack_uint((__unpacked)->stencil_back.reference_value, &__tmp_packed.opaque[0], 352, 359); \
   __gen_unpack_uint((__unpacked)->stencil_back.mask, &__tmp_packed.opaque[0], 360, 367); \
   __gen_unpack_uint((__unpacked)->stencil_back.compare_function, &__tmp_packed.opaque[0], 368, 370); \
   __gen_unpack_uint((__unpacked)->stencil_back.stencil_fail, &__tmp_packed.opaque[0], 371, 373); \
   __gen_unpack_uint((__unpacked)->stencil_back.depth_fail, &__tmp_packed.opaque[0], 374, 376); \
   __gen_unpack_uint((__unpacked)->stencil_back.depth_pass, &__tmp_packed.opaque[0], 377, 379); \
   __gen_unpack_float((__unpacked)->alpha_reference, &__tmp_packed.opaque[0], 384, 415); \
   __gen_unpack_uint((__unpacked)->thread_balancing, &__tmp_packed.opaque[0], 416, 431); \
   __gen_unpack_uint((__unpacked)->blend_shader, &__tmp_packed.opaque[0], 448, 511); \
   __gen_unpack_uint((__unpacked)->blend_equation.rgb.a, &__tmp_packed.opaque[0], 448, 449); \
   __gen_unpack_uint((__unpacked)->blend_equation.rgb.negate_a, &__tmp_packed.opaque[0], 451, 451); \
   __gen_unpack_uint((__unpacked)->blend_equation.rgb.b, &__tmp_packed.opaque[0], 452, 453); \
   __gen_unpack_uint((__unpacked)->blend_equation.rgb.negate_b, &__tmp_packed.opaque[0], 455, 455); \
   __gen_unpack_uint((__unpacked)->blend_equation.rgb.c, &__tmp_packed.opaque[0], 456, 458); \
   __gen_unpack_uint((__unpacked)->blend_equation.rgb.invert_c, &__tmp_packed.opaque[0], 459, 459); \
   __gen_unpack_uint((__unpacked)->blend_equation.alpha.a, &__tmp_packed.opaque[0], 460, 461); \
   __gen_unpack_uint((__unpacked)->blend_equation.alpha.negate_a, &__tmp_packed.opaque[0], 463, 463); \
   __gen_unpack_uint((__unpacked)->blend_equation.alpha.b, &__tmp_packed.opaque[0], 464, 465); \
   __gen_unpack_uint((__unpacked)->blend_equation.alpha.negate_b, &__tmp_packed.opaque[0], 467, 467); \
   __gen_unpack_uint((__unpacked)->blend_equation.alpha.c, &__tmp_packed.opaque[0], 468, 470); \
   __gen_unpack_uint((__unpacked)->blend_equation.alpha.invert_c, &__tmp_packed.opaque[0], 471, 471); \
   __gen_unpack_uint((__unpacked)->blend_equation.color_mask, &__tmp_packed.opaque[0], 476, 479); \
   __gen_unpack_float((__unpacked)->blend_constant, &__tmp_packed.opaque[0], 480, 511); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_RENDERER_STATE_print(FILE *fp, const struct MALI_RENDERER_STATE * values, unsigned indent)
{
   fprintf(fp, "%*sShader:\n", indent, "");
   MALI_SHADER_print(fp, &values->shader, indent + 2);
   fprintf(fp, "%*sProperties:\n", indent, "");
   MALI_RENDERER_PROPERTIES_print(fp, &values->properties, indent + 2);
   fprintf(fp, "%*sDepth units: %f\n", indent, "", values->depth_units);
   fprintf(fp, "%*sDepth factor: %f\n", indent, "", values->depth_factor);
   fprintf(fp, "%*sDepth bias clamp: %f\n", indent, "", values->depth_bias_clamp);
   fprintf(fp, "%*sMultisample, Misc:\n", indent, "");
   MALI_MULTISAMPLE_MISC_print(fp, &values->multisample_misc, indent + 2);
   fprintf(fp, "%*sStencil Mask, Misc:\n", indent, "");
   MALI_STENCIL_MASK_MISC_print(fp, &values->stencil_mask_misc, indent + 2);
   fprintf(fp, "%*sStencil front:\n", indent, "");
   MALI_STENCIL_print(fp, &values->stencil_front, indent + 2);
   fprintf(fp, "%*sStencil back:\n", indent, "");
   MALI_STENCIL_print(fp, &values->stencil_back, indent + 2);
   fprintf(fp, "%*sAlpha reference: %f\n", indent, "", values->alpha_reference);
   fprintf(fp, "%*sThread Balancing: %u\n", indent, "", values->thread_balancing);
   fprintf(fp, "%*sBlend Shader: 0x%" PRIx64 "\n", indent, "", values->blend_shader);
   fprintf(fp, "%*sBlend Equation:\n", indent, "");
   MALI_BLEND_EQUATION_print(fp, &values->blend_equation, indent + 2);
   fprintf(fp, "%*sBlend Constant: %f\n", indent, "", values->blend_constant);
}

#endif
struct MALI_UNIFORM_BUFFER {
   uint32_t                             entries;
   uint64_t                             pointer;
};

#define MALI_UNIFORM_BUFFER_header              \
   0

#define MALI_UNIFORM_BUFFER_LENGTH 8
#define MALI_UNIFORM_BUFFER_ALIGN 8
struct mali_uniform_buffer_packed { uint32_t opaque[2]; };
#define MALI_UNIFORM_BUFFER_PACKED_T struct mali_uniform_buffer_packed
#define MALI_UNIFORM_BUFFER_pack(__packed, __unpacked) \
do { \
   MALI_UNIFORM_BUFFER_PACKED_T __tmp_packed; \
   assert((__unpacked)->entries >= 1); \
   assert(((__unpacked)->pointer & 0xf) == 0); \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->entries - 1, 0, 11) | \
            util_bitpack_uint((__unpacked)->pointer >> 4, 12, 63); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->pointer >> 4, 12, 63) >> 32; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_UNIFORM_BUFFER_unpack(__packed, __unpacked) \
do { \
   MALI_UNIFORM_BUFFER_PACKED_T __tmp_packed = *(__packed); \
   __gen_unpack_uint((__unpacked)->entries, &__tmp_packed.opaque[0], 0, 11); \
   (__unpacked)->entries = (__unpacked)->entries + 1; \
   __gen_unpack_uint((__unpacked)->pointer, &__tmp_packed.opaque[0], 12, 63); \
   (__unpacked)->pointer = (__unpacked)->pointer << 4; \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_UNIFORM_BUFFER_print(FILE *fp, const struct MALI_UNIFORM_BUFFER * values, unsigned indent)
{
   fprintf(fp, "%*sEntries: %u\n", indent, "", values->entries);
   fprintf(fp, "%*sPointer: 0x%" PRIx64 "\n", indent, "", values->pointer);
}

#endif
struct MALI_VIEWPORT {
   float                                minimum_x;
   float                                minimum_y;
   float                                maximum_x;
   float                                maximum_y;
   float                                minimum_z;
   float                                maximum_z;
   uint32_t                             scissor_minimum_x;
   uint32_t                             scissor_minimum_y;
   uint32_t                             scissor_maximum_x;
   uint32_t                             scissor_maximum_y;
};

#define MALI_VIEWPORT_header                    \
   .minimum_x = -INFINITY,  \
   .minimum_y = -INFINITY,  \
   .maximum_x = +INFINITY,  \
   .maximum_y = +INFINITY,  \
   .minimum_z = 0.0,  \
   .maximum_z = 1.0,  \
   .scissor_minimum_x = 0,  \
   .scissor_minimum_y = 0

#define MALI_VIEWPORT_LENGTH 32
#define MALI_VIEWPORT_ALIGN 32
struct mali_viewport_packed { uint32_t opaque[8]; };
#define MALI_VIEWPORT_PACKED_T struct mali_viewport_packed
#define MALI_VIEWPORT_pack(__packed, __unpacked) \
do { \
   MALI_VIEWPORT_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_float((__unpacked)->minimum_x); \
   __tmp_packed.opaque[ 1] = util_bitpack_float((__unpacked)->minimum_y); \
   __tmp_packed.opaque[ 2] = util_bitpack_float((__unpacked)->maximum_x); \
   __tmp_packed.opaque[ 3] = util_bitpack_float((__unpacked)->maximum_y); \
   __tmp_packed.opaque[ 4] = util_bitpack_float((__unpacked)->minimum_z); \
   __tmp_packed.opaque[ 5] = util_bitpack_float((__unpacked)->maximum_z); \
   __tmp_packed.opaque[ 6] = util_bitpack_uint((__unpacked)->scissor_minimum_x, 0, 15) | \
            util_bitpack_uint((__unpacked)->scissor_minimum_y, 16, 31); \
   __tmp_packed.opaque[ 7] = util_bitpack_uint((__unpacked)->scissor_maximum_x, 0, 15) | \
            util_bitpack_uint((__unpacked)->scissor_maximum_y, 16, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_VIEWPORT_unpack(__packed, __unpacked) \
do { \
   MALI_VIEWPORT_PACKED_T __tmp_packed = *(__packed); \
   __gen_unpack_float((__unpacked)->minimum_x, &__tmp_packed.opaque[0], 0, 31); \
   __gen_unpack_float((__unpacked)->minimum_y, &__tmp_packed.opaque[0], 32, 63); \
   __gen_unpack_float((__unpacked)->maximum_x, &__tmp_packed.opaque[0], 64, 95); \
   __gen_unpack_float((__unpacked)->maximum_y, &__tmp_packed.opaque[0], 96, 127); \
   __gen_unpack_float((__unpacked)->minimum_z, &__tmp_packed.opaque[0], 128, 159); \
   __gen_unpack_float((__unpacked)->maximum_z, &__tmp_packed.opaque[0], 160, 191); \
   __gen_unpack_uint((__unpacked)->scissor_minimum_x, &__tmp_packed.opaque[0], 192, 207); \
   __gen_unpack_uint((__unpacked)->scissor_minimum_y, &__tmp_packed.opaque[0], 208, 223); \
   __gen_unpack_uint((__unpacked)->scissor_maximum_x, &__tmp_packed.opaque[0], 224, 239); \
   __gen_unpack_uint((__unpacked)->scissor_maximum_y, &__tmp_packed.opaque[0], 240, 255); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_VIEWPORT_print(FILE *fp, const struct MALI_VIEWPORT * values, unsigned indent)
{
   fprintf(fp, "%*sMinimum X: %f\n", indent, "", values->minimum_x);
   fprintf(fp, "%*sMinimum Y: %f\n", indent, "", values->minimum_y);
   fprintf(fp, "%*sMaximum X: %f\n", indent, "", values->maximum_x);
   fprintf(fp, "%*sMaximum Y: %f\n", indent, "", values->maximum_y);
   fprintf(fp, "%*sMinimum Z: %f\n", indent, "", values->minimum_z);
   fprintf(fp, "%*sMaximum Z: %f\n", indent, "", values->maximum_z);
   fprintf(fp, "%*sScissor Minimum X: %u\n", indent, "", values->scissor_minimum_x);
   fprintf(fp, "%*sScissor Minimum Y: %u\n", indent, "", values->scissor_minimum_y);
   fprintf(fp, "%*sScissor Maximum X: %u\n", indent, "", values->scissor_maximum_x);
   fprintf(fp, "%*sScissor Maximum Y: %u\n", indent, "", values->scissor_maximum_y);
}

#endif
struct MALI_LOCAL_STORAGE {
   uint32_t                             tls_size;
   uint32_t                             tls_initial_stack_pointer_offset;
   uint32_t                             wls_instances;
#define MALI_LOCAL_STORAGE_NO_WORKGROUP_MEM      2147483648
   uint32_t                             wls_size_base;
   uint32_t                             wls_size_scale;
   uint64_t                             tls_base_pointer;
   uint64_t                             wls_base_pointer;
};

#define MALI_LOCAL_STORAGE_header               \
   .wls_instances = MALI_LOCAL_STORAGE_NO_WORKGROUP_MEM

#define MALI_LOCAL_STORAGE_LENGTH 32
#define MALI_LOCAL_STORAGE_ALIGN 64
struct mali_local_storage_packed { uint32_t opaque[8]; };
#define MALI_LOCAL_STORAGE_PACKED_T struct mali_local_storage_packed
#define MALI_LOCAL_STORAGE_pack(__packed, __unpacked) \
do { \
   MALI_LOCAL_STORAGE_PACKED_T __tmp_packed; \
   assert(IS_POT_NONZERO((__unpacked)->wls_instances)); \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->tls_size, 0, 4) | \
            util_bitpack_uint((__unpacked)->tls_initial_stack_pointer_offset, 5, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint(util_logbase2((__unpacked)->wls_instances), 0, 4) | \
            util_bitpack_uint((__unpacked)->wls_size_base, 5, 6) | \
            util_bitpack_uint((__unpacked)->wls_size_scale, 8, 12); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->tls_base_pointer, 0, 63); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->tls_base_pointer, 0, 63) >> 32; \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->wls_base_pointer, 0, 63); \
   __tmp_packed.opaque[ 5] = util_bitpack_uint((__unpacked)->wls_base_pointer, 0, 63) >> 32; \
   __tmp_packed.opaque[ 6] = 0; \
   __tmp_packed.opaque[ 7] = 0; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_LOCAL_STORAGE_unpack(__packed, __unpacked) \
do { \
   MALI_LOCAL_STORAGE_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[1] & 0xffffe080) fprintf(stderr, "XXX: Invalid field of Local Storage unpacked at word 1\n"); \
   if (__tmp_packed.opaque[6] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Local Storage unpacked at word 6\n"); \
   if (__tmp_packed.opaque[7] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Local Storage unpacked at word 7\n"); \
   __gen_unpack_uint((__unpacked)->tls_size, &__tmp_packed.opaque[0], 0, 4); \
   __gen_unpack_uint((__unpacked)->tls_initial_stack_pointer_offset, &__tmp_packed.opaque[0], 5, 31); \
   __gen_unpack_uint((__unpacked)->wls_instances, &__tmp_packed.opaque[0], 32, 36); \
   (__unpacked)->wls_instances = 1U << (__unpacked)->wls_instances; \
   __gen_unpack_uint((__unpacked)->wls_size_base, &__tmp_packed.opaque[0], 37, 38); \
   __gen_unpack_uint((__unpacked)->wls_size_scale, &__tmp_packed.opaque[0], 40, 44); \
   __gen_unpack_uint((__unpacked)->tls_base_pointer, &__tmp_packed.opaque[0], 64, 127); \
   __gen_unpack_uint((__unpacked)->wls_base_pointer, &__tmp_packed.opaque[0], 128, 191); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_LOCAL_STORAGE_print(FILE *fp, const struct MALI_LOCAL_STORAGE * values, unsigned indent)
{
   fprintf(fp, "%*sTLS Size: %u\n", indent, "", values->tls_size);
   fprintf(fp, "%*sTLS Initial Stack Pointer Offset: %u\n", indent, "", values->tls_initial_stack_pointer_offset);
   fprintf(fp, "%*sWLS Instances: %u\n", indent, "", values->wls_instances);
   fprintf(fp, "%*sWLS Size Base: %u\n", indent, "", values->wls_size_base);
   fprintf(fp, "%*sWLS Size Scale: %u\n", indent, "", values->wls_size_scale);
   fprintf(fp, "%*sTLS Base Pointer: 0x%" PRIx64 "\n", indent, "", values->tls_base_pointer);
   fprintf(fp, "%*sWLS Base Pointer: 0x%" PRIx64 "\n", indent, "", values->wls_base_pointer);
}

#endif
struct MALI_TILER_CONTEXT {
   uint64_t                             polygon_list_size;
#define MALI_MIDGARD_TILER_MINIMUM_HEADER_SIZE   512
   uint32_t                             hierarchy_mask;
#define MALI_MIDGARD_TILER_DISABLED              4096
#define MALI_MIDGARD_TILER_USER                  4095
#define MALI_MIDGARD_TILER_HIERARCHY_MASK        511
   uint64_t                             polygon_list;
   uint64_t                             polygon_list_body;
   uint64_t                             heap_start;
   uint64_t                             heap_end;
};

#define MALI_TILER_CONTEXT_header               \
   0

#define MALI_TILER_CONTEXT_LENGTH 40
struct mali_tiler_context_packed { uint32_t opaque[10]; };
#define MALI_TILER_CONTEXT_PACKED_T struct mali_tiler_context_packed
#define MALI_TILER_CONTEXT_pack(__packed, __unpacked) \
do { \
   MALI_TILER_CONTEXT_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->polygon_list_size, 0, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->hierarchy_mask, 0, 15); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->polygon_list, 0, 63); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->polygon_list, 0, 63) >> 32; \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->polygon_list_body, 0, 63); \
   __tmp_packed.opaque[ 5] = util_bitpack_uint((__unpacked)->polygon_list_body, 0, 63) >> 32; \
   __tmp_packed.opaque[ 6] = util_bitpack_uint((__unpacked)->heap_start, 0, 63); \
   __tmp_packed.opaque[ 7] = util_bitpack_uint((__unpacked)->heap_start, 0, 63) >> 32; \
   __tmp_packed.opaque[ 8] = util_bitpack_uint((__unpacked)->heap_end, 0, 63); \
   __tmp_packed.opaque[ 9] = util_bitpack_uint((__unpacked)->heap_end, 0, 63) >> 32; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_TILER_CONTEXT_unpack(__packed, __unpacked) \
do { \
   MALI_TILER_CONTEXT_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[1] & 0xffff0000) fprintf(stderr, "XXX: Invalid field of Tiler Context unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->polygon_list_size, &__tmp_packed.opaque[0], 0, 31); \
   __gen_unpack_uint((__unpacked)->hierarchy_mask, &__tmp_packed.opaque[0], 32, 47); \
   __gen_unpack_uint((__unpacked)->polygon_list, &__tmp_packed.opaque[0], 64, 127); \
   __gen_unpack_uint((__unpacked)->polygon_list_body, &__tmp_packed.opaque[0], 128, 191); \
   __gen_unpack_uint((__unpacked)->heap_start, &__tmp_packed.opaque[0], 192, 255); \
   __gen_unpack_uint((__unpacked)->heap_end, &__tmp_packed.opaque[0], 256, 319); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_TILER_CONTEXT_print(FILE *fp, const struct MALI_TILER_CONTEXT * values, unsigned indent)
{
   fprintf(fp, "%*sPolygon List Size: 0x%" PRIx64 "\n", indent, "", values->polygon_list_size);
   fprintf(fp, "%*sHierarchy Mask: %u\n", indent, "", values->hierarchy_mask);
   fprintf(fp, "%*sPolygon List: 0x%" PRIx64 "\n", indent, "", values->polygon_list);
   fprintf(fp, "%*sPolygon List Body: 0x%" PRIx64 "\n", indent, "", values->polygon_list_body);
   fprintf(fp, "%*sHeap Start: 0x%" PRIx64 "\n", indent, "", values->heap_start);
   fprintf(fp, "%*sHeap End: 0x%" PRIx64 "\n", indent, "", values->heap_end);
}

#endif
struct MALI_TILER_WEIGHTS {
   uint64_t                             weight0;
   uint64_t                             weight1;
   uint64_t                             weight2;
   uint64_t                             weight3;
   uint64_t                             weight4;
   uint64_t                             weight5;
   uint64_t                             weight6;
   uint64_t                             weight7;
};

#define MALI_TILER_WEIGHTS_header               \
   0

#define MALI_TILER_WEIGHTS_LENGTH 32
struct mali_tiler_weights_packed { uint32_t opaque[8]; };
#define MALI_TILER_WEIGHTS_PACKED_T struct mali_tiler_weights_packed
#define MALI_TILER_WEIGHTS_pack(__packed, __unpacked) \
do { \
   MALI_TILER_WEIGHTS_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->weight0, 0, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->weight1, 0, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->weight2, 0, 31); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->weight3, 0, 31); \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->weight4, 0, 31); \
   __tmp_packed.opaque[ 5] = util_bitpack_uint((__unpacked)->weight5, 0, 31); \
   __tmp_packed.opaque[ 6] = util_bitpack_uint((__unpacked)->weight6, 0, 31); \
   __tmp_packed.opaque[ 7] = util_bitpack_uint((__unpacked)->weight7, 0, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_TILER_WEIGHTS_unpack(__packed, __unpacked) \
do { \
   MALI_TILER_WEIGHTS_PACKED_T __tmp_packed = *(__packed); \
   __gen_unpack_uint((__unpacked)->weight0, &__tmp_packed.opaque[0], 0, 31); \
   __gen_unpack_uint((__unpacked)->weight1, &__tmp_packed.opaque[0], 32, 63); \
   __gen_unpack_uint((__unpacked)->weight2, &__tmp_packed.opaque[0], 64, 95); \
   __gen_unpack_uint((__unpacked)->weight3, &__tmp_packed.opaque[0], 96, 127); \
   __gen_unpack_uint((__unpacked)->weight4, &__tmp_packed.opaque[0], 128, 159); \
   __gen_unpack_uint((__unpacked)->weight5, &__tmp_packed.opaque[0], 160, 191); \
   __gen_unpack_uint((__unpacked)->weight6, &__tmp_packed.opaque[0], 192, 223); \
   __gen_unpack_uint((__unpacked)->weight7, &__tmp_packed.opaque[0], 224, 255); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_TILER_WEIGHTS_print(FILE *fp, const struct MALI_TILER_WEIGHTS * values, unsigned indent)
{
   fprintf(fp, "%*sWeight0: 0x%" PRIx64 "\n", indent, "", values->weight0);
   fprintf(fp, "%*sWeight1: 0x%" PRIx64 "\n", indent, "", values->weight1);
   fprintf(fp, "%*sWeight2: 0x%" PRIx64 "\n", indent, "", values->weight2);
   fprintf(fp, "%*sWeight3: 0x%" PRIx64 "\n", indent, "", values->weight3);
   fprintf(fp, "%*sWeight4: 0x%" PRIx64 "\n", indent, "", values->weight4);
   fprintf(fp, "%*sWeight5: 0x%" PRIx64 "\n", indent, "", values->weight5);
   fprintf(fp, "%*sWeight6: 0x%" PRIx64 "\n", indent, "", values->weight6);
   fprintf(fp, "%*sWeight7: 0x%" PRIx64 "\n", indent, "", values->weight7);
}

#endif
enum mali_color_buffer_internal_format {
        MALI_COLOR_BUFFER_INTERNAL_FORMAT_RAW_VALUE =      0,
        MALI_COLOR_BUFFER_INTERNAL_FORMAT_R8G8B8A8 =      1,
        MALI_COLOR_BUFFER_INTERNAL_FORMAT_R10G10B10A2 =      2,
        MALI_COLOR_BUFFER_INTERNAL_FORMAT_R8G8B8A2 =      3,
        MALI_COLOR_BUFFER_INTERNAL_FORMAT_R4G4B4A4 =      4,
        MALI_COLOR_BUFFER_INTERNAL_FORMAT_R5G6B5A0 =      5,
        MALI_COLOR_BUFFER_INTERNAL_FORMAT_R5G5B5A1 =      6,
        MALI_COLOR_BUFFER_INTERNAL_FORMAT_RAW8 =     32,
        MALI_COLOR_BUFFER_INTERNAL_FORMAT_RAW16 =     33,
        MALI_COLOR_BUFFER_INTERNAL_FORMAT_RAW32 =     34,
        MALI_COLOR_BUFFER_INTERNAL_FORMAT_RAW64 =     35,
        MALI_COLOR_BUFFER_INTERNAL_FORMAT_RAW128 =     36,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_color_buffer_internal_format_as_str(enum mali_color_buffer_internal_format imm)
{
    switch (imm) {
    case MALI_COLOR_BUFFER_INTERNAL_FORMAT_RAW_VALUE: return "Raw Value";
    case MALI_COLOR_BUFFER_INTERNAL_FORMAT_R8G8B8A8: return "R8G8B8A8";
    case MALI_COLOR_BUFFER_INTERNAL_FORMAT_R10G10B10A2: return "R10G10B10A2";
    case MALI_COLOR_BUFFER_INTERNAL_FORMAT_R8G8B8A2: return "R8G8B8A2";
    case MALI_COLOR_BUFFER_INTERNAL_FORMAT_R4G4B4A4: return "R4G4B4A4";
    case MALI_COLOR_BUFFER_INTERNAL_FORMAT_R5G6B5A0: return "R5G6B5A0";
    case MALI_COLOR_BUFFER_INTERNAL_FORMAT_R5G5B5A1: return "R5G5B5A1";
    case MALI_COLOR_BUFFER_INTERNAL_FORMAT_RAW8: return "RAW8";
    case MALI_COLOR_BUFFER_INTERNAL_FORMAT_RAW16: return "RAW16";
    case MALI_COLOR_BUFFER_INTERNAL_FORMAT_RAW32: return "RAW32";
    case MALI_COLOR_BUFFER_INTERNAL_FORMAT_RAW64: return "RAW64";
    case MALI_COLOR_BUFFER_INTERNAL_FORMAT_RAW128: return "RAW128";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_color_format {
        MALI_COLOR_FORMAT_4_32B_CHANNELS     =      0,
        MALI_COLOR_FORMAT_3_32B_CHANNELS     =      1,
        MALI_COLOR_FORMAT_2_32B_CHANNELS     =      2,
        MALI_COLOR_FORMAT_1_32B_CHANNEL      =      3,
        MALI_COLOR_FORMAT_4_16B_CHANNELS     =      4,
        MALI_COLOR_FORMAT_3_16B_CHANNELS     =      5,
        MALI_COLOR_FORMAT_2_16B_CHANNELS     =      6,
        MALI_COLOR_FORMAT_1_16B_CHANNEL      =      7,
        MALI_COLOR_FORMAT_R8                 =     16,
        MALI_COLOR_FORMAT_R8G8               =     17,
        MALI_COLOR_FORMAT_R8G8B8             =     18,
        MALI_COLOR_FORMAT_R8G8B8A8           =     19,
        MALI_COLOR_FORMAT_R4G4B4A4           =     20,
        MALI_COLOR_FORMAT_R5G6B5             =     21,
        MALI_COLOR_FORMAT_R8G8B8_FROM_R8G8B8A2 =     22,
        MALI_COLOR_FORMAT_R10G10B10A2        =     24,
        MALI_COLOR_FORMAT_A2B10G10R10        =     25,
        MALI_COLOR_FORMAT_R5G5B5A1           =     28,
        MALI_COLOR_FORMAT_A1B5G5R5           =     29,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_color_format_as_str(enum mali_color_format imm)
{
    switch (imm) {
    case MALI_COLOR_FORMAT_4_32B_CHANNELS: return "4_32B_CHANNELS";
    case MALI_COLOR_FORMAT_3_32B_CHANNELS: return "3_32B_CHANNELS";
    case MALI_COLOR_FORMAT_2_32B_CHANNELS: return "2_32B_CHANNELS";
    case MALI_COLOR_FORMAT_1_32B_CHANNEL: return "1_32B_CHANNEL";
    case MALI_COLOR_FORMAT_4_16B_CHANNELS: return "4_16B_CHANNELS";
    case MALI_COLOR_FORMAT_3_16B_CHANNELS: return "3_16B_CHANNELS";
    case MALI_COLOR_FORMAT_2_16B_CHANNELS: return "2_16B_CHANNELS";
    case MALI_COLOR_FORMAT_1_16B_CHANNEL: return "1_16B_CHANNEL";
    case MALI_COLOR_FORMAT_R8: return "R8";
    case MALI_COLOR_FORMAT_R8G8: return "R8G8";
    case MALI_COLOR_FORMAT_R8G8B8: return "R8G8B8";
    case MALI_COLOR_FORMAT_R8G8B8A8: return "R8G8B8A8";
    case MALI_COLOR_FORMAT_R4G4B4A4: return "R4G4B4A4";
    case MALI_COLOR_FORMAT_R5G6B5: return "R5G6B5";
    case MALI_COLOR_FORMAT_R8G8B8_FROM_R8G8B8A2: return "R8G8B8_FROM_R8G8B8A2";
    case MALI_COLOR_FORMAT_R10G10B10A2: return "R10G10B10A2";
    case MALI_COLOR_FORMAT_A2B10G10R10: return "A2B10G10R10";
    case MALI_COLOR_FORMAT_R5G5B5A1: return "R5G5B5A1";
    case MALI_COLOR_FORMAT_A1B5G5R5: return "A1B5G5R5";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_downsampling_accumulation_mode {
        MALI_DOWNSAMPLING_ACCUMULATION_MODE_UNSIGNED_NORMALIZED_INTEGER =      0,
        MALI_DOWNSAMPLING_ACCUMULATION_MODE_SIGNED_NORMALIZED_INTEGER =      1,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_downsampling_accumulation_mode_as_str(enum mali_downsampling_accumulation_mode imm)
{
    switch (imm) {
    case MALI_DOWNSAMPLING_ACCUMULATION_MODE_UNSIGNED_NORMALIZED_INTEGER: return "Unsigned normalized integer";
    case MALI_DOWNSAMPLING_ACCUMULATION_MODE_SIGNED_NORMALIZED_INTEGER: return "Signed normalized integer";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_sample_layout {
        MALI_SAMPLE_LAYOUT_ORDERED_4X_GRID   =      0,
        MALI_SAMPLE_LAYOUT_ROTATED_4X_GRID   =      1,
        MALI_SAMPLE_LAYOUT_D3D_8X_GRID       =      2,
        MALI_SAMPLE_LAYOUT_D3D_16X_GRID      =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_sample_layout_as_str(enum mali_sample_layout imm)
{
    switch (imm) {
    case MALI_SAMPLE_LAYOUT_ORDERED_4X_GRID: return "Ordered 4x Grid";
    case MALI_SAMPLE_LAYOUT_ROTATED_4X_GRID: return "Rotated 4x Grid";
    case MALI_SAMPLE_LAYOUT_D3D_8X_GRID: return "D3D 8x Grid";
    case MALI_SAMPLE_LAYOUT_D3D_16X_GRID: return "D3D 16x Grid";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_zs_format {
        MALI_ZS_FORMAT_D16                   =      1,
        MALI_ZS_FORMAT_D24                   =      2,
        MALI_ZS_FORMAT_D24X8                 =      4,
        MALI_ZS_FORMAT_D24S8                 =      5,
        MALI_ZS_FORMAT_X8D24                 =      6,
        MALI_ZS_FORMAT_S8D24                 =      7,
        MALI_ZS_FORMAT_D32                   =     14,
        MALI_ZS_FORMAT_D32_S8X24             =     15,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_zs_format_as_str(enum mali_zs_format imm)
{
    switch (imm) {
    case MALI_ZS_FORMAT_D16: return "D16";
    case MALI_ZS_FORMAT_D24: return "D24";
    case MALI_ZS_FORMAT_D24X8: return "D24X8";
    case MALI_ZS_FORMAT_D24S8: return "D24S8";
    case MALI_ZS_FORMAT_X8D24: return "X8D24";
    case MALI_ZS_FORMAT_S8D24: return "S8D24";
    case MALI_ZS_FORMAT_D32: return "D32";
    case MALI_ZS_FORMAT_D32_S8X24: return "D32_S8X24";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_zs_preload_format {
        MALI_ZS_PRELOAD_FORMAT_D32_S8X24     =      4,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_zs_preload_format_as_str(enum mali_zs_preload_format imm)
{
    switch (imm) {
    case MALI_ZS_PRELOAD_FORMAT_D32_S8X24: return "D32_S8X24";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_s_format {
        MALI_S_FORMAT_S8                     =      1,
        MALI_S_FORMAT_S8X8                   =      2,
        MALI_S_FORMAT_S8X24                  =      3,
        MALI_S_FORMAT_X24S8                  =      4,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_s_format_as_str(enum mali_s_format imm)
{
    switch (imm) {
    case MALI_S_FORMAT_S8: return "S8";
    case MALI_S_FORMAT_S8X8: return "S8X8";
    case MALI_S_FORMAT_S8X24: return "S8X24";
    case MALI_S_FORMAT_X24S8: return "X24S8";
    default: return "XXX: INVALID";
    }
}

#endif

enum mali_tie_break_rule {
        MALI_TIE_BREAK_RULE_0_IN_180_OUT     =      0,
        MALI_TIE_BREAK_RULE_0_OUT_180_IN     =      1,
        MALI_TIE_BREAK_RULE_MINUS_180_IN_0_OUT =      2,
        MALI_TIE_BREAK_RULE_MINUS_180_OUT_0_IN =      3,
        MALI_TIE_BREAK_RULE_90_IN_270_OUT    =      4,
        MALI_TIE_BREAK_RULE_90_OUT_270_IN    =      5,
        MALI_TIE_BREAK_RULE_MINUS_90_IN_90_OUT =      6,
        MALI_TIE_BREAK_RULE_MINUS_90_OUT_90_IN =      7,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_tie_break_rule_as_str(enum mali_tie_break_rule imm)
{
    switch (imm) {
    case MALI_TIE_BREAK_RULE_0_IN_180_OUT: return "0_IN_180_OUT";
    case MALI_TIE_BREAK_RULE_0_OUT_180_IN: return "0_OUT_180_IN";
    case MALI_TIE_BREAK_RULE_MINUS_180_IN_0_OUT: return "MINUS_180_IN_0_OUT";
    case MALI_TIE_BREAK_RULE_MINUS_180_OUT_0_IN: return "MINUS_180_OUT_0_IN";
    case MALI_TIE_BREAK_RULE_90_IN_270_OUT: return "90_IN_270_OUT";
    case MALI_TIE_BREAK_RULE_90_OUT_270_IN: return "90_OUT_270_IN";
    case MALI_TIE_BREAK_RULE_MINUS_90_IN_90_OUT: return "MINUS_90_IN_90_OUT";
    case MALI_TIE_BREAK_RULE_MINUS_90_OUT_90_IN: return "MINUS_90_OUT_90_IN";
    default: return "XXX: INVALID";
    }
}

#endif

struct MALI_RT_BUFFER {
   uint64_t                             base;
   uint64_t                             row_stride;
   uint64_t                             surface_stride;
};

#define MALI_RT_BUFFER_header                   \
   0

#define MALI_RT_BUFFER_LENGTH 16
struct mali_rt_buffer_packed { uint32_t opaque[4]; };
#define MALI_RT_BUFFER_PACKED_T struct mali_rt_buffer_packed
#define MALI_RT_BUFFER_pack(__packed, __unpacked) \
do { \
   MALI_RT_BUFFER_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->base, 0, 63); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->base, 0, 63) >> 32; \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->row_stride, 0, 31); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->surface_stride, 0, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_RT_BUFFER_unpack(__packed, __unpacked) \
do { \
   MALI_RT_BUFFER_PACKED_T __tmp_packed = *(__packed); \
   __gen_unpack_uint((__unpacked)->base, &__tmp_packed.opaque[0], 0, 63); \
   __gen_unpack_uint((__unpacked)->row_stride, &__tmp_packed.opaque[0], 64, 95); \
   __gen_unpack_uint((__unpacked)->surface_stride, &__tmp_packed.opaque[0], 96, 127); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_RT_BUFFER_print(FILE *fp, const struct MALI_RT_BUFFER * values, unsigned indent)
{
   fprintf(fp, "%*sBase: 0x%" PRIx64 "\n", indent, "", values->base);
   fprintf(fp, "%*sRow Stride: 0x%" PRIx64 "\n", indent, "", values->row_stride);
   fprintf(fp, "%*sSurface Stride: 0x%" PRIx64 "\n", indent, "", values->surface_stride);
}

#endif
struct MALI_FRAMEBUFFER_PARAMETERS {
   enum mali_color_buffer_internal_format internal_format;
   uint32_t                             sample_count;
   uint32_t                             swizzle;
   enum mali_color_format               color_writeback_format;
   enum mali_msaa                       msaa;
   bool                                 srgb;
   enum mali_block_format               color_block_format;
   bool                                 dithering_enable;
   bool                                 clean_pixel_write_enable;
   bool                                 color_preload_enable;
   bool                                 color_write_enable;
   uint32_t                             x_downsampling_scale;
   uint32_t                             y_downsampling_scale;
   enum mali_downsampling_accumulation_mode downsampling_accumulation_mode;
   enum mali_sample_layout              sample_layout;
   bool                                 big_endian;
   enum mali_tie_break_rule             tie_break_rule;
   bool                                 crc_read_enable;
   bool                                 crc_write_enable;
   enum mali_block_format               zs_block_format;
   enum mali_zs_format                  zs_format;
   bool                                 zs_preload_enable;
   bool                                 zs_write_enable;
   enum mali_block_format               s_block_format;
   enum mali_s_format                   s_format;
   bool                                 s_write_enable;
   uint32_t                             bound_min_x;
   uint32_t                             bound_min_y;
   uint32_t                             bound_max_x;
   uint32_t                             bound_max_y;
   uint64_t                             dcd_offset;
   struct MALI_RT_BUFFER                crc_buffer;
   struct MALI_RT_BUFFER                color_writeback;
   struct MALI_RT_BUFFER                zs_writeback;
   struct MALI_RT_BUFFER                s_writeback;
   uint64_t                             color_load_address;
   uint64_t                             color_load_row_stride;
   uint64_t                             color_load_surface_stride;
   uint64_t                             clear_color_0;
   uint64_t                             clear_color_1;
   uint64_t                             clear_color_2;
   uint64_t                             clear_color_3;
   uint64_t                             zs_load_address;
   uint64_t                             zs_load_row_stride;
   uint64_t                             zs_load_surface_stride;
   float                                z_clear;
   uint32_t                             s_clear;
};

#define MALI_FRAMEBUFFER_PARAMETERS_header      \
   .internal_format = MALI_COLOR_BUFFER_INTERNAL_FORMAT_RAW_VALUE,  \
   .sample_count = 1,  \
   .color_writeback_format = MALI_COLOR_FORMAT_4_32B_CHANNELS,  \
   .msaa = MALI_MSAA_SINGLE,  \
   .zs_format = MALI_ZS_FORMAT_D24S8,  \
   .crc_buffer = { MALI_RT_BUFFER_header },  \
   .color_writeback = { MALI_RT_BUFFER_header },  \
   .zs_writeback = { MALI_RT_BUFFER_header },  \
   .s_writeback = { MALI_RT_BUFFER_header }

#define MALI_FRAMEBUFFER_PARAMETERS_LENGTH 160
struct mali_framebuffer_parameters_packed { uint32_t opaque[40]; };
#define MALI_FRAMEBUFFER_PARAMETERS_PACKED_T struct mali_framebuffer_parameters_packed
#define MALI_FRAMEBUFFER_PARAMETERS_pack(__packed, __unpacked) \
do { \
   MALI_FRAMEBUFFER_PARAMETERS_PACKED_T __tmp_packed; \
   assert(IS_POT_NONZERO((__unpacked)->sample_count)); \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->internal_format, 0, 2) | \
            util_bitpack_uint(util_logbase2((__unpacked)->sample_count), 3, 5) | \
            util_bitpack_uint((__unpacked)->swizzle, 6, 17) | \
            util_bitpack_uint((__unpacked)->color_writeback_format, 18, 22) | \
            util_bitpack_uint((__unpacked)->msaa, 23, 24) | \
            util_bitpack_uint((__unpacked)->srgb, 25, 25) | \
            util_bitpack_uint((__unpacked)->color_block_format, 26, 27) | \
            util_bitpack_uint((__unpacked)->dithering_enable, 28, 28) | \
            util_bitpack_uint((__unpacked)->clean_pixel_write_enable, 29, 29) | \
            util_bitpack_uint((__unpacked)->color_preload_enable, 30, 30) | \
            util_bitpack_uint((__unpacked)->color_write_enable, 31, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->x_downsampling_scale, 0, 2) | \
            util_bitpack_uint((__unpacked)->y_downsampling_scale, 3, 5) | \
            util_bitpack_uint((__unpacked)->downsampling_accumulation_mode, 6, 7) | \
            util_bitpack_uint((__unpacked)->sample_layout, 8, 9) | \
            util_bitpack_uint((__unpacked)->big_endian, 10, 10) | \
            util_bitpack_uint((__unpacked)->tie_break_rule, 11, 13) | \
            util_bitpack_uint((__unpacked)->crc_read_enable, 14, 14) | \
            util_bitpack_uint((__unpacked)->crc_write_enable, 15, 15) | \
            util_bitpack_uint((__unpacked)->zs_block_format, 16, 17) | \
            util_bitpack_uint((__unpacked)->zs_format, 18, 21) | \
            util_bitpack_uint((__unpacked)->zs_preload_enable, 22, 22) | \
            util_bitpack_uint((__unpacked)->zs_write_enable, 23, 23) | \
            util_bitpack_uint((__unpacked)->s_block_format, 24, 25) | \
            util_bitpack_uint((__unpacked)->s_format, 26, 29) | \
            util_bitpack_uint((__unpacked)->s_write_enable, 31, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->bound_min_x, 0, 15) | \
            util_bitpack_uint((__unpacked)->bound_min_y, 16, 31); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->bound_max_x, 0, 15) | \
            util_bitpack_uint((__unpacked)->bound_max_y, 16, 31); \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->dcd_offset, 0, 31); \
   __tmp_packed.opaque[ 5] = 0; \
   __tmp_packed.opaque[ 6] = 0; \
   __tmp_packed.opaque[ 7] = 0; \
   __tmp_packed.opaque[ 8] = util_bitpack_uint((__unpacked)->crc_buffer.base, 0, 63); \
   __tmp_packed.opaque[ 9] = util_bitpack_uint((__unpacked)->crc_buffer.base, 0, 63) >> 32; \
   __tmp_packed.opaque[10] = util_bitpack_uint((__unpacked)->crc_buffer.row_stride, 0, 31); \
   __tmp_packed.opaque[11] = util_bitpack_uint((__unpacked)->crc_buffer.surface_stride, 0, 31); \
   __tmp_packed.opaque[12] = util_bitpack_uint((__unpacked)->color_writeback.base, 0, 63); \
   __tmp_packed.opaque[13] = util_bitpack_uint((__unpacked)->color_writeback.base, 0, 63) >> 32; \
   __tmp_packed.opaque[14] = util_bitpack_uint((__unpacked)->color_writeback.row_stride, 0, 31); \
   __tmp_packed.opaque[15] = util_bitpack_uint((__unpacked)->color_writeback.surface_stride, 0, 31); \
   __tmp_packed.opaque[16] = util_bitpack_uint((__unpacked)->zs_writeback.base, 0, 63); \
   __tmp_packed.opaque[17] = util_bitpack_uint((__unpacked)->zs_writeback.base, 0, 63) >> 32; \
   __tmp_packed.opaque[18] = util_bitpack_uint((__unpacked)->zs_writeback.row_stride, 0, 31); \
   __tmp_packed.opaque[19] = util_bitpack_uint((__unpacked)->zs_writeback.surface_stride, 0, 31); \
   __tmp_packed.opaque[20] = util_bitpack_uint((__unpacked)->s_writeback.base, 0, 63); \
   __tmp_packed.opaque[21] = util_bitpack_uint((__unpacked)->s_writeback.base, 0, 63) >> 32; \
   __tmp_packed.opaque[22] = util_bitpack_uint((__unpacked)->s_writeback.row_stride, 0, 31); \
   __tmp_packed.opaque[23] = util_bitpack_uint((__unpacked)->s_writeback.surface_stride, 0, 31); \
   __tmp_packed.opaque[24] = util_bitpack_uint((__unpacked)->color_load_address, 0, 63) | \
            util_bitpack_uint((__unpacked)->clear_color_0, 0, 31); \
   __tmp_packed.opaque[25] = util_bitpack_uint((__unpacked)->color_load_address, 0, 63) >> 32 | \
            util_bitpack_uint((__unpacked)->clear_color_1, 0, 31); \
   __tmp_packed.opaque[26] = util_bitpack_uint((__unpacked)->color_load_row_stride, 0, 31) | \
            util_bitpack_uint((__unpacked)->clear_color_2, 0, 31); \
   __tmp_packed.opaque[27] = util_bitpack_uint((__unpacked)->color_load_surface_stride, 0, 31) | \
            util_bitpack_uint((__unpacked)->clear_color_3, 0, 31); \
   __tmp_packed.opaque[28] = util_bitpack_uint((__unpacked)->zs_load_address, 0, 63) | \
            util_bitpack_float((__unpacked)->z_clear); \
   __tmp_packed.opaque[29] = util_bitpack_uint((__unpacked)->zs_load_address, 0, 63) >> 32; \
   __tmp_packed.opaque[30] = util_bitpack_uint((__unpacked)->zs_load_row_stride, 0, 31); \
   __tmp_packed.opaque[31] = util_bitpack_uint((__unpacked)->zs_load_surface_stride, 0, 31); \
   __tmp_packed.opaque[32] = util_bitpack_uint((__unpacked)->s_clear, 0, 7); \
   __tmp_packed.opaque[33] = 0; \
   __tmp_packed.opaque[34] = 0; \
   __tmp_packed.opaque[35] = 0; \
   __tmp_packed.opaque[36] = 0; \
   __tmp_packed.opaque[37] = 0; \
   __tmp_packed.opaque[38] = 0; \
   __tmp_packed.opaque[39] = 0; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_FRAMEBUFFER_PARAMETERS_unpack(__packed, __unpacked) \
do { \
   MALI_FRAMEBUFFER_PARAMETERS_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[1] & 0x40000000) fprintf(stderr, "XXX: Invalid field of Framebuffer Parameters unpacked at word 1\n"); \
   if (__tmp_packed.opaque[5] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Parameters unpacked at word 5\n"); \
   if (__tmp_packed.opaque[6] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Parameters unpacked at word 6\n"); \
   if (__tmp_packed.opaque[7] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Parameters unpacked at word 7\n"); \
   if (__tmp_packed.opaque[32] & 0xffffff00) fprintf(stderr, "XXX: Invalid field of Framebuffer Parameters unpacked at word 32\n"); \
   if (__tmp_packed.opaque[33] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Parameters unpacked at word 33\n"); \
   if (__tmp_packed.opaque[34] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Parameters unpacked at word 34\n"); \
   if (__tmp_packed.opaque[35] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Parameters unpacked at word 35\n"); \
   if (__tmp_packed.opaque[36] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Parameters unpacked at word 36\n"); \
   if (__tmp_packed.opaque[37] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Parameters unpacked at word 37\n"); \
   if (__tmp_packed.opaque[38] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Parameters unpacked at word 38\n"); \
   if (__tmp_packed.opaque[39] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Parameters unpacked at word 39\n"); \
   __gen_unpack_uint((__unpacked)->internal_format, &__tmp_packed.opaque[0], 0, 2); \
   __gen_unpack_uint((__unpacked)->sample_count, &__tmp_packed.opaque[0], 3, 5); \
   (__unpacked)->sample_count = 1U << (__unpacked)->sample_count; \
   __gen_unpack_uint((__unpacked)->swizzle, &__tmp_packed.opaque[0], 6, 17); \
   __gen_unpack_uint((__unpacked)->color_writeback_format, &__tmp_packed.opaque[0], 18, 22); \
   __gen_unpack_uint((__unpacked)->msaa, &__tmp_packed.opaque[0], 23, 24); \
   __gen_unpack_uint((__unpacked)->srgb, &__tmp_packed.opaque[0], 25, 25); \
   __gen_unpack_uint((__unpacked)->color_block_format, &__tmp_packed.opaque[0], 26, 27); \
   __gen_unpack_uint((__unpacked)->dithering_enable, &__tmp_packed.opaque[0], 28, 28); \
   __gen_unpack_uint((__unpacked)->clean_pixel_write_enable, &__tmp_packed.opaque[0], 29, 29); \
   __gen_unpack_uint((__unpacked)->color_preload_enable, &__tmp_packed.opaque[0], 30, 30); \
   __gen_unpack_uint((__unpacked)->color_write_enable, &__tmp_packed.opaque[0], 31, 31); \
   __gen_unpack_uint((__unpacked)->x_downsampling_scale, &__tmp_packed.opaque[0], 32, 34); \
   __gen_unpack_uint((__unpacked)->y_downsampling_scale, &__tmp_packed.opaque[0], 35, 37); \
   __gen_unpack_uint((__unpacked)->downsampling_accumulation_mode, &__tmp_packed.opaque[0], 38, 39); \
   __gen_unpack_uint((__unpacked)->sample_layout, &__tmp_packed.opaque[0], 40, 41); \
   __gen_unpack_uint((__unpacked)->big_endian, &__tmp_packed.opaque[0], 42, 42); \
   __gen_unpack_uint((__unpacked)->tie_break_rule, &__tmp_packed.opaque[0], 43, 45); \
   __gen_unpack_uint((__unpacked)->crc_read_enable, &__tmp_packed.opaque[0], 46, 46); \
   __gen_unpack_uint((__unpacked)->crc_write_enable, &__tmp_packed.opaque[0], 47, 47); \
   __gen_unpack_uint((__unpacked)->zs_block_format, &__tmp_packed.opaque[0], 48, 49); \
   __gen_unpack_uint((__unpacked)->zs_format, &__tmp_packed.opaque[0], 50, 53); \
   __gen_unpack_uint((__unpacked)->zs_preload_enable, &__tmp_packed.opaque[0], 54, 54); \
   __gen_unpack_uint((__unpacked)->zs_write_enable, &__tmp_packed.opaque[0], 55, 55); \
   __gen_unpack_uint((__unpacked)->s_block_format, &__tmp_packed.opaque[0], 56, 57); \
   __gen_unpack_uint((__unpacked)->s_format, &__tmp_packed.opaque[0], 58, 61); \
   __gen_unpack_uint((__unpacked)->s_write_enable, &__tmp_packed.opaque[0], 63, 63); \
   __gen_unpack_uint((__unpacked)->bound_min_x, &__tmp_packed.opaque[0], 64, 79); \
   __gen_unpack_uint((__unpacked)->bound_min_y, &__tmp_packed.opaque[0], 80, 95); \
   __gen_unpack_uint((__unpacked)->bound_max_x, &__tmp_packed.opaque[0], 96, 111); \
   __gen_unpack_uint((__unpacked)->bound_max_y, &__tmp_packed.opaque[0], 112, 127); \
   __gen_unpack_uint((__unpacked)->dcd_offset, &__tmp_packed.opaque[0], 128, 159); \
   __gen_unpack_uint((__unpacked)->crc_buffer.base, &__tmp_packed.opaque[0], 256, 319); \
   __gen_unpack_uint((__unpacked)->crc_buffer.row_stride, &__tmp_packed.opaque[0], 320, 351); \
   __gen_unpack_uint((__unpacked)->crc_buffer.surface_stride, &__tmp_packed.opaque[0], 352, 383); \
   __gen_unpack_uint((__unpacked)->color_writeback.base, &__tmp_packed.opaque[0], 384, 447); \
   __gen_unpack_uint((__unpacked)->color_writeback.row_stride, &__tmp_packed.opaque[0], 448, 479); \
   __gen_unpack_uint((__unpacked)->color_writeback.surface_stride, &__tmp_packed.opaque[0], 480, 511); \
   __gen_unpack_uint((__unpacked)->zs_writeback.base, &__tmp_packed.opaque[0], 512, 575); \
   __gen_unpack_uint((__unpacked)->zs_writeback.row_stride, &__tmp_packed.opaque[0], 576, 607); \
   __gen_unpack_uint((__unpacked)->zs_writeback.surface_stride, &__tmp_packed.opaque[0], 608, 639); \
   __gen_unpack_uint((__unpacked)->s_writeback.base, &__tmp_packed.opaque[0], 640, 703); \
   __gen_unpack_uint((__unpacked)->s_writeback.row_stride, &__tmp_packed.opaque[0], 704, 735); \
   __gen_unpack_uint((__unpacked)->s_writeback.surface_stride, &__tmp_packed.opaque[0], 736, 767); \
   __gen_unpack_uint((__unpacked)->color_load_address, &__tmp_packed.opaque[0], 768, 831); \
   __gen_unpack_uint((__unpacked)->color_load_row_stride, &__tmp_packed.opaque[0], 832, 863); \
   __gen_unpack_uint((__unpacked)->color_load_surface_stride, &__tmp_packed.opaque[0], 864, 895); \
   __gen_unpack_uint((__unpacked)->clear_color_0, &__tmp_packed.opaque[0], 768, 799); \
   __gen_unpack_uint((__unpacked)->clear_color_1, &__tmp_packed.opaque[0], 800, 831); \
   __gen_unpack_uint((__unpacked)->clear_color_2, &__tmp_packed.opaque[0], 832, 863); \
   __gen_unpack_uint((__unpacked)->clear_color_3, &__tmp_packed.opaque[0], 864, 895); \
   __gen_unpack_uint((__unpacked)->zs_load_address, &__tmp_packed.opaque[0], 896, 959); \
   __gen_unpack_uint((__unpacked)->zs_load_row_stride, &__tmp_packed.opaque[0], 960, 991); \
   __gen_unpack_uint((__unpacked)->zs_load_surface_stride, &__tmp_packed.opaque[0], 992, 1023); \
   __gen_unpack_float((__unpacked)->z_clear, &__tmp_packed.opaque[0], 896, 927); \
   __gen_unpack_uint((__unpacked)->s_clear, &__tmp_packed.opaque[0], 1024, 1031); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_FRAMEBUFFER_PARAMETERS_print(FILE *fp, const struct MALI_FRAMEBUFFER_PARAMETERS * values, unsigned indent)
{
   fprintf(fp, "%*sInternal Format: %s\n", indent, "", mali_color_buffer_internal_format_as_str(values->internal_format));
   fprintf(fp, "%*sSample Count: %u\n", indent, "", values->sample_count);
   fprintf(fp, "%*sSwizzle: %u\n", indent, "", values->swizzle);
   fprintf(fp, "%*sColor Writeback Format: %s\n", indent, "", mali_color_format_as_str(values->color_writeback_format));
   fprintf(fp, "%*sMSAA: %s\n", indent, "", mali_msaa_as_str(values->msaa));
   fprintf(fp, "%*ssRGB: %s\n", indent, "", values->srgb ? "true" : "false");
   fprintf(fp, "%*sColor Block Format: %s\n", indent, "", mali_block_format_as_str(values->color_block_format));
   fprintf(fp, "%*sDithering Enable: %s\n", indent, "", values->dithering_enable ? "true" : "false");
   fprintf(fp, "%*sClean Pixel Write Enable: %s\n", indent, "", values->clean_pixel_write_enable ? "true" : "false");
   fprintf(fp, "%*sColor Preload Enable: %s\n", indent, "", values->color_preload_enable ? "true" : "false");
   fprintf(fp, "%*sColor Write Enable: %s\n", indent, "", values->color_write_enable ? "true" : "false");
   fprintf(fp, "%*sX Downsampling Scale: %u\n", indent, "", values->x_downsampling_scale);
   fprintf(fp, "%*sY Downsampling Scale: %u\n", indent, "", values->y_downsampling_scale);
   fprintf(fp, "%*sDownsampling Accumulation Mode: %s\n", indent, "", mali_downsampling_accumulation_mode_as_str(values->downsampling_accumulation_mode));
   fprintf(fp, "%*sSample Layout: %s\n", indent, "", mali_sample_layout_as_str(values->sample_layout));
   fprintf(fp, "%*sBig Endian: %s\n", indent, "", values->big_endian ? "true" : "false");
   fprintf(fp, "%*sTie-Break Rule: %s\n", indent, "", mali_tie_break_rule_as_str(values->tie_break_rule));
   fprintf(fp, "%*sCRC Read Enable: %s\n", indent, "", values->crc_read_enable ? "true" : "false");
   fprintf(fp, "%*sCRC Write Enable: %s\n", indent, "", values->crc_write_enable ? "true" : "false");
   fprintf(fp, "%*sZS Block Format: %s\n", indent, "", mali_block_format_as_str(values->zs_block_format));
   fprintf(fp, "%*sZS Format: %s\n", indent, "", mali_zs_format_as_str(values->zs_format));
   fprintf(fp, "%*sZS Preload Enable: %s\n", indent, "", values->zs_preload_enable ? "true" : "false");
   fprintf(fp, "%*sZS Write Enable: %s\n", indent, "", values->zs_write_enable ? "true" : "false");
   fprintf(fp, "%*sS Block Format: %s\n", indent, "", mali_block_format_as_str(values->s_block_format));
   fprintf(fp, "%*sS Format: %s\n", indent, "", mali_s_format_as_str(values->s_format));
   fprintf(fp, "%*sS Write Enable: %s\n", indent, "", values->s_write_enable ? "true" : "false");
   fprintf(fp, "%*sBound Min X: %u\n", indent, "", values->bound_min_x);
   fprintf(fp, "%*sBound Min Y: %u\n", indent, "", values->bound_min_y);
   fprintf(fp, "%*sBound Max X: %u\n", indent, "", values->bound_max_x);
   fprintf(fp, "%*sBound Max Y: %u\n", indent, "", values->bound_max_y);
   fprintf(fp, "%*sDCD Offset: 0x%" PRIx64 "\n", indent, "", values->dcd_offset);
   fprintf(fp, "%*sCRC Buffer:\n", indent, "");
   MALI_RT_BUFFER_print(fp, &values->crc_buffer, indent + 2);
   fprintf(fp, "%*sColor Writeback:\n", indent, "");
   MALI_RT_BUFFER_print(fp, &values->color_writeback, indent + 2);
   fprintf(fp, "%*sZS Writeback:\n", indent, "");
   MALI_RT_BUFFER_print(fp, &values->zs_writeback, indent + 2);
   fprintf(fp, "%*sS Writeback:\n", indent, "");
   MALI_RT_BUFFER_print(fp, &values->s_writeback, indent + 2);
   fprintf(fp, "%*sColor Load Address: 0x%" PRIx64 "\n", indent, "", values->color_load_address);
   fprintf(fp, "%*sColor Load Row Stride: 0x%" PRIx64 "\n", indent, "", values->color_load_row_stride);
   fprintf(fp, "%*sColor Load Surface Stride: 0x%" PRIx64 "\n", indent, "", values->color_load_surface_stride);
   fprintf(fp, "%*sClear Color 0: 0x%" PRIx64 "\n", indent, "", values->clear_color_0);
   fprintf(fp, "%*sClear Color 1: 0x%" PRIx64 "\n", indent, "", values->clear_color_1);
   fprintf(fp, "%*sClear Color 2: 0x%" PRIx64 "\n", indent, "", values->clear_color_2);
   fprintf(fp, "%*sClear Color 3: 0x%" PRIx64 "\n", indent, "", values->clear_color_3);
   fprintf(fp, "%*sZS Load Address: 0x%" PRIx64 "\n", indent, "", values->zs_load_address);
   fprintf(fp, "%*sZS Load Row Stride: 0x%" PRIx64 "\n", indent, "", values->zs_load_row_stride);
   fprintf(fp, "%*sZS Load Surface Stride: 0x%" PRIx64 "\n", indent, "", values->zs_load_surface_stride);
   fprintf(fp, "%*sZ Clear: %f\n", indent, "", values->z_clear);
   fprintf(fp, "%*sS Clear: %u\n", indent, "", values->s_clear);
}

#endif
struct MALI_FRAMEBUFFER_PADDING_1 {
   int dummy;
};

#define MALI_FRAMEBUFFER_PADDING_1_header       \
   0

#define MALI_FRAMEBUFFER_PADDING_1_LENGTH 24
struct mali_framebuffer_padding_1_packed { uint32_t opaque[6]; };
#define MALI_FRAMEBUFFER_PADDING_1_PACKED_T struct mali_framebuffer_padding_1_packed
#define MALI_FRAMEBUFFER_PADDING_1_pack(__packed, __unpacked) \
do { \
   MALI_FRAMEBUFFER_PADDING_1_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = 0; \
   __tmp_packed.opaque[ 1] = 0; \
   __tmp_packed.opaque[ 2] = 0; \
   __tmp_packed.opaque[ 3] = 0; \
   __tmp_packed.opaque[ 4] = 0; \
   __tmp_packed.opaque[ 5] = 0; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_FRAMEBUFFER_PADDING_1_unpack(__packed, __unpacked) \
do { \
   MALI_FRAMEBUFFER_PADDING_1_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Padding 1 unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Padding 1 unpacked at word 1\n"); \
   if (__tmp_packed.opaque[2] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Padding 1 unpacked at word 2\n"); \
   if (__tmp_packed.opaque[3] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Padding 1 unpacked at word 3\n"); \
   if (__tmp_packed.opaque[4] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Padding 1 unpacked at word 4\n"); \
   if (__tmp_packed.opaque[5] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Padding 1 unpacked at word 5\n"); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_FRAMEBUFFER_PADDING_1_print(FILE *fp, const struct MALI_FRAMEBUFFER_PADDING_1 * values, unsigned indent)
{
}

#endif
struct MALI_FRAMEBUFFER_PADDING_2 {
   int dummy;
};

#define MALI_FRAMEBUFFER_PADDING_2_header       \
   0

#define MALI_FRAMEBUFFER_PADDING_2_LENGTH 32
struct mali_framebuffer_padding_2_packed { uint32_t opaque[8]; };
#define MALI_FRAMEBUFFER_PADDING_2_PACKED_T struct mali_framebuffer_padding_2_packed
#define MALI_FRAMEBUFFER_PADDING_2_pack(__packed, __unpacked) \
do { \
   MALI_FRAMEBUFFER_PADDING_2_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = 0; \
   __tmp_packed.opaque[ 1] = 0; \
   __tmp_packed.opaque[ 2] = 0; \
   __tmp_packed.opaque[ 3] = 0; \
   __tmp_packed.opaque[ 4] = 0; \
   __tmp_packed.opaque[ 5] = 0; \
   __tmp_packed.opaque[ 6] = 0; \
   __tmp_packed.opaque[ 7] = 0; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_FRAMEBUFFER_PADDING_2_unpack(__packed, __unpacked) \
do { \
   MALI_FRAMEBUFFER_PADDING_2_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Padding 2 unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Padding 2 unpacked at word 1\n"); \
   if (__tmp_packed.opaque[2] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Padding 2 unpacked at word 2\n"); \
   if (__tmp_packed.opaque[3] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Padding 2 unpacked at word 3\n"); \
   if (__tmp_packed.opaque[4] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Padding 2 unpacked at word 4\n"); \
   if (__tmp_packed.opaque[5] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Padding 2 unpacked at word 5\n"); \
   if (__tmp_packed.opaque[6] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Padding 2 unpacked at word 6\n"); \
   if (__tmp_packed.opaque[7] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Framebuffer Padding 2 unpacked at word 7\n"); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_FRAMEBUFFER_PADDING_2_print(FILE *fp, const struct MALI_FRAMEBUFFER_PADDING_2 * values, unsigned indent)
{
}

#endif
struct mali_framebuffer_packed {
   uint32_t opaque[80];
};

#define MALI_FRAMEBUFFER_PACKED_T struct mali_framebuffer_packed
#define MALI_FRAMEBUFFER_LENGTH 320
#define MALI_FRAMEBUFFER_ALIGN 64
#define MALI_FRAMEBUFFER_SECTION_LOCAL_STORAGE_TYPE struct MALI_LOCAL_STORAGE
#define MALI_FRAMEBUFFER_SECTION_LOCAL_STORAGE_PACKED_TYPE MALI_LOCAL_STORAGE_PACKED_T
#define MALI_FRAMEBUFFER_SECTION_LOCAL_STORAGE_header MALI_LOCAL_STORAGE_header
#define MALI_FRAMEBUFFER_SECTION_LOCAL_STORAGE_pack MALI_LOCAL_STORAGE_pack
#define MALI_FRAMEBUFFER_SECTION_LOCAL_STORAGE_unpack MALI_LOCAL_STORAGE_unpack
#define MALI_FRAMEBUFFER_SECTION_LOCAL_STORAGE_print MALI_LOCAL_STORAGE_print
#define MALI_FRAMEBUFFER_SECTION_LOCAL_STORAGE_OFFSET 0
#define MALI_FRAMEBUFFER_SECTION_PARAMETERS_TYPE struct MALI_FRAMEBUFFER_PARAMETERS
#define MALI_FRAMEBUFFER_SECTION_PARAMETERS_PACKED_TYPE MALI_FRAMEBUFFER_PARAMETERS_PACKED_T
#define MALI_FRAMEBUFFER_SECTION_PARAMETERS_header MALI_FRAMEBUFFER_PARAMETERS_header
#define MALI_FRAMEBUFFER_SECTION_PARAMETERS_pack MALI_FRAMEBUFFER_PARAMETERS_pack
#define MALI_FRAMEBUFFER_SECTION_PARAMETERS_unpack MALI_FRAMEBUFFER_PARAMETERS_unpack
#define MALI_FRAMEBUFFER_SECTION_PARAMETERS_print MALI_FRAMEBUFFER_PARAMETERS_print
#define MALI_FRAMEBUFFER_SECTION_PARAMETERS_OFFSET 32
#define MALI_FRAMEBUFFER_SECTION_TILER_TYPE struct MALI_TILER_CONTEXT
#define MALI_FRAMEBUFFER_SECTION_TILER_PACKED_TYPE MALI_TILER_CONTEXT_PACKED_T
#define MALI_FRAMEBUFFER_SECTION_TILER_header MALI_TILER_CONTEXT_header
#define MALI_FRAMEBUFFER_SECTION_TILER_pack MALI_TILER_CONTEXT_pack
#define MALI_FRAMEBUFFER_SECTION_TILER_unpack MALI_TILER_CONTEXT_unpack
#define MALI_FRAMEBUFFER_SECTION_TILER_print MALI_TILER_CONTEXT_print
#define MALI_FRAMEBUFFER_SECTION_TILER_OFFSET 192
#define MALI_FRAMEBUFFER_SECTION_PADDING_1_TYPE struct MALI_FRAMEBUFFER_PADDING_1
#define MALI_FRAMEBUFFER_SECTION_PADDING_1_PACKED_TYPE MALI_FRAMEBUFFER_PADDING_1_PACKED_T
#define MALI_FRAMEBUFFER_SECTION_PADDING_1_header MALI_FRAMEBUFFER_PADDING_1_header
#define MALI_FRAMEBUFFER_SECTION_PADDING_1_pack MALI_FRAMEBUFFER_PADDING_1_pack
#define MALI_FRAMEBUFFER_SECTION_PADDING_1_unpack MALI_FRAMEBUFFER_PADDING_1_unpack
#define MALI_FRAMEBUFFER_SECTION_PADDING_1_print MALI_FRAMEBUFFER_PADDING_1_print
#define MALI_FRAMEBUFFER_SECTION_PADDING_1_OFFSET 232
#define MALI_FRAMEBUFFER_SECTION_TILER_WEIGHTS_TYPE struct MALI_TILER_WEIGHTS
#define MALI_FRAMEBUFFER_SECTION_TILER_WEIGHTS_PACKED_TYPE MALI_TILER_WEIGHTS_PACKED_T
#define MALI_FRAMEBUFFER_SECTION_TILER_WEIGHTS_header MALI_TILER_WEIGHTS_header
#define MALI_FRAMEBUFFER_SECTION_TILER_WEIGHTS_pack MALI_TILER_WEIGHTS_pack
#define MALI_FRAMEBUFFER_SECTION_TILER_WEIGHTS_unpack MALI_TILER_WEIGHTS_unpack
#define MALI_FRAMEBUFFER_SECTION_TILER_WEIGHTS_print MALI_TILER_WEIGHTS_print
#define MALI_FRAMEBUFFER_SECTION_TILER_WEIGHTS_OFFSET 256
#define MALI_FRAMEBUFFER_SECTION_PADDING_2_TYPE struct MALI_FRAMEBUFFER_PADDING_2
#define MALI_FRAMEBUFFER_SECTION_PADDING_2_PACKED_TYPE MALI_FRAMEBUFFER_PADDING_2_PACKED_T
#define MALI_FRAMEBUFFER_SECTION_PADDING_2_header MALI_FRAMEBUFFER_PADDING_2_header
#define MALI_FRAMEBUFFER_SECTION_PADDING_2_pack MALI_FRAMEBUFFER_PADDING_2_pack
#define MALI_FRAMEBUFFER_SECTION_PADDING_2_unpack MALI_FRAMEBUFFER_PADDING_2_unpack
#define MALI_FRAMEBUFFER_SECTION_PADDING_2_print MALI_FRAMEBUFFER_PADDING_2_print
#define MALI_FRAMEBUFFER_SECTION_PADDING_2_OFFSET 288

enum mali_sample_pattern {
        MALI_SAMPLE_PATTERN_SINGLE_SAMPLED   =      0,
        MALI_SAMPLE_PATTERN_ORDERED_4X_GRID  =      1,
        MALI_SAMPLE_PATTERN_ROTATED_4X_GRID  =      2,
        MALI_SAMPLE_PATTERN_D3D_8X_GRID      =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_sample_pattern_as_str(enum mali_sample_pattern imm)
{
    switch (imm) {
    case MALI_SAMPLE_PATTERN_SINGLE_SAMPLED: return "Single-sampled";
    case MALI_SAMPLE_PATTERN_ORDERED_4X_GRID: return "Ordered 4x Grid";
    case MALI_SAMPLE_PATTERN_ROTATED_4X_GRID: return "Rotated 4x Grid";
    case MALI_SAMPLE_PATTERN_D3D_8X_GRID: return "D3D 8x Grid";
    default: return "XXX: INVALID";
    }
}

#endif

struct MALI_JOB_HEADER {
   uint64_t                             exception_status;
   uint64_t                             first_incomplete_task;
   uint64_t                             fault_pointer;
   bool                                 is_64b;
   enum mali_job_type                   type;
   bool                                 barrier;
   bool                                 invalidate_cache;
   bool                                 suppress_prefetch;
   bool                                 enable_texture_mapper;
   bool                                 relax_dependency_1;
   bool                                 relax_dependency_2;
   uint32_t                             index;
   uint32_t                             dependency_1;
   uint32_t                             dependency_2;
   uint64_t                             next;
};

#define MALI_JOB_HEADER_header                  \
   .is_64b = true

#define MALI_JOB_HEADER_LENGTH 32
#define MALI_JOB_HEADER_ALIGN 64
struct mali_job_header_packed { uint32_t opaque[8]; };
#define MALI_JOB_HEADER_PACKED_T struct mali_job_header_packed
#define MALI_JOB_HEADER_pack(__packed, __unpacked) \
do { \
   MALI_JOB_HEADER_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->exception_status, 0, 31); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->first_incomplete_task, 0, 31); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->fault_pointer, 0, 63); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->fault_pointer, 0, 63) >> 32; \
   __tmp_packed.opaque[ 4] = util_bitpack_uint((__unpacked)->is_64b, 0, 0) | \
            util_bitpack_uint((__unpacked)->type, 1, 7) | \
            util_bitpack_uint((__unpacked)->barrier, 8, 8) | \
            util_bitpack_uint((__unpacked)->invalidate_cache, 9, 9) | \
            util_bitpack_uint((__unpacked)->suppress_prefetch, 11, 11) | \
            util_bitpack_uint((__unpacked)->enable_texture_mapper, 12, 12) | \
            util_bitpack_uint((__unpacked)->relax_dependency_1, 14, 14) | \
            util_bitpack_uint((__unpacked)->relax_dependency_2, 15, 15) | \
            util_bitpack_uint((__unpacked)->index, 16, 31); \
   __tmp_packed.opaque[ 5] = util_bitpack_uint((__unpacked)->dependency_1, 0, 15) | \
            util_bitpack_uint((__unpacked)->dependency_2, 16, 31); \
   __tmp_packed.opaque[ 6] = util_bitpack_uint((__unpacked)->next, 0, 63); \
   __tmp_packed.opaque[ 7] = util_bitpack_uint((__unpacked)->next, 0, 63) >> 32; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_JOB_HEADER_unpack(__packed, __unpacked) \
do { \
   MALI_JOB_HEADER_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[4] & 0x2400) fprintf(stderr, "XXX: Invalid field of Job Header unpacked at word 4\n"); \
   __gen_unpack_uint((__unpacked)->exception_status, &__tmp_packed.opaque[0], 0, 31); \
   __gen_unpack_uint((__unpacked)->first_incomplete_task, &__tmp_packed.opaque[0], 32, 63); \
   __gen_unpack_uint((__unpacked)->fault_pointer, &__tmp_packed.opaque[0], 64, 127); \
   __gen_unpack_uint((__unpacked)->is_64b, &__tmp_packed.opaque[0], 128, 128); \
   __gen_unpack_uint((__unpacked)->type, &__tmp_packed.opaque[0], 129, 135); \
   __gen_unpack_uint((__unpacked)->barrier, &__tmp_packed.opaque[0], 136, 136); \
   __gen_unpack_uint((__unpacked)->invalidate_cache, &__tmp_packed.opaque[0], 137, 137); \
   __gen_unpack_uint((__unpacked)->suppress_prefetch, &__tmp_packed.opaque[0], 139, 139); \
   __gen_unpack_uint((__unpacked)->enable_texture_mapper, &__tmp_packed.opaque[0], 140, 140); \
   __gen_unpack_uint((__unpacked)->relax_dependency_1, &__tmp_packed.opaque[0], 142, 142); \
   __gen_unpack_uint((__unpacked)->relax_dependency_2, &__tmp_packed.opaque[0], 143, 143); \
   __gen_unpack_uint((__unpacked)->index, &__tmp_packed.opaque[0], 144, 159); \
   __gen_unpack_uint((__unpacked)->dependency_1, &__tmp_packed.opaque[0], 160, 175); \
   __gen_unpack_uint((__unpacked)->dependency_2, &__tmp_packed.opaque[0], 176, 191); \
   __gen_unpack_uint((__unpacked)->next, &__tmp_packed.opaque[0], 192, 255); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_JOB_HEADER_print(FILE *fp, const struct MALI_JOB_HEADER * values, unsigned indent)
{
   fprintf(fp, "%*sException Status: 0x%" PRIx64 "\n", indent, "", values->exception_status);
   fprintf(fp, "%*sFirst Incomplete Task: 0x%" PRIx64 "\n", indent, "", values->first_incomplete_task);
   fprintf(fp, "%*sFault Pointer: 0x%" PRIx64 "\n", indent, "", values->fault_pointer);
   fprintf(fp, "%*sIs 64b: %s\n", indent, "", values->is_64b ? "true" : "false");
   fprintf(fp, "%*sType: %s\n", indent, "", mali_job_type_as_str(values->type));
   fprintf(fp, "%*sBarrier: %s\n", indent, "", values->barrier ? "true" : "false");
   fprintf(fp, "%*sInvalidate Cache: %s\n", indent, "", values->invalidate_cache ? "true" : "false");
   fprintf(fp, "%*sSuppress Prefetch: %s\n", indent, "", values->suppress_prefetch ? "true" : "false");
   fprintf(fp, "%*sEnable Texture Mapper: %s\n", indent, "", values->enable_texture_mapper ? "true" : "false");
   fprintf(fp, "%*sRelax Dependency 1: %s\n", indent, "", values->relax_dependency_1 ? "true" : "false");
   fprintf(fp, "%*sRelax Dependency 2: %s\n", indent, "", values->relax_dependency_2 ? "true" : "false");
   fprintf(fp, "%*sIndex: %u\n", indent, "", values->index);
   fprintf(fp, "%*sDependency 1: %u\n", indent, "", values->dependency_1);
   fprintf(fp, "%*sDependency 2: %u\n", indent, "", values->dependency_2);
   fprintf(fp, "%*sNext: 0x%" PRIx64 "\n", indent, "", values->next);
}

#endif
struct MALI_FRAGMENT_JOB_PAYLOAD {
   uint32_t                             bound_min_x;
   uint32_t                             bound_min_y;
   uint32_t                             bound_max_x;
   uint32_t                             bound_max_y;
   uint64_t                             framebuffer;
};

#define MALI_FRAGMENT_JOB_PAYLOAD_header        \
   0

#define MALI_FRAGMENT_JOB_PAYLOAD_LENGTH 16
struct mali_fragment_job_payload_packed { uint32_t opaque[4]; };
#define MALI_FRAGMENT_JOB_PAYLOAD_PACKED_T struct mali_fragment_job_payload_packed
#define MALI_FRAGMENT_JOB_PAYLOAD_pack(__packed, __unpacked) \
do { \
   MALI_FRAGMENT_JOB_PAYLOAD_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->bound_min_x, 0, 11) | \
            util_bitpack_uint((__unpacked)->bound_min_y, 16, 27); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->bound_max_x, 0, 11) | \
            util_bitpack_uint((__unpacked)->bound_max_y, 16, 27); \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->framebuffer, 0, 63); \
   __tmp_packed.opaque[ 3] = util_bitpack_uint((__unpacked)->framebuffer, 0, 63) >> 32; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_FRAGMENT_JOB_PAYLOAD_unpack(__packed, __unpacked) \
do { \
   MALI_FRAGMENT_JOB_PAYLOAD_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xf000f000) fprintf(stderr, "XXX: Invalid field of Fragment Job Payload unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xf000f000) fprintf(stderr, "XXX: Invalid field of Fragment Job Payload unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->bound_min_x, &__tmp_packed.opaque[0], 0, 11); \
   __gen_unpack_uint((__unpacked)->bound_min_y, &__tmp_packed.opaque[0], 16, 27); \
   __gen_unpack_uint((__unpacked)->bound_max_x, &__tmp_packed.opaque[0], 32, 43); \
   __gen_unpack_uint((__unpacked)->bound_max_y, &__tmp_packed.opaque[0], 48, 59); \
   __gen_unpack_uint((__unpacked)->framebuffer, &__tmp_packed.opaque[0], 64, 127); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_FRAGMENT_JOB_PAYLOAD_print(FILE *fp, const struct MALI_FRAGMENT_JOB_PAYLOAD * values, unsigned indent)
{
   fprintf(fp, "%*sBound Min X: %u\n", indent, "", values->bound_min_x);
   fprintf(fp, "%*sBound Min Y: %u\n", indent, "", values->bound_min_y);
   fprintf(fp, "%*sBound Max X: %u\n", indent, "", values->bound_max_x);
   fprintf(fp, "%*sBound Max Y: %u\n", indent, "", values->bound_max_y);
   fprintf(fp, "%*sFramebuffer: 0x%" PRIx64 "\n", indent, "", values->framebuffer);
}

#endif
struct mali_fragment_job_packed {
   uint32_t opaque[12];
};

#define MALI_FRAGMENT_JOB_PACKED_T struct mali_fragment_job_packed
#define MALI_FRAGMENT_JOB_LENGTH 48
#define MALI_FRAGMENT_JOB_ALIGN 64
#define MALI_FRAGMENT_JOB_SECTION_HEADER_TYPE struct MALI_JOB_HEADER
#define MALI_FRAGMENT_JOB_SECTION_HEADER_PACKED_TYPE MALI_JOB_HEADER_PACKED_T
#define MALI_FRAGMENT_JOB_SECTION_HEADER_header MALI_JOB_HEADER_header
#define MALI_FRAGMENT_JOB_SECTION_HEADER_pack MALI_JOB_HEADER_pack
#define MALI_FRAGMENT_JOB_SECTION_HEADER_unpack MALI_JOB_HEADER_unpack
#define MALI_FRAGMENT_JOB_SECTION_HEADER_print MALI_JOB_HEADER_print
#define MALI_FRAGMENT_JOB_SECTION_HEADER_OFFSET 0
#define MALI_FRAGMENT_JOB_SECTION_PAYLOAD_TYPE struct MALI_FRAGMENT_JOB_PAYLOAD
#define MALI_FRAGMENT_JOB_SECTION_PAYLOAD_PACKED_TYPE MALI_FRAGMENT_JOB_PAYLOAD_PACKED_T
#define MALI_FRAGMENT_JOB_SECTION_PAYLOAD_header MALI_FRAGMENT_JOB_PAYLOAD_header
#define MALI_FRAGMENT_JOB_SECTION_PAYLOAD_pack MALI_FRAGMENT_JOB_PAYLOAD_pack
#define MALI_FRAGMENT_JOB_SECTION_PAYLOAD_unpack MALI_FRAGMENT_JOB_PAYLOAD_unpack
#define MALI_FRAGMENT_JOB_SECTION_PAYLOAD_print MALI_FRAGMENT_JOB_PAYLOAD_print
#define MALI_FRAGMENT_JOB_SECTION_PAYLOAD_OFFSET 32

enum mali_write_value_type {
        MALI_WRITE_VALUE_TYPE_CYCLE_COUNTER  =      1,
        MALI_WRITE_VALUE_TYPE_SYSTEM_TIMESTAMP =      2,
        MALI_WRITE_VALUE_TYPE_ZERO           =      3,
};

#ifndef __OPENCL_VERSION__
static inline const char *
mali_write_value_type_as_str(enum mali_write_value_type imm)
{
    switch (imm) {
    case MALI_WRITE_VALUE_TYPE_CYCLE_COUNTER: return "Cycle Counter";
    case MALI_WRITE_VALUE_TYPE_SYSTEM_TIMESTAMP: return "System Timestamp";
    case MALI_WRITE_VALUE_TYPE_ZERO: return "Zero";
    default: return "XXX: INVALID";
    }
}

#endif

struct MALI_WRITE_VALUE_JOB_PAYLOAD {
   uint64_t                             address;
   enum mali_write_value_type           type;
};

#define MALI_WRITE_VALUE_JOB_PAYLOAD_header     \
   0

#define MALI_WRITE_VALUE_JOB_PAYLOAD_LENGTH 12
struct mali_write_value_job_payload_packed { uint32_t opaque[3]; };
#define MALI_WRITE_VALUE_JOB_PAYLOAD_PACKED_T struct mali_write_value_job_payload_packed
#define MALI_WRITE_VALUE_JOB_PAYLOAD_pack(__packed, __unpacked) \
do { \
   MALI_WRITE_VALUE_JOB_PAYLOAD_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->address, 0, 63); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->address, 0, 63) >> 32; \
   __tmp_packed.opaque[ 2] = util_bitpack_uint((__unpacked)->type, 0, 31); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_WRITE_VALUE_JOB_PAYLOAD_unpack(__packed, __unpacked) \
do { \
   MALI_WRITE_VALUE_JOB_PAYLOAD_PACKED_T __tmp_packed = *(__packed); \
   __gen_unpack_uint((__unpacked)->address, &__tmp_packed.opaque[0], 0, 63); \
   __gen_unpack_uint((__unpacked)->type, &__tmp_packed.opaque[0], 64, 95); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_WRITE_VALUE_JOB_PAYLOAD_print(FILE *fp, const struct MALI_WRITE_VALUE_JOB_PAYLOAD * values, unsigned indent)
{
   fprintf(fp, "%*sAddress: 0x%" PRIx64 "\n", indent, "", values->address);
   fprintf(fp, "%*sType: %s\n", indent, "", mali_write_value_type_as_str(values->type));
}

#endif
struct MALI_CACHE_FLUSH_JOB_PAYLOAD {
   bool                                 clean_shader_core_ls;
   bool                                 invalidate_shader_core_ls;
   bool                                 invalidate_shader_core_other;
   bool                                 job_manager_clean;
   bool                                 job_manager_invalidate;
   bool                                 tiler_clean;
   bool                                 tiler_invalidate;
   bool                                 l2_clean;
   bool                                 l2_invalidate;
};

#define MALI_CACHE_FLUSH_JOB_PAYLOAD_header     \
   0

#define MALI_CACHE_FLUSH_JOB_PAYLOAD_LENGTH 8
struct mali_cache_flush_job_payload_packed { uint32_t opaque[2]; };
#define MALI_CACHE_FLUSH_JOB_PAYLOAD_PACKED_T struct mali_cache_flush_job_payload_packed
#define MALI_CACHE_FLUSH_JOB_PAYLOAD_pack(__packed, __unpacked) \
do { \
   MALI_CACHE_FLUSH_JOB_PAYLOAD_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->clean_shader_core_ls, 0, 0) | \
            util_bitpack_uint((__unpacked)->invalidate_shader_core_ls, 1, 1) | \
            util_bitpack_uint((__unpacked)->invalidate_shader_core_other, 2, 2) | \
            util_bitpack_uint((__unpacked)->job_manager_clean, 16, 16) | \
            util_bitpack_uint((__unpacked)->job_manager_invalidate, 17, 17) | \
            util_bitpack_uint((__unpacked)->tiler_clean, 24, 24) | \
            util_bitpack_uint((__unpacked)->tiler_invalidate, 25, 25); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->l2_clean, 0, 0) | \
            util_bitpack_uint((__unpacked)->l2_invalidate, 1, 1); \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_CACHE_FLUSH_JOB_PAYLOAD_unpack(__packed, __unpacked) \
do { \
   MALI_CACHE_FLUSH_JOB_PAYLOAD_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xfcfcfff8) fprintf(stderr, "XXX: Invalid field of Cache Flush Job Payload unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xfffffffc) fprintf(stderr, "XXX: Invalid field of Cache Flush Job Payload unpacked at word 1\n"); \
   __gen_unpack_uint((__unpacked)->clean_shader_core_ls, &__tmp_packed.opaque[0], 0, 0); \
   __gen_unpack_uint((__unpacked)->invalidate_shader_core_ls, &__tmp_packed.opaque[0], 1, 1); \
   __gen_unpack_uint((__unpacked)->invalidate_shader_core_other, &__tmp_packed.opaque[0], 2, 2); \
   __gen_unpack_uint((__unpacked)->job_manager_clean, &__tmp_packed.opaque[0], 16, 16); \
   __gen_unpack_uint((__unpacked)->job_manager_invalidate, &__tmp_packed.opaque[0], 17, 17); \
   __gen_unpack_uint((__unpacked)->tiler_clean, &__tmp_packed.opaque[0], 24, 24); \
   __gen_unpack_uint((__unpacked)->tiler_invalidate, &__tmp_packed.opaque[0], 25, 25); \
   __gen_unpack_uint((__unpacked)->l2_clean, &__tmp_packed.opaque[0], 32, 32); \
   __gen_unpack_uint((__unpacked)->l2_invalidate, &__tmp_packed.opaque[0], 33, 33); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_CACHE_FLUSH_JOB_PAYLOAD_print(FILE *fp, const struct MALI_CACHE_FLUSH_JOB_PAYLOAD * values, unsigned indent)
{
   fprintf(fp, "%*sClean Shader Core LS: %s\n", indent, "", values->clean_shader_core_ls ? "true" : "false");
   fprintf(fp, "%*sInvalidate Shader Core LS: %s\n", indent, "", values->invalidate_shader_core_ls ? "true" : "false");
   fprintf(fp, "%*sInvalidate Shader Core Other: %s\n", indent, "", values->invalidate_shader_core_other ? "true" : "false");
   fprintf(fp, "%*sJob Manager Clean: %s\n", indent, "", values->job_manager_clean ? "true" : "false");
   fprintf(fp, "%*sJob Manager Invalidate: %s\n", indent, "", values->job_manager_invalidate ? "true" : "false");
   fprintf(fp, "%*sTiler Clean: %s\n", indent, "", values->tiler_clean ? "true" : "false");
   fprintf(fp, "%*sTiler Invalidate: %s\n", indent, "", values->tiler_invalidate ? "true" : "false");
   fprintf(fp, "%*sL2 Clean: %s\n", indent, "", values->l2_clean ? "true" : "false");
   fprintf(fp, "%*sL2 Invalidate: %s\n", indent, "", values->l2_invalidate ? "true" : "false");
}

#endif
struct mali_write_value_job_packed {
   uint32_t opaque[11];
};

#define MALI_WRITE_VALUE_JOB_PACKED_T struct mali_write_value_job_packed
#define MALI_WRITE_VALUE_JOB_LENGTH 44
#define MALI_WRITE_VALUE_JOB_ALIGN 64
#define MALI_WRITE_VALUE_JOB_SECTION_HEADER_TYPE struct MALI_JOB_HEADER
#define MALI_WRITE_VALUE_JOB_SECTION_HEADER_PACKED_TYPE MALI_JOB_HEADER_PACKED_T
#define MALI_WRITE_VALUE_JOB_SECTION_HEADER_header MALI_JOB_HEADER_header
#define MALI_WRITE_VALUE_JOB_SECTION_HEADER_pack MALI_JOB_HEADER_pack
#define MALI_WRITE_VALUE_JOB_SECTION_HEADER_unpack MALI_JOB_HEADER_unpack
#define MALI_WRITE_VALUE_JOB_SECTION_HEADER_print MALI_JOB_HEADER_print
#define MALI_WRITE_VALUE_JOB_SECTION_HEADER_OFFSET 0
#define MALI_WRITE_VALUE_JOB_SECTION_PAYLOAD_TYPE struct MALI_WRITE_VALUE_JOB_PAYLOAD
#define MALI_WRITE_VALUE_JOB_SECTION_PAYLOAD_PACKED_TYPE MALI_WRITE_VALUE_JOB_PAYLOAD_PACKED_T
#define MALI_WRITE_VALUE_JOB_SECTION_PAYLOAD_header MALI_WRITE_VALUE_JOB_PAYLOAD_header
#define MALI_WRITE_VALUE_JOB_SECTION_PAYLOAD_pack MALI_WRITE_VALUE_JOB_PAYLOAD_pack
#define MALI_WRITE_VALUE_JOB_SECTION_PAYLOAD_unpack MALI_WRITE_VALUE_JOB_PAYLOAD_unpack
#define MALI_WRITE_VALUE_JOB_SECTION_PAYLOAD_print MALI_WRITE_VALUE_JOB_PAYLOAD_print
#define MALI_WRITE_VALUE_JOB_SECTION_PAYLOAD_OFFSET 32

struct mali_cache_flush_job_packed {
   uint32_t opaque[10];
};

#define MALI_CACHE_FLUSH_JOB_PACKED_T struct mali_cache_flush_job_packed
#define MALI_CACHE_FLUSH_JOB_LENGTH 40
#define MALI_CACHE_FLUSH_JOB_ALIGN 64
#define MALI_CACHE_FLUSH_JOB_SECTION_HEADER_TYPE struct MALI_JOB_HEADER
#define MALI_CACHE_FLUSH_JOB_SECTION_HEADER_PACKED_TYPE MALI_JOB_HEADER_PACKED_T
#define MALI_CACHE_FLUSH_JOB_SECTION_HEADER_header MALI_JOB_HEADER_header
#define MALI_CACHE_FLUSH_JOB_SECTION_HEADER_pack MALI_JOB_HEADER_pack
#define MALI_CACHE_FLUSH_JOB_SECTION_HEADER_unpack MALI_JOB_HEADER_unpack
#define MALI_CACHE_FLUSH_JOB_SECTION_HEADER_print MALI_JOB_HEADER_print
#define MALI_CACHE_FLUSH_JOB_SECTION_HEADER_OFFSET 0
#define MALI_CACHE_FLUSH_JOB_SECTION_PAYLOAD_TYPE struct MALI_CACHE_FLUSH_JOB_PAYLOAD
#define MALI_CACHE_FLUSH_JOB_SECTION_PAYLOAD_PACKED_TYPE MALI_CACHE_FLUSH_JOB_PAYLOAD_PACKED_T
#define MALI_CACHE_FLUSH_JOB_SECTION_PAYLOAD_header MALI_CACHE_FLUSH_JOB_PAYLOAD_header
#define MALI_CACHE_FLUSH_JOB_SECTION_PAYLOAD_pack MALI_CACHE_FLUSH_JOB_PAYLOAD_pack
#define MALI_CACHE_FLUSH_JOB_SECTION_PAYLOAD_unpack MALI_CACHE_FLUSH_JOB_PAYLOAD_unpack
#define MALI_CACHE_FLUSH_JOB_SECTION_PAYLOAD_print MALI_CACHE_FLUSH_JOB_PAYLOAD_print
#define MALI_CACHE_FLUSH_JOB_SECTION_PAYLOAD_OFFSET 32

struct MALI_COMPUTE_JOB_PARAMETERS {
   uint32_t                             job_task_split;
};

#define MALI_COMPUTE_JOB_PARAMETERS_header      \
   0

#define MALI_COMPUTE_JOB_PARAMETERS_LENGTH 24
struct mali_compute_job_parameters_packed { uint32_t opaque[6]; };
#define MALI_COMPUTE_JOB_PARAMETERS_PACKED_T struct mali_compute_job_parameters_packed
#define MALI_COMPUTE_JOB_PARAMETERS_pack(__packed, __unpacked) \
do { \
   MALI_COMPUTE_JOB_PARAMETERS_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_uint((__unpacked)->job_task_split, 26, 29); \
   __tmp_packed.opaque[ 1] = 0; \
   __tmp_packed.opaque[ 2] = 0; \
   __tmp_packed.opaque[ 3] = 0; \
   __tmp_packed.opaque[ 4] = 0; \
   __tmp_packed.opaque[ 5] = 0; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_COMPUTE_JOB_PARAMETERS_unpack(__packed, __unpacked) \
do { \
   MALI_COMPUTE_JOB_PARAMETERS_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xc3ffffff) fprintf(stderr, "XXX: Invalid field of Compute Job Parameters unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Compute Job Parameters unpacked at word 1\n"); \
   if (__tmp_packed.opaque[2] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Compute Job Parameters unpacked at word 2\n"); \
   if (__tmp_packed.opaque[3] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Compute Job Parameters unpacked at word 3\n"); \
   if (__tmp_packed.opaque[4] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Compute Job Parameters unpacked at word 4\n"); \
   if (__tmp_packed.opaque[5] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Compute Job Parameters unpacked at word 5\n"); \
   __gen_unpack_uint((__unpacked)->job_task_split, &__tmp_packed.opaque[0], 26, 29); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_COMPUTE_JOB_PARAMETERS_print(FILE *fp, const struct MALI_COMPUTE_JOB_PARAMETERS * values, unsigned indent)
{
   fprintf(fp, "%*sJob Task Split: %u\n", indent, "", values->job_task_split);
}

#endif
struct MALI_COMPUTE_PADDING {
   int dummy;
};

#define MALI_COMPUTE_PADDING_header             \
   0

#define MALI_COMPUTE_PADDING_LENGTH 8
struct mali_compute_padding_packed { uint32_t opaque[2]; };
#define MALI_COMPUTE_PADDING_PACKED_T struct mali_compute_padding_packed
#define MALI_COMPUTE_PADDING_pack(__packed, __unpacked) \
do { \
   MALI_COMPUTE_PADDING_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = 0; \
   __tmp_packed.opaque[ 1] = 0; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_COMPUTE_PADDING_unpack(__packed, __unpacked) \
do { \
   MALI_COMPUTE_PADDING_PACKED_T __tmp_packed = *(__packed); \
   if (__tmp_packed.opaque[0] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Compute Padding unpacked at word 0\n"); \
   if (__tmp_packed.opaque[1] & 0xffffffff) fprintf(stderr, "XXX: Invalid field of Compute Padding unpacked at word 1\n"); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_COMPUTE_PADDING_print(FILE *fp, const struct MALI_COMPUTE_PADDING * values, unsigned indent)
{
}

#endif
struct mali_compute_job_packed {
   uint32_t opaque[48];
};

#define MALI_COMPUTE_JOB_PACKED_T struct mali_compute_job_packed
#define MALI_COMPUTE_JOB_LENGTH 192
#define MALI_COMPUTE_JOB_ALIGN 64
#define MALI_COMPUTE_JOB_SECTION_HEADER_TYPE struct MALI_JOB_HEADER
#define MALI_COMPUTE_JOB_SECTION_HEADER_PACKED_TYPE MALI_JOB_HEADER_PACKED_T
#define MALI_COMPUTE_JOB_SECTION_HEADER_header MALI_JOB_HEADER_header
#define MALI_COMPUTE_JOB_SECTION_HEADER_pack MALI_JOB_HEADER_pack
#define MALI_COMPUTE_JOB_SECTION_HEADER_unpack MALI_JOB_HEADER_unpack
#define MALI_COMPUTE_JOB_SECTION_HEADER_print MALI_JOB_HEADER_print
#define MALI_COMPUTE_JOB_SECTION_HEADER_OFFSET 0
#define MALI_COMPUTE_JOB_SECTION_INVOCATION_TYPE struct MALI_INVOCATION
#define MALI_COMPUTE_JOB_SECTION_INVOCATION_PACKED_TYPE MALI_INVOCATION_PACKED_T
#define MALI_COMPUTE_JOB_SECTION_INVOCATION_header MALI_INVOCATION_header
#define MALI_COMPUTE_JOB_SECTION_INVOCATION_pack MALI_INVOCATION_pack
#define MALI_COMPUTE_JOB_SECTION_INVOCATION_unpack MALI_INVOCATION_unpack
#define MALI_COMPUTE_JOB_SECTION_INVOCATION_print MALI_INVOCATION_print
#define MALI_COMPUTE_JOB_SECTION_INVOCATION_OFFSET 32
#define MALI_COMPUTE_JOB_SECTION_PARAMETERS_TYPE struct MALI_COMPUTE_JOB_PARAMETERS
#define MALI_COMPUTE_JOB_SECTION_PARAMETERS_PACKED_TYPE MALI_COMPUTE_JOB_PARAMETERS_PACKED_T
#define MALI_COMPUTE_JOB_SECTION_PARAMETERS_header MALI_COMPUTE_JOB_PARAMETERS_header
#define MALI_COMPUTE_JOB_SECTION_PARAMETERS_pack MALI_COMPUTE_JOB_PARAMETERS_pack
#define MALI_COMPUTE_JOB_SECTION_PARAMETERS_unpack MALI_COMPUTE_JOB_PARAMETERS_unpack
#define MALI_COMPUTE_JOB_SECTION_PARAMETERS_print MALI_COMPUTE_JOB_PARAMETERS_print
#define MALI_COMPUTE_JOB_SECTION_PARAMETERS_OFFSET 40
#define MALI_COMPUTE_JOB_SECTION_DRAW_TYPE struct MALI_DRAW
#define MALI_COMPUTE_JOB_SECTION_DRAW_PACKED_TYPE MALI_DRAW_PACKED_T
#define MALI_COMPUTE_JOB_SECTION_DRAW_header MALI_DRAW_header
#define MALI_COMPUTE_JOB_SECTION_DRAW_pack MALI_DRAW_pack
#define MALI_COMPUTE_JOB_SECTION_DRAW_unpack MALI_DRAW_unpack
#define MALI_COMPUTE_JOB_SECTION_DRAW_print MALI_DRAW_print
#define MALI_COMPUTE_JOB_SECTION_DRAW_OFFSET 64
#define MALI_COMPUTE_JOB_SECTION_COMPUTE_PADDING_TYPE struct MALI_COMPUTE_PADDING
#define MALI_COMPUTE_JOB_SECTION_COMPUTE_PADDING_PACKED_TYPE MALI_COMPUTE_PADDING_PACKED_T
#define MALI_COMPUTE_JOB_SECTION_COMPUTE_PADDING_header MALI_COMPUTE_PADDING_header
#define MALI_COMPUTE_JOB_SECTION_COMPUTE_PADDING_pack MALI_COMPUTE_PADDING_pack
#define MALI_COMPUTE_JOB_SECTION_COMPUTE_PADDING_unpack MALI_COMPUTE_PADDING_unpack
#define MALI_COMPUTE_JOB_SECTION_COMPUTE_PADDING_print MALI_COMPUTE_PADDING_print
#define MALI_COMPUTE_JOB_SECTION_COMPUTE_PADDING_OFFSET 184

struct MALI_PRIMITIVE_SIZE {
   float                                fixed_sized;
   uint64_t                             size_array;
};

#define MALI_PRIMITIVE_SIZE_header              \
   0

#define MALI_PRIMITIVE_SIZE_LENGTH 8
struct mali_primitive_size_packed { uint32_t opaque[2]; };
#define MALI_PRIMITIVE_SIZE_PACKED_T struct mali_primitive_size_packed
#define MALI_PRIMITIVE_SIZE_pack(__packed, __unpacked) \
do { \
   MALI_PRIMITIVE_SIZE_PACKED_T __tmp_packed; \
   __tmp_packed.opaque[ 0] = util_bitpack_float((__unpacked)->fixed_sized) | \
            util_bitpack_uint((__unpacked)->size_array, 0, 63); \
   __tmp_packed.opaque[ 1] = util_bitpack_uint((__unpacked)->size_array, 0, 63) >> 32; \
   *(__packed) = __tmp_packed; \
} while (0);

#define MALI_PRIMITIVE_SIZE_unpack(__packed, __unpacked) \
do { \
   MALI_PRIMITIVE_SIZE_PACKED_T __tmp_packed = *(__packed); \
   __gen_unpack_float((__unpacked)->fixed_sized, &__tmp_packed.opaque[0], 0, 31); \
   __gen_unpack_uint((__unpacked)->size_array, &__tmp_packed.opaque[0], 0, 63); \
} while (0);

#ifndef __OPENCL_VERSION__
static inline void
MALI_PRIMITIVE_SIZE_print(FILE *fp, const struct MALI_PRIMITIVE_SIZE * values, unsigned indent)
{
   fprintf(fp, "%*sFixed Sized: %f\n", indent, "", values->fixed_sized);
   fprintf(fp, "%*sSize Array: 0x%" PRIx64 "\n", indent, "", values->size_array);
}

#endif
struct mali_tiler_job_packed {
   uint32_t opaque[48];
};

#define MALI_TILER_JOB_PACKED_T struct mali_tiler_job_packed
#define MALI_TILER_JOB_LENGTH 192
#define MALI_TILER_JOB_ALIGN 64
#define MALI_TILER_JOB_SECTION_HEADER_TYPE struct MALI_JOB_HEADER
#define MALI_TILER_JOB_SECTION_HEADER_PACKED_TYPE MALI_JOB_HEADER_PACKED_T
#define MALI_TILER_JOB_SECTION_HEADER_header MALI_JOB_HEADER_header
#define MALI_TILER_JOB_SECTION_HEADER_pack MALI_JOB_HEADER_pack
#define MALI_TILER_JOB_SECTION_HEADER_unpack MALI_JOB_HEADER_unpack
#define MALI_TILER_JOB_SECTION_HEADER_print MALI_JOB_HEADER_print
#define MALI_TILER_JOB_SECTION_HEADER_OFFSET 0
#define MALI_TILER_JOB_SECTION_INVOCATION_TYPE struct MALI_INVOCATION
#define MALI_TILER_JOB_SECTION_INVOCATION_PACKED_TYPE MALI_INVOCATION_PACKED_T
#define MALI_TILER_JOB_SECTION_INVOCATION_header MALI_INVOCATION_header
#define MALI_TILER_JOB_SECTION_INVOCATION_pack MALI_INVOCATION_pack
#define MALI_TILER_JOB_SECTION_INVOCATION_unpack MALI_INVOCATION_unpack
#define MALI_TILER_JOB_SECTION_INVOCATION_print MALI_INVOCATION_print
#define MALI_TILER_JOB_SECTION_INVOCATION_OFFSET 32
#define MALI_TILER_JOB_SECTION_PRIMITIVE_TYPE struct MALI_PRIMITIVE
#define MALI_TILER_JOB_SECTION_PRIMITIVE_PACKED_TYPE MALI_PRIMITIVE_PACKED_T
#define MALI_TILER_JOB_SECTION_PRIMITIVE_header MALI_PRIMITIVE_header
#define MALI_TILER_JOB_SECTION_PRIMITIVE_pack MALI_PRIMITIVE_pack
#define MALI_TILER_JOB_SECTION_PRIMITIVE_unpack MALI_PRIMITIVE_unpack
#define MALI_TILER_JOB_SECTION_PRIMITIVE_print MALI_PRIMITIVE_print
#define MALI_TILER_JOB_SECTION_PRIMITIVE_OFFSET 40
#define MALI_TILER_JOB_SECTION_DRAW_TYPE struct MALI_DRAW
#define MALI_TILER_JOB_SECTION_DRAW_PACKED_TYPE MALI_DRAW_PACKED_T
#define MALI_TILER_JOB_SECTION_DRAW_header MALI_DRAW_header
#define MALI_TILER_JOB_SECTION_DRAW_pack MALI_DRAW_pack
#define MALI_TILER_JOB_SECTION_DRAW_unpack MALI_DRAW_unpack
#define MALI_TILER_JOB_SECTION_DRAW_print MALI_DRAW_print
#define MALI_TILER_JOB_SECTION_DRAW_OFFSET 64
#define MALI_TILER_JOB_SECTION_PRIMITIVE_SIZE_TYPE struct MALI_PRIMITIVE_SIZE
#define MALI_TILER_JOB_SECTION_PRIMITIVE_SIZE_PACKED_TYPE MALI_PRIMITIVE_SIZE_PACKED_T
#define MALI_TILER_JOB_SECTION_PRIMITIVE_SIZE_header MALI_PRIMITIVE_SIZE_header
#define MALI_TILER_JOB_SECTION_PRIMITIVE_SIZE_pack MALI_PRIMITIVE_SIZE_pack
#define MALI_TILER_JOB_SECTION_PRIMITIVE_SIZE_unpack MALI_PRIMITIVE_SIZE_unpack
#define MALI_TILER_JOB_SECTION_PRIMITIVE_SIZE_print MALI_PRIMITIVE_SIZE_print
#define MALI_TILER_JOB_SECTION_PRIMITIVE_SIZE_OFFSET 184

#endif
