/* FILE GENERATED BY /build/naev/src/naev-0.13.3/build/../src/shaders_c_gen.py */
#include <string.h>
#include "shaders.gen.h"
#include "opengl_shader.h"

Shaders shaders;

static int nsimpleshaders = 0;

static int shaders_cmp( const void *p1, const void *p2 )
{
   const SimpleShader **s1 = (const SimpleShader**) p1;
   const SimpleShader **s2 = (const SimpleShader**) p2;
   return strcmp( (*s1)->name, (*s2)->name );
}

static int shaders_loadSimple( const char *name, SimpleShader *shd, const char *fs_path )
{
   shd->name   = name;
   shd->program = gl_program_vert_frag( "project_pos.vert", fs_path );
   shd->vertex = glGetAttribLocation( shd->program, "vertex" );
   shd->projection = glGetUniformLocation( shd->program, "projection" );
   shd->colour  = glGetUniformLocation( shd->program, "colour" );
   shd->dimensions = glGetUniformLocation( shd->program, "dimensions" );
   shd->dt     = glGetUniformLocation( shd->program, "dt" );
   shd->paramf = glGetUniformLocation( shd->program, "paramf" );
   shd->parami = glGetUniformLocation( shd->program, "parami" );
   shd->paramv = glGetUniformLocation( shd->program, "paramv" );

   /* Add to list. */
   shaders.simple_shaders[ nsimpleshaders++ ] = shd;

   return 0;
}

const SimpleShader *shaders_getSimple( const char *name )
{
   const SimpleShader shd = { .name=name };
   const SimpleShader *shdptr = &shd;
   const SimpleShader **found = bsearch( &shdptr, shaders.simple_shaders, nsimpleshaders, sizeof(SimpleShader*), shaders_cmp );
   if (found!=NULL)
      return *found;
   return NULL;
}

void shaders_load (void) {
   Uint64 time = SDL_GetTicks();
   shaders_loadSimple( "astaura", &shaders.astaura, "astaura.frag" );
   shaders_loadSimple( "asteroidmarker", &shaders.asteroidmarker, "asteroidmarker.frag" );
   shaders.beam.program = gl_program_vert_frag("project_pos.vert", "beam.frag");
   shaders.beam.vertex = glGetAttribLocation(shaders.beam.program, "vertex");
   shaders.beam.projection = glGetUniformLocation(shaders.beam.program, "projection");
   shaders.beam.colour = glGetUniformLocation(shaders.beam.program, "colour");
   shaders.beam.dt = glGetUniformLocation(shaders.beam.program, "dt");
   shaders.beam.r = glGetUniformLocation(shaders.beam.program, "r");
   shaders.beam.dimensions = glGetUniformLocation(shaders.beam.program, "dimensions");
   if (gl_has( OPENGL_SUBROUTINES )) {
      shaders.beam.beam_func.uniform = glGetSubroutineUniformLocation( shaders.beam.program, GL_FRAGMENT_SHADER, "beam_func" );
      shaders.beam.beam_func.beam_default = glGetSubroutineIndex( shaders.beam.program, GL_FRAGMENT_SHADER, "beam_default" );
      shaders.beam.beam_func.beam_wave = glGetSubroutineIndex( shaders.beam.program, GL_FRAGMENT_SHADER, "beam_wave" );
      shaders.beam.beam_func.beam_arc = glGetSubroutineIndex( shaders.beam.program, GL_FRAGMENT_SHADER, "beam_arc" );
      shaders.beam.beam_func.beam_helix = glGetSubroutineIndex( shaders.beam.program, GL_FRAGMENT_SHADER, "beam_helix" );
      shaders.beam.beam_func.beam_organic = glGetSubroutineIndex( shaders.beam.program, GL_FRAGMENT_SHADER, "beam_organic" );
      shaders.beam.beam_func.beam_unstable = glGetSubroutineIndex( shaders.beam.program, GL_FRAGMENT_SHADER, "beam_unstable" );
      shaders.beam.beam_func.beam_fuzzy = glGetSubroutineIndex( shaders.beam.program, GL_FRAGMENT_SHADER, "beam_fuzzy" );
   }

   shaders_loadSimple( "blinkmarker", &shaders.blinkmarker, "blinkmarker.frag" );
   shaders_loadSimple( "circle", &shaders.circle, "circle.frag" );
   shaders.colourblind_correct.program = gl_program_vert_frag("postprocess.vert", "colourblind.frag");
   shaders.colourblind_correct.VertexPosition = glGetAttribLocation(shaders.colourblind_correct.program, "VertexPosition");
   shaders.colourblind_correct.ClipSpaceFromLocal = glGetUniformLocation(shaders.colourblind_correct.program, "ClipSpaceFromLocal");
   shaders.colourblind_correct.MainTex = glGetUniformLocation(shaders.colourblind_correct.program, "MainTex");
   shaders.colourblind_correct.type = glGetUniformLocation(shaders.colourblind_correct.program, "type");
   shaders.colourblind_correct.intensity = glGetUniformLocation(shaders.colourblind_correct.program, "intensity");

   shaders.colourblind_sim.program = gl_program_vert_frag("postprocess.vert", "colourblind_sim.frag");
   shaders.colourblind_sim.VertexPosition = glGetAttribLocation(shaders.colourblind_sim.program, "VertexPosition");
   shaders.colourblind_sim.ClipSpaceFromLocal = glGetUniformLocation(shaders.colourblind_sim.program, "ClipSpaceFromLocal");
   shaders.colourblind_sim.MainTex = glGetUniformLocation(shaders.colourblind_sim.program, "MainTex");
   shaders.colourblind_sim.type = glGetUniformLocation(shaders.colourblind_sim.program, "type");
   shaders.colourblind_sim.intensity = glGetUniformLocation(shaders.colourblind_sim.program, "intensity");

   shaders_loadSimple( "crosshairs", &shaders.crosshairs, "crosshairs.frag" );
   shaders.damage.program = gl_program_vert_frag("postprocess.vert", "damage.frag");
   shaders.damage.VertexPosition = glGetAttribLocation(shaders.damage.program, "VertexPosition");
   shaders.damage.ClipSpaceFromLocal = glGetUniformLocation(shaders.damage.program, "ClipSpaceFromLocal");
   shaders.damage.MainTex = glGetUniformLocation(shaders.damage.program, "MainTex");
   shaders.damage.damage_strength = glGetUniformLocation(shaders.damage.program, "damage_strength");
   shaders.damage.love_ScreenSize = glGetUniformLocation(shaders.damage.program, "love_ScreenSize");

   shaders.dust.program = gl_program_vert_frag("dust.vert", "dust.frag");
   shaders.dust.shape = glGetAttribLocation(shaders.dust.program, "shape");
   shaders.dust.vertex = glGetAttribLocation(shaders.dust.program, "vertex");
   shaders.dust.brightness = glGetAttribLocation(shaders.dust.program, "brightness");
   shaders.dust.projection = glGetUniformLocation(shaders.dust.program, "projection");
   shaders.dust.offset_xy = glGetUniformLocation(shaders.dust.program, "offset_xy");
   shaders.dust.dims = glGetUniformLocation(shaders.dust.program, "dims");
   shaders.dust.screen = glGetUniformLocation(shaders.dust.program, "screen");
   shaders.dust.use_lines = glGetUniformLocation(shaders.dust.program, "use_lines");

   shaders_loadSimple( "factiondisk", &shaders.factiondisk, "factiondisk.frag" );
   shaders.font.program = gl_program_vert_frag("font.vert", "font.frag");
   shaders.font.vertex = glGetAttribLocation(shaders.font.program, "vertex");
   shaders.font.tex_coord = glGetAttribLocation(shaders.font.program, "tex_coord");
   shaders.font.projection = glGetUniformLocation(shaders.font.program, "projection");
   shaders.font.m = glGetUniformLocation(shaders.font.program, "m");
   shaders.font.colour = glGetUniformLocation(shaders.font.program, "colour");
   shaders.font.outline_colour = glGetUniformLocation(shaders.font.program, "outline_colour");

   shaders.gamma_correction.program = gl_program_vert_frag("postprocess.vert", "gamma_correction.frag");
   shaders.gamma_correction.VertexPosition = glGetAttribLocation(shaders.gamma_correction.program, "VertexPosition");
   shaders.gamma_correction.ClipSpaceFromLocal = glGetUniformLocation(shaders.gamma_correction.program, "ClipSpaceFromLocal");
   shaders.gamma_correction.MainTex = glGetUniformLocation(shaders.gamma_correction.program, "MainTex");
   shaders.gamma_correction.gamma = glGetUniformLocation(shaders.gamma_correction.program, "gamma");

   shaders_loadSimple( "gear", &shaders.gear, "gear.frag" );
   shaders_loadSimple( "healthbar", &shaders.healthbar, "healthbar.frag" );
   shaders_loadSimple( "hilight", &shaders.hilight, "hilight.frag" );
   shaders_loadSimple( "hilight_circle", &shaders.hilight_circle, "hilight_circle.frag" );
   shaders_loadSimple( "iflockon", &shaders.iflockon, "iflockon.frag" );
   shaders.jump.program = gl_program_vert_frag("project_pos.vert", "jump.frag");
   shaders.jump.vertex = glGetAttribLocation(shaders.jump.program, "vertex");
   shaders.jump.projection = glGetUniformLocation(shaders.jump.program, "projection");
   shaders.jump.progress = glGetUniformLocation(shaders.jump.program, "progress");
   shaders.jump.direction = glGetUniformLocation(shaders.jump.program, "direction");
   shaders.jump.dimensions = glGetUniformLocation(shaders.jump.program, "dimensions");
   shaders.jump.brightness = glGetUniformLocation(shaders.jump.program, "brightness");
   if (gl_has( OPENGL_SUBROUTINES )) {
      shaders.jump.jump_func.uniform = glGetSubroutineUniformLocation( shaders.jump.program, GL_FRAGMENT_SHADER, "jump_func" );
      shaders.jump.jump_func.jump_default = glGetSubroutineIndex( shaders.jump.program, GL_FRAGMENT_SHADER, "jump_default" );
      shaders.jump.jump_func.jump_nebula = glGetSubroutineIndex( shaders.jump.program, GL_FRAGMENT_SHADER, "jump_nebula" );
      shaders.jump.jump_func.jump_organic = glGetSubroutineIndex( shaders.jump.program, GL_FRAGMENT_SHADER, "jump_organic" );
      shaders.jump.jump_func.jump_circular = glGetSubroutineIndex( shaders.jump.program, GL_FRAGMENT_SHADER, "jump_circular" );
      shaders.jump.jump_func.jump_wind = glGetSubroutineIndex( shaders.jump.program, GL_FRAGMENT_SHADER, "jump_wind" );
   }

   shaders_loadSimple( "jumplane", &shaders.jumplane, "jumplane.frag" );
   shaders_loadSimple( "jumplanegoto", &shaders.jumplanegoto, "jumplanegoto.frag" );
   shaders_loadSimple( "jumpmarker", &shaders.jumpmarker, "jumpmarker.frag" );
   shaders.lines.program = gl_program_vert_frag("lines.vert", "lines.frag");
   shaders.lines.vertex = glGetAttribLocation(shaders.lines.program, "vertex");
   shaders.lines.projection = glGetUniformLocation(shaders.lines.program, "projection");
   shaders.lines.colour = glGetUniformLocation(shaders.lines.program, "colour");

   shaders.nebula_map.program = gl_program_vert_frag("system_map.vert", "nebula_map.frag");
   shaders.nebula_map.vertex = glGetAttribLocation(shaders.nebula_map.program, "vertex");
   shaders.nebula_map.projection = glGetUniformLocation(shaders.nebula_map.program, "projection");
   shaders.nebula_map.hue = glGetUniformLocation(shaders.nebula_map.program, "hue");
   shaders.nebula_map.time = glGetUniformLocation(shaders.nebula_map.program, "time");
   shaders.nebula_map.globalpos = glGetUniformLocation(shaders.nebula_map.program, "globalpos");
   shaders.nebula_map.alpha = glGetUniformLocation(shaders.nebula_map.program, "alpha");
   shaders.nebula_map.volatility = glGetUniformLocation(shaders.nebula_map.program, "volatility");

   shaders_loadSimple( "notemarker", &shaders.notemarker, "notemarker.frag" );
   shaders.outline.program = gl_program_vert_frag("project_pos.vert", "outline.frag");
   shaders.outline.vertex = glGetAttribLocation(shaders.outline.program, "vertex");
   shaders.outline.projection = glGetUniformLocation(shaders.outline.program, "projection");
   shaders.outline.colour = glGetUniformLocation(shaders.outline.program, "colour");
   shaders.outline.border = glGetUniformLocation(shaders.outline.program, "border");

   shaders_loadSimple( "pilotmarker", &shaders.pilotmarker, "pilotmarker.frag" );
   shaders_loadSimple( "pilotscanning", &shaders.pilotscanning, "pilotscanning.frag" );
   shaders_loadSimple( "playermarker", &shaders.playermarker, "playermarker.frag" );
   shaders.points.program = gl_program_vert_frag("points.vert", "points.frag");
   shaders.points.vertex = glGetAttribLocation(shaders.points.program, "vertex");
   shaders.points.vertex_colour = glGetAttribLocation(shaders.points.program, "vertex_colour");
   shaders.points.projection = glGetUniformLocation(shaders.points.program, "projection");
   shaders.points.pointsize = glGetUniformLocation(shaders.points.program, "pointsize");

   shaders.resize.program = gl_program_vert_frag("texture.vert", "magic.frag");
   shaders.resize.vertex = glGetAttribLocation(shaders.resize.program, "vertex");
   shaders.resize.tex_mat = glGetUniformLocation(shaders.resize.program, "tex_mat");
   shaders.resize.projection = glGetUniformLocation(shaders.resize.program, "projection");
   shaders.resize.tex = glGetUniformLocation(shaders.resize.program, "tex");
   shaders.resize.u_scale = glGetUniformLocation(shaders.resize.program, "u_scale");
   shaders.resize.u_radius = glGetUniformLocation(shaders.resize.program, "u_radius");

   shaders_loadSimple( "safelane", &shaders.safelane, "safelane.frag" );
   shaders_loadSimple( "sdfsolid", &shaders.sdfsolid, "sdfsolid.frag" );
   shaders_loadSimple( "selectposition", &shaders.selectposition, "selectposition.frag" );
   shaders_loadSimple( "selectspob", &shaders.selectspob, "selectspob.frag" );
   shaders.shake.program = gl_program_vert_frag("postprocess.vert", "shake.frag");
   shaders.shake.VertexPosition = glGetAttribLocation(shaders.shake.program, "VertexPosition");
   shaders.shake.ClipSpaceFromLocal = glGetUniformLocation(shaders.shake.program, "ClipSpaceFromLocal");
   shaders.shake.MainTex = glGetUniformLocation(shaders.shake.program, "MainTex");
   shaders.shake.shake_pos = glGetUniformLocation(shaders.shake.program, "shake_pos");
   shaders.shake.shake_vel = glGetUniformLocation(shaders.shake.program, "shake_vel");
   shaders.shake.shake_force = glGetUniformLocation(shaders.shake.program, "shake_force");

   shaders_loadSimple( "shop_bg", &shaders.shop_bg, "shop_bg.frag" );
   shaders.solid.program = gl_program_vert_frag("project.vert", "solid.frag");
   shaders.solid.vertex = glGetAttribLocation(shaders.solid.program, "vertex");
   shaders.solid.projection = glGetUniformLocation(shaders.solid.program, "projection");
   shaders.solid.colour = glGetUniformLocation(shaders.solid.program, "colour");

   shaders_loadSimple( "spobmarker_earth", &shaders.spobmarker_earth, "spobmarker_earth.frag" );
   shaders_loadSimple( "spobmarker_empty", &shaders.spobmarker_empty, "spobmarker_empty.frag" );
   shaders_loadSimple( "spobmarker_obelisk", &shaders.spobmarker_obelisk, "spobmarker_obelisk.frag" );
   shaders_loadSimple( "spobmarker_rhombus", &shaders.spobmarker_rhombus, "spobmarker_rhombus.frag" );
   shaders_loadSimple( "spobmarker_triangle", &shaders.spobmarker_triangle, "spobmarker_triangle.frag" );
   shaders_loadSimple( "spobmarker_uninhabited", &shaders.spobmarker_uninhabited, "spobmarker_uninhabited.frag" );
   shaders_loadSimple( "spobmarker_wormhole", &shaders.spobmarker_wormhole, "spobmarker_wormhole.frag" );
   shaders_loadSimple( "status", &shaders.status, "status.frag" );
   shaders_loadSimple( "stealthaura", &shaders.stealthaura, "stealthaura.frag" );
   shaders_loadSimple( "stealthmarker", &shaders.stealthmarker, "stealthmarker.frag" );
   shaders.stealthoverlay.program = gl_program_vert_frag("texture.vert", "stealthoverlay.frag");
   shaders.stealthoverlay.vertex = glGetAttribLocation(shaders.stealthoverlay.program, "vertex");
   shaders.stealthoverlay.projection = glGetUniformLocation(shaders.stealthoverlay.program, "projection");
   shaders.stealthoverlay.colour = glGetUniformLocation(shaders.stealthoverlay.program, "colour");
   shaders.stealthoverlay.tex_mat = glGetUniformLocation(shaders.stealthoverlay.program, "tex_mat");

   shaders_loadSimple( "sysmarker", &shaders.sysmarker, "sysmarker.frag" );
   shaders_loadSimple( "targetship", &shaders.targetship, "targetship.frag" );
   shaders_loadSimple( "targetspob", &shaders.targetspob, "targetspob.frag" );
   shaders.texture.program = gl_program_vert_frag("texture.vert", "texture.frag");
   shaders.texture.vertex = glGetAttribLocation(shaders.texture.program, "vertex");
   shaders.texture.projection = glGetUniformLocation(shaders.texture.program, "projection");
   shaders.texture.colour = glGetUniformLocation(shaders.texture.program, "colour");
   shaders.texture.tex_mat = glGetUniformLocation(shaders.texture.program, "tex_mat");
   shaders.texture.sampler = glGetUniformLocation(shaders.texture.program, "sampler");

   shaders.texture_bicubic.program = gl_program_vert_frag("texture.vert", "texture_bicubic.frag");
   shaders.texture_bicubic.vertex = glGetAttribLocation(shaders.texture_bicubic.program, "vertex");
   shaders.texture_bicubic.projection = glGetUniformLocation(shaders.texture_bicubic.program, "projection");
   shaders.texture_bicubic.tex_mat = glGetUniformLocation(shaders.texture_bicubic.program, "tex_mat");
   shaders.texture_bicubic.sampler = glGetUniformLocation(shaders.texture_bicubic.program, "sampler");

   shaders.texture_depth.program = gl_program_vert_frag("texture.vert", "texture_depth.frag");
   shaders.texture_depth.vertex = glGetAttribLocation(shaders.texture_depth.program, "vertex");
   shaders.texture_depth.projection = glGetUniformLocation(shaders.texture_depth.program, "projection");
   shaders.texture_depth.colour = glGetUniformLocation(shaders.texture_depth.program, "colour");
   shaders.texture_depth.tex_mat = glGetUniformLocation(shaders.texture_depth.program, "tex_mat");
   shaders.texture_depth.sampler = glGetUniformLocation(shaders.texture_depth.program, "sampler");
   shaders.texture_depth.depth = glGetUniformLocation(shaders.texture_depth.program, "depth");

   shaders.texture_depth_only.program = gl_program_vert_frag("texture.vert", "texture_depth_only.frag");
   shaders.texture_depth_only.vertex = glGetAttribLocation(shaders.texture_depth_only.program, "vertex");
   shaders.texture_depth_only.projection = glGetUniformLocation(shaders.texture_depth_only.program, "projection");
   shaders.texture_depth_only.tex_mat = glGetUniformLocation(shaders.texture_depth_only.program, "tex_mat");
   shaders.texture_depth_only.sampler = glGetUniformLocation(shaders.texture_depth_only.program, "sampler");

   shaders.texture_interpolate.program = gl_program_vert_frag("texture.vert", "texture_interpolate.frag");
   shaders.texture_interpolate.vertex = glGetAttribLocation(shaders.texture_interpolate.program, "vertex");
   shaders.texture_interpolate.projection = glGetUniformLocation(shaders.texture_interpolate.program, "projection");
   shaders.texture_interpolate.colour = glGetUniformLocation(shaders.texture_interpolate.program, "colour");
   shaders.texture_interpolate.tex_mat = glGetUniformLocation(shaders.texture_interpolate.program, "tex_mat");
   shaders.texture_interpolate.sampler1 = glGetUniformLocation(shaders.texture_interpolate.program, "sampler1");
   shaders.texture_interpolate.sampler2 = glGetUniformLocation(shaders.texture_interpolate.program, "sampler2");
   shaders.texture_interpolate.inter = glGetUniformLocation(shaders.texture_interpolate.program, "inter");

   shaders.texture_sharpen.program = gl_program_vert_frag("texture.vert", "texture_sharpen.frag");
   shaders.texture_sharpen.vertex = glGetAttribLocation(shaders.texture_sharpen.program, "vertex");
   shaders.texture_sharpen.projection = glGetUniformLocation(shaders.texture_sharpen.program, "projection");
   shaders.texture_sharpen.colour = glGetUniformLocation(shaders.texture_sharpen.program, "colour");
   shaders.texture_sharpen.tex_mat = glGetUniformLocation(shaders.texture_sharpen.program, "tex_mat");
   shaders.texture_sharpen.sampler = glGetUniformLocation(shaders.texture_sharpen.program, "sampler");

   shaders.texturesdf.program = gl_program_vert_frag("texturesdf.vert", "texturesdf.frag");
   shaders.texturesdf.vertex = glGetAttribLocation(shaders.texturesdf.program, "vertex");
   shaders.texturesdf.projection = glGetUniformLocation(shaders.texturesdf.program, "projection");
   shaders.texturesdf.colour = glGetUniformLocation(shaders.texturesdf.program, "colour");
   shaders.texturesdf.tex_mat = glGetUniformLocation(shaders.texturesdf.program, "tex_mat");
   shaders.texturesdf.sampler = glGetUniformLocation(shaders.texturesdf.program, "sampler");
   shaders.texturesdf.m = glGetUniformLocation(shaders.texturesdf.program, "m");
   shaders.texturesdf.outline = glGetUniformLocation(shaders.texturesdf.program, "outline");

   shaders_loadSimple( "viewport_frame", &shaders.viewport_frame, "viewport_frame.frag" );
   if (conf.devmode) {
      time = SDL_GetTicks() - time;
      DEBUG( n_("Loaded %d Shader in %.3f s", "Loaded %d Shaders in %.3f s", NUM_SHADERS ), NUM_SHADERS, time/1000. );
   }
   else
      DEBUG( n_("Loaded %d Shader", "Loaded %d Shaders", NUM_SHADERS ), NUM_SHADERS );
}

void shaders_unload (void) {
   glDeleteProgram(shaders.astaura.program);
   glDeleteProgram(shaders.asteroidmarker.program);
   glDeleteProgram(shaders.beam.program);
   glDeleteProgram(shaders.blinkmarker.program);
   glDeleteProgram(shaders.circle.program);
   glDeleteProgram(shaders.colourblind_correct.program);
   glDeleteProgram(shaders.colourblind_sim.program);
   glDeleteProgram(shaders.crosshairs.program);
   glDeleteProgram(shaders.damage.program);
   glDeleteProgram(shaders.dust.program);
   glDeleteProgram(shaders.factiondisk.program);
   glDeleteProgram(shaders.font.program);
   glDeleteProgram(shaders.gamma_correction.program);
   glDeleteProgram(shaders.gear.program);
   glDeleteProgram(shaders.healthbar.program);
   glDeleteProgram(shaders.hilight.program);
   glDeleteProgram(shaders.hilight_circle.program);
   glDeleteProgram(shaders.iflockon.program);
   glDeleteProgram(shaders.jump.program);
   glDeleteProgram(shaders.jumplane.program);
   glDeleteProgram(shaders.jumplanegoto.program);
   glDeleteProgram(shaders.jumpmarker.program);
   glDeleteProgram(shaders.lines.program);
   glDeleteProgram(shaders.nebula_map.program);
   glDeleteProgram(shaders.notemarker.program);
   glDeleteProgram(shaders.outline.program);
   glDeleteProgram(shaders.pilotmarker.program);
   glDeleteProgram(shaders.pilotscanning.program);
   glDeleteProgram(shaders.playermarker.program);
   glDeleteProgram(shaders.points.program);
   glDeleteProgram(shaders.resize.program);
   glDeleteProgram(shaders.safelane.program);
   glDeleteProgram(shaders.sdfsolid.program);
   glDeleteProgram(shaders.selectposition.program);
   glDeleteProgram(shaders.selectspob.program);
   glDeleteProgram(shaders.shake.program);
   glDeleteProgram(shaders.shop_bg.program);
   glDeleteProgram(shaders.solid.program);
   glDeleteProgram(shaders.spobmarker_earth.program);
   glDeleteProgram(shaders.spobmarker_empty.program);
   glDeleteProgram(shaders.spobmarker_obelisk.program);
   glDeleteProgram(shaders.spobmarker_rhombus.program);
   glDeleteProgram(shaders.spobmarker_triangle.program);
   glDeleteProgram(shaders.spobmarker_uninhabited.program);
   glDeleteProgram(shaders.spobmarker_wormhole.program);
   glDeleteProgram(shaders.status.program);
   glDeleteProgram(shaders.stealthaura.program);
   glDeleteProgram(shaders.stealthmarker.program);
   glDeleteProgram(shaders.stealthoverlay.program);
   glDeleteProgram(shaders.sysmarker.program);
   glDeleteProgram(shaders.targetship.program);
   glDeleteProgram(shaders.targetspob.program);
   glDeleteProgram(shaders.texture.program);
   glDeleteProgram(shaders.texture_bicubic.program);
   glDeleteProgram(shaders.texture_depth.program);
   glDeleteProgram(shaders.texture_depth_only.program);
   glDeleteProgram(shaders.texture_interpolate.program);
   glDeleteProgram(shaders.texture_sharpen.program);
   glDeleteProgram(shaders.texturesdf.program);
   glDeleteProgram(shaders.viewport_frame.program);
   memset(&shaders, 0, sizeof(shaders));
   nsimpleshaders = 0;
}